/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2002 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to the sectionTimer module
 * @file    sectionTimer.h
 * @date    01/02/2002
 * @author  R.Freeman
 */
#ifndef _SECTIONTIMER_H_
#define _SECTIONTIMER_H_


/*--------------------------------  Includes  --------------------------------*/

#include "clDsmSystem.h"


#ifdef __cplusplus
extern "C" {
#endif


/*-----------------------------  Exported Macros  ----------------------------*/

/*------------------------------  Exported Types  ----------------------------*/

/*------------------------------  Exported Data  -----------------------------*/


/*---------------------------  Exported Prototypes  --------------------------*/

E_DscError SectionTimerArm( P_DsmCoreInst idp,
   /*IO*/ P_SecFilterInfo pSectionFilter);

E_DscError sectionTimerUpdate( P_DsmCoreInst idp,
   /*IO*/ P_SecFilterInfo pSectionFilter,
   /*I*/ BOOLEAN completed, BOOLEAN refresh);

E_DscError sectionTimerRemove(  P_DsmCoreInst idp,
   /*I*/ P_SecFilterInfo pSectionFilter);


/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#endif /* _SECTIONTIMER_H_ */
