/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2002 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to siQuery module - functions for managing SI queries
 * @file    siQuery.h
 * @date    07/05/2002
 * @author  N Kirkland
 */
#ifndef _SIQUERY_H_
#define _SIQUERY_H_


/*---includes for this file--------------------------------------------------*/


#include "clDsmSystem.h"
#include "linkList.h"

#ifdef __cplusplus
extern "C" {
#endif


/*---Constant and macro definitions for public use---------------------------*/

#define SI_QUERY_MAGIC    0xC537D89E


/*******************
* EXPORTED TYPES   *
********************/

typedef enum
{
   SIQS_INITIAL = 0,
   SIQS_PENDING,    /* -- Waiting for results to be supplied asynchronously */
   SIQS_COMPLETED,  /* -- Results supplied */
   SIQS_ABORTED,    /* -- Aborted before results supplied */
   SIQS_EXPIRED     /* -- Aborted before results supplied but has duplicates */
} E_SiQueryState;

typedef struct s_SiQuery
{
   S_LLObject llData[NUM_LISTS_SI_QUERY];

   U32BIT magic;
   E_SiQueryState state;

   S_SIQueryRequest query;
   void *target;

   void *queryHandle;                   /* -- External handle */

   P_LLControl llcDuplSiQuerys;            /* -- Only used if original == True */
   BOOLEAN original;                        /* -- original or duplicate (False) */
} S_SiQuery;


/*---Global variable declarations for public use-----------------------------*/

/*---Global Function prototypes for public use---------------------------------*/

E_DscError siQueryStart( P_DsmCoreInst idp,
   /*I*/ P_SIQueryRequest pQueryData, void *queryTarget,
   P_SIQueryResult pResult );

void siQueryAbortPending( P_DsmCoreInst idp, P_SiQuery pSiQueryRef );

void siQueryStop( P_DsmCoreInst idp, P_SiQuery pSiQuery );

E_DscError siQueryProcessResult( P_DsmCoreInst idp, P_SiQuery pSiQueryRef, P_SIQueryResult pResult );

#ifdef GET_PID_LIST
E_DscError siQueryGetPIDList( P_DsmCoreInst idp );
#endif /*GET_PID_LIST*/

/*----------------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
#endif /* _SIQUERY_H_ */
