/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2006 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to dsmStreamEvent module - functions for managing DSM streamEvent
 * @file    streamEvent.h
 * @date    05/17/2006
 * @author  Ocean Blue

 */
#ifndef _STREAMEVENT_H_
#define _STREAMEVENT_H_


/*---includes for this file--------------------------------------------------*/

#include "clDsmSystem.h"

#ifdef __cplusplus
extern "C" {
#endif

/*---Constant and macro definitions for public use---------------------------*/


/*---Global variable declarations for public use-----------------------------*/

/*---Global Function prototypes for public use---------------------------------*/

E_DscError DSC_StrmEventUpdate( P_DsmCoreInst idp, U8BIT *pStreamDescrSection,
   P_Event pEvent, U32BIT targetId );

void DSC_StrmEventFilterReset( P_DsmCoreInst idp );

void DSC_StrmEventListReset( P_DsmCoreInst idp );


/*----------------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
#endif /* _STREAMEVENT_H_ */
