/*******************************************************************************
 * Copyright  2015 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to the Update Carousel module.
 * @file    updateCarousel.h
 * @date    23/02/2015
 * @author  Adam Sturtridge
 */
#ifndef _UPDATECAROUSEL_H_
#define _UPDATECAROUSEL_H_


/*--------------------------------  Includes  --------------------------------*/

#include "rootCarousel.h"

#ifdef __cplusplus
extern "C" {
#endif

/*-----------------------------  Exported Macros  ----------------------------*/


/*------------------------------  Exported Types  ----------------------------*/

typedef struct s_UpdateCarousel
{
   S_RootCarousel root;

   P_LLControl llcGroups;
} S_UpdateCarousel, *P_UpdateCarousel;


/*------------------------------  Exported Data  -----------------------------*/


/*---------------------------  Exported Prototypes  --------------------------*/

/**
 * @brief   Creates an instance of the UpdateCarousel and initialises it.
 * @param   idp DSM core Instance
 * @param   serviceId Service Id on which to find Update Carousel
 * @param   oui Organisation Unique Identifier of manufacturer
 * @param   ppUC Pointer to return Update Carousel
 * @return  E_DscError
 */
E_DscError DSC_UpdCrslCreate( P_DsmCoreInst idp, U16BIT serviceId,
   U32BIT carouselId, P_UpdateCarousel *ppUpdateCarousel );

/**
 * @brief   Destroy UpdateCarousel
 * @param   idp DSM core Instance
 * @param   pUC Pointer to Update Carousel
 */
void DSC_UpdCrslDestroy( P_DsmCoreInst idp, P_UpdateCarousel pUC );

/**
 * @brief   Parse DSI private data from Group Info of Update Carousel
 * @param   idp DSM core Instance
 * @param   pUC Pointer to Update Carousel
 * @param   pDsiPrivate Pointer to DSI private data
 * @param   dsiPrivateLen Length of DSI private data
 * @return  E_DscError
 */
E_DscError DSC_UpdCrslParseGroupInfo( P_DsmCoreInst idp, P_UpdateCarousel pUC,
   U8BIT *pDsiPrivate, U16BIT dsiPrivateLen );

BOOLEAN DSC_UpdCrslCheckCompatibility( P_UpdateCarousel pUC, U8BIT *pCompatDesc,
   U16BIT compatLen );

/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#endif /* _UPDATECAROUSEL_H_ */

