/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Section Filter Manasger (SFM): cache definitions
 * @file    sfm_cache.h
 * @date    16-10-2013
 * @author  Adam Sturtridge
 */
#ifndef _SFM_CACHE_H
#define _SFM_CACHE_H

#include "sfm_main.h"

typedef struct s_TableExt
{
   U16BIT id;
   U16BIT mask;
} S_TableExt;


typedef struct s_CacheTable *H_CacheTable;
typedef struct s_CacheFilter *H_CacheFilter;

H_SfmCache SFMCacheCreate( H_SfmInstance sfm );

H_CacheTable SFMCacheGetTable( H_SfmCache cache );

void SFMCacheDestroy( H_SfmInstance sfm, void **pBufMtx );

BOOLEAN SFMCacheValidHandle( H_SfmInstance sfm, void *ptr );


H_CacheFilter SFMCacheRetrieveFilter( H_SfmInstance sfm, H_CacheTable ctable,
   U16BIT teid, U8BIT vers );

/**
 * @brief   Allocates space in cache for section data
 *          If allocation is made, *phBuffer has holds cache location. If section
 *          already allocated, or insufficient space, then *phBuffer is NULL.
 * @param   H_SfmCache  cache       SFM cache handle.
 * @param   U8BIT       size1       header[1] byte with top bits for section size
 * @param   void**      phBuffer    Pointer to SFM cache filter handle and
 *                                  return param with pointer to node block
 * @return  void.
 */
void SFMCacheAddBlock( H_SfmInstance sfm, U8BIT size1, U8BIT bknum, void **phBuffer );

/**
 * @brief   Search cache for section data
 * @param   H_SfmInstance  sfm            SFM instance handle.
 * @param   H_CacheTable   ctable         Cache table handle
 * @param   S_TableExt     tex            Table Extension ID and mask
 * @return  void.
 */
void SFMCacheSearch( H_SfmInstance sfm, H_CacheTable ctable, S_TableExt tex,
   U16BIT dsmref, E_SFM_STATUS status );

/**
 * @brief
 * @param   H_SfmInstance  sfm         SFM instance handle.
 * @param   U8BIT*         pSection    Pointer to whole section data buffer
 * @param   H_CacheFilter  cfilter     Hande given to F_CacheMatch
 * @return  void.
 */
void SFMCacheProcessSection( H_SfmInstance sfm, U8BIT *pSection, H_CacheFilter cfilter );

#endif /*_SFM_CACHE_H*/
