/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Section Filter Manager (SFM): main definitions
 * @file    sfm_main.h
 * @date    16-10-2013
 * @author  Adam Sturtridge
 */
#ifndef _SFM_MAIN_H
#define _SFM_MAIN_H

#include "dsfm.h"
#include "sfm_debug.h"

typedef struct s_DmxSecFilter *H_DmxSecFilter;
typedef struct s_DsmResource *H_DsmResource;
typedef struct s_SfmCache *H_SfmCache;
typedef struct s_CacheNode *H_CacheNode;


typedef struct s_SfmInstance
{
   S_SfmSetup setup;

   H_DsmCoreInst dsmcc;

   H_SfmCache cache;

   H_DmxPidFilter dmxPidArray;
   H_DmxSecFilter dmxSecArray;

   H_DsmResource dmxResFirst;
   H_DsmResource dmxResLast;

   H_DsmResource freeList;

   H_CacheNode freeNodes;

   DMXREF demux;

   U16BIT pidcounter;
} S_SfmInstance;


#endif /*_SFM_MAIN_H*/
