/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Service Information Query: cache functionality
 * @file    siq_cache.h
 * @date    28-09-2013
 * @author  Adam Sturtridge
 */
#ifndef SIQ_CACHE_H
#define SIQ_CACHE_H

#include "siq_main.h"
#include "siq_pmt.h"

BOOLEAN SIQ_CacheInit( S_SiqInstance *siq );
void SIQ_CacheExit( S_SiqInstance *siq );

H_SiqPmtTable SIQ_CacheRetrievePmt( S_SiqInstance *siq, U16BIT serviceId, U32BIT *dvberr );

void SIQ_CacheClear( S_SiqInstance *siq );

#endif /*SIQ_CACHE_H*/
