/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Service Information Query: debug definitions
 * @file    siq_debug.h
 * @date    28-09-2013
 * @author  Adam Sturtridge
 */
#ifndef SIQ_DEBUG_H
#define SIQ_DEBUG_H

#ifndef NDEBUG

   #include <stdio.h>
 #ifdef DEBUG_ASSERT
   #include "stb_debug.h"
   #define ASSERT(condition)    if (!(condition)) STB_SPDebugAssertFail(__FILE__, __LINE__, # condition);
 #else
   #include <assert.h>
   #define ASSERT(condition)  assert(condition);
 #endif

   #define ERRLOG(x, ...)     if (siq->setup.errPrintf) \
      siq->setup.errPrintf( "%s:%d " x "\n", __FUNCTION__, __LINE__, ##__VA_ARGS__);

   #define DBGLOG(t, x, ...)   if (siq->setup.dbgPrintf && (siq->setup.dbgState & t)) \
      siq->setup.dbgPrintf( "%s:%d " x "\n", __FUNCTION__, __LINE__, ##__VA_ARGS__);

#else

   #define ASSERT(condition)

   #define ERRLOG(x, ...)
   #define DBGLOG(t, x, ...)

#endif

#ifdef DEBUG_FUNCS
   #define FUNCTION_START(x)  DBGLOG(DS_FUNC, " start")
   #define FUNCTION_FINISH(x) DBGLOG(DS_FUNC, " finish")
#else
   #define FUNCTION_START(x)
   #define FUNCTION_FINISH(x)
#endif

#endif /*SIQ_DEBUG_H*/
