/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Service Information Query: main definitions
 * @file    siq_main.h
 * @date    28-09-2013
 * @author  Adam Sturtridge
 */
#ifndef SIQ_MAIN_H
#define SIQ_MAIN_H

#include "dsiq.h"

typedef struct s_SiqSrvInfo *H_SiqSrvInfo;
typedef struct s_SiqRequests *H_SiqRequests;


typedef struct s_SiqInstance
{
   /* Copy of setup data */
   S_SiqSetup setup;

   H_DsmCoreInst dsmInstance;
   DMXREF dmxref;

#ifdef SICHANGED_LIST
   H_SiqSrvInfo srvInfoList;
#endif

   H_SiqRequests queryHead;

   H_SiqCachePat patList;
   H_SiqCachePmt pmtArray;
   U16BIT pmtTotal;
   U16BIT pmtCount;

   U16BIT origNetworkId;
   U16BIT transportId;
} S_SiqInstance;


void SIQ_QueryPmtReceive(S_SiqInstance *siq, U16BIT serviceId, H_SiqPmtTable pmt);

#ifdef OPTIONAL_SICHANGED_FUNCS
void SIQ_SearchServiceInfoList( S_SiqInstance *siq, U16BIT serviceId, U8BIT version );
#endif

void SIQ_DeleteQueriesOnService(S_SiqInstance *siq, U16BIT serviceId);

#endif /*SIQ_MAIN_H*/
