/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Service Information Query: PMT parsing functions
 * @file    siq_pmt.h
 * @date    28 September 2013
 * @author  Adam Sturtridge
 */
#ifndef SIQ_PMT_H
#define SIQ_PMT_H

/*---includes for this file---------------------------------------------------*/
#include "cldsmtypes.h"

/*---Constant and macro definitions for public use----------------------------*/

/* Maximum application types handled in any single App Signalling descriptor */

/*---Enumerations for public use----------------------------------------------*/


/*---Global type defs for public use------------------------------------------*/


/*---Global Function prototypes for public use--------------------------------*/

/**
 * @brief    Create PMT structure for monitoring (life-cycle, NB_Info)
 * @param    U8BIT* data                  Raw PMT section
 * @return   S_SiqPmtTable structure
 */
H_SiqPmtTable SIQ_PmtCreateTable( S_SiqInstance *siq, U8BIT *pmtData );

/**
 * @brief   Destroy PMT structure created by PMT_CreateTable
 * @param   S_SiqInstance*    siq        SIQ instance handle.
 * @param   H_SiqPmtTable     table       Handle to SIQ's PMT table
 * @return  void.
 */
void SIQ_PmtDestroyTable( S_SiqInstance *siq, H_SiqPmtTable table );

/**
 * @brief   Retrieve Information required by Query request from SIQ's PMT table
 * @param   S_SiqInstance*    siq        SIQ instance handle.
 * @param   P_SIQueryRequest    pQuery      Pointer to DSM-CC Query request.
 * @param   H_SiqPmtTable     hpmt        Handle to SIQ's PMT table
 * @param   P_SIQueryResult pResult Pointer to DSM-CC Query Result
 * @return  void
 */
void SIQ_PmtProcessQuery( S_SiqInstance *siq, P_SIQueryRequest pQuery,
   H_SiqPmtTable hpmt, P_SIQueryResult pResult );

/**
 * @brief
 * @param   S_SiqInstance* siq        SIQ instance handle.
 * @param   H_SiqPmtTable  hOldTable
 * @param   H_SiqPmtTable  hNewTable
 * @param   U16BIT         serviceId
 * @return  none.
 */
void SIQ_PmtCheckTableChange( S_SiqInstance *siq, H_SiqPmtTable hOldTable,
   H_SiqPmtTable hNewTable, U16BIT serviceId );

#endif /* SIQ_PMT_H */

