/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief
 * @file    dm_debug.h
 * @date    23/01/2013
 * @author  Ocean Blue
 */
#ifndef _DM_DEBUG_H
#define _DM_DEBUG_H


#ifndef NDEBUG

 #include <stdio.h>
 #include <assert.h>
 #include "stb_debug.h"
 #include "dsm_debug.h"

 #ifdef DEBUG_ASSERT
   #define ASSERT(condition)    if (!(condition)) STB_SPDebugAssertFail(__FILE__, __LINE__, # condition);
 #else
   #include <assert.h>
   #define ASSERT(condition)  assert(condition);
 #endif

 #if DSM_DP_LEVEL >= 1
  #define DBG_ErrorPrintf (F_Printf)STB_SPDebugNoCnWrite
 #else
  #define DBG_ErrorPrintf (F_Printf)NULL
 #endif
 #if DSM_DP_LEVEL >= 2
  #define DBG_WarnPrintf  (F_Printf)STB_SPDebugNoCnWrite
 #else
  #define DBG_WarnPrintf  (F_Printf)NULL
 #endif
 #if DSM_DP_LEVEL >= 3
  #define DBG_DebugPrintf (F_Printf)STB_SPDebugNoCnWrite
 #else
  #define DBG_DebugPrintf (F_Printf)NULL
 #endif
 #if DSM_DP_LEVEL >= 4
  #define DBG_InfoPrintf  (F_Printf)STB_SPDebugNoCnWrite
 #else
  #define DBG_InfoPrintf (F_Printf)NULL
 #endif

 #define ERRPRINT(x, ...) STB_SPDebugWrite( "%s:%d " x, __FUNCTION__, __LINE__, ##__VA_ARGS__);
 #define DBGPRINT(t, x, ...)   if (DebugInstanceGetMask(dsmctrl) & t) \
      STB_SPDebugWrite( "%s:%d " x, __FUNCTION__, __LINE__, ##__VA_ARGS__);

 U32BIT DebugInstanceGetMask(H_DsmControl dsmctrl);

#else

 #define ASSERT(condition)
 #define ERRPRINT(...)
 #define DBGPRINT(...)

 #define DBG_ErrorPrintf NULL
 #define DBG_DebugPrintf NULL

#endif

 #define FUNCTION_START(x)
 #define FUNCTION_FINISH(x)


#endif /*_DM_DEBUG_H*/
