/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Internal header for DSM-CC control module
 * @file    dsm_main.h
 * @date    23/01/2013
 * @author  Ocean Blue
 */
#ifndef _DSM_MAIN_H
#define _DSM_MAIN_H

#include "cldsmcc.h"
#include "stdfuncs.h"

typedef struct s_DsmApi
{
   H_DsmCoreInst cldsm;
   F_MemAlloc memAlloc;
   F_MemFree memFree;
   void *mutex;
} S_DsmApi;

void DsmccObjectLoadEventFunc(
   H_DsmObject objectHandle, E_ObjLoadStatus status,
   H_ObjUserData pUserData );

void DsmccStreamEventFunc( H_DsmEvent eventHandle,
   E_SENotifyStatus status, void *userData1, void *userData2,
   U8BIT *namePtr, U8BIT *dataPtr, U8BIT nameLen, U8BIT dataLen );

#endif /*_DSM_MAIN_H*/
