/* Output the two static dependancy files: .E and .Q  */
/* These are later included in *.P files by sunrise
 * make script immediately after compilation */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

int main(int argc, char *argv[])
{
   FILE *out;
   int flen;
   char *tag, *fnm, *pch, *qch, sch;
   if (argc < 3)
   {
      fprintf(stderr, "Usage:\n\t%s <source name tag> <E output file> ...\n", argv[0]);
      return -1;
   }
   else
   {
      tag = argv[1];
      fnm = argv[2];
      flen = strlen(fnm);
      out = fopen(fnm, "w+");
      if (out == NULL)
      {
         fprintf(stderr, "failed to open file %s\n", fnm);
         return -2;
      }
      else
      {
         fprintf(out, "ODEFS_%s:=", tag);
         for (flen = 3; flen != argc; flen++)
         {
            fnm = argv[flen];
            pch = strchr(fnm, '\"');
            if (pch == NULL)
            {
               fprintf(out, " %s", fnm);
            }
            else
            {
               qch = strchr(pch + 1, '\"');
               if (qch == NULL)
               {
                  fprintf(out, " %s", fnm);
               }
               else
               {
                  *pch = 0;
                  fprintf(out, " %s\'\"", fnm);
                  qch++;
                  if (*qch == 0)
                  {
                     fprintf(out, "%s\'", pch + 1);
                  }
                  else
                  {
                     sch = *qch;
                     *qch = 0;
                     fprintf(out, "%s\'", pch + 1);
                     *qch = sch;
                     fprintf(out, "%s", qch);
                  }
               }
            }
         }
         fprintf(out, "\n");
         fclose(out);
      }
      return 0;
   }
}

