#!/bin/bash

function usage 
{
	echo "Application auto version script"
	echo "Usage: . version.sh <major_version> <minor_version> <template_file> <output_file>"
}

# Check we have been passed 2 parameters
if [ -z "$4" ]; then
	usage
else
	# Set variables to be picked up by app makefile
	export APP_VERSION_MAJOR=`echo -n $1`
	export APP_VERSION_MINOR=`echo -n $2`
	export APP_BUILD_DAY=`date +%-d`
	export APP_BUILD_MONTH=`date +%-m`
	export APP_BUILD_YEAR=`date +%Y`
	export APP_VERSION_INFO=OK

	# Write out version information via AWK script
	awk -f ../../tools/scripts/version.awk $3 > $4.mod
	if [ "$?" == "0" ]; then
		mv -f $4.mod $4
	fi
fi
