### ENVIRONMENT SETUP

DVBCore build system relies on a number of environment variables to be properly set up. Please use example_setenv.sh as an example of environment set up and to read the meaning of all the available variables.

### BUILD

After all the needed variables have been exported, just do 'make' in the top directory. By default, the resulting library will be build/bin/libdvbcore.a, but its location can be changed by using the variable DTVKIT_OUTPUT_DIR

### CONTRIBUTE

In order to get the bug fix or feature integrated, please create Mantis issue
and open a pull request containing propsed changes.

```bash
# one-off global setup
git config --global user.name "Your Name"
git config --global user.email "your_email@example.com"
git config --global push.default simple

# one-off repository setup (create private clone in GitHub first)
git clone git@github.com:YOUR_GITHUB_USER_NAME/DVBCore.git
git remote add upstream git@github.com:DTVKit/DVBCore.git

# create a feature branch named after Mantis issue
git fetch upstream
git checkout -b mantis-XX upstream/master

# commit your changes
git add ...
git commit

# rebase and push
git pull --rebase
git push -f origin
```

Once your commits are on GitHub, please create a pull request via GitHub UI.
Before your changes are merged, the maintainer may request additional
modifications, code clean-up or rebase. There's no need to close and re-open
a pull request. Each "git push" to the same branch updates the pull request.

Please add "Fixes #XX", where "XX" is the mantis issue number to the commit
description and pull request description. This helps tracking the changes.

For more information please see
[using pull requests](https://help.github.com/articles/using-pull-requests) or
the main [help](https://help.github.com/) page.
