# Makefiles including common.mak must ensure the following variables have the appropriate value
# - MODULE_ROOT: absolute path of the DVBCore component
# Makefiles including common.mak can set the following variables
# - MODULE_PREREQUISITES: prerequisites needed by the calling Makefile (which has to define the relative rules)
# - COMP: component name used to create bin/$(COMP)/ for object files and bin/. Missing when included from the top level Makefile

ifeq ($(DTVKIT_CC),)
$(warning DTVKIT_CC not set, using $(CC))
DTVKIT_CC=$(CC)
endif

ifeq ($(DTVKIT_AR),)
$(warning DTVKIT_AR not set, using $(AR))
DTVKIT_AR=$(AR)
endif

DTVKIT_OPTIMISATION_OPTION?=-O2

# CFLAGS is reset here
ifeq ($(DTVKIT_BUILD_MODE),release)
CFLAGS = $(DTVKIT_OPTIMISATION_OPTION)
else
CFLAGS = -g
endif

CFLAGS += $(DTVKIT_ADDITIONAL_COMPILER_OPTIONS)

QUIET ?= @

DFLAG = -MMD

ifneq ($(DTVKIT_USE_STDINT),1)
DEFINES += NO_STDINT_H
endif
ifeq ($(DTVKIT_COLOUR_DEPTH),8)
DEFINES += OSD_8_BIT
else
ifeq ($(DTVKIT_COLOUR_DEPTH),16)
DEFINES += OSD_16_BIT
else
DEFINES += OSD_32_BIT
ifeq ($(DTVKIT_OSD_ST_MODE), 1)
DEFINES += OSD_ST_MODE
endif
endif
endif
ifeq ($(DTVKIT_INTEGRATE_CI),1)
DEFINES += COMMON_INTERFACE
endif


# Hwacom ========================
ifeq ($(DVBC_IPQAM),1)
DEFINES += DVBC_IPQAM
endif

ifeq ($(CUSTOMIZED_FOR_CNS),1)
DEFINES += CUSTOMIZED_FOR_CNS
endif

ifeq ($(ENABLE_LIBDVBPSI),1)
DEFINES += ENABLE_LIBDVBPSI
endif
# ===============================

# Include path common for all the modules -
# and ensure that it is always the first one
INCLUDES := $(MODULE_ROOT)/inc $(INCLUDES)

CFLAGS += $(patsubst %,-W%,$(WARNINGS))
CFLAGS += $(patsubst %,-D%,$(DEFINES))
CFLAGS += $(patsubst %,-I%,$(INCLUDES))

DTVKIT_OUTPUT_DIR?=$(MODULE_ROOT)/build
BIN_BUILD_PATH=$(DTVKIT_OUTPUT_DIR)/bin
SRC_BUILD_PATH=$(DTVKIT_OUTPUT_DIR)/src
INC_BUILD_PATH=$(DTVKIT_OUTPUT_DIR)/inc

# directory to put the *.o *.d *.P files for this component
ifneq ($(COMP),)
OBJDIR = $(BIN_BUILD_PATH)/$(COMP)
endif

# Library name for DVBCore component.
ifneq ($(COMP),)
TRGT_LIB = $(BIN_BUILD_PATH)/lib$(COMP).a
endif

SRCDIR ?= src
DEPF = $(OBJDIR)/$(*F)
CSRCS = $(filter %.c,$(SRCS))
DSRCS = $(filter-out %.c,$(SRCS))
OBJS  = ${CSRCS:%.c=$(OBJDIR)/%.o}
OBJS += ${DSRCS:%=$(OBJDIR)/%.o}

CHECK_HEADERS ?= y

ifneq ($(OBJDIR),)
HEADERS ?= $(shell find . -type f -name '*.h')
HEADER_DIRS = $(sort $(dir $(HEADERS)))
HEADER_OUT_DIRS = $(addprefix $(OBJDIR)/,$(HEADER_DIRS))
HEADERS_CHECKED = $(HEADERS:%.h=$(OBJDIR)/%.h.checked)
endif

DTVKIT_OSTYPE ?= linux-gnu
DTVKIT_TOOLS_PATH ?= $(MODULE_ROOT)/tools/bin/$(DTVKIT_OSTYPE)

ifeq ($(findstring linux-gnu,$(DTVKIT_OSTYPE)),linux-gnu)
 # Determine whether this is a 32 or 64 bit sysyem
 SYS_TYPE = $(shell uname -m)
 ifeq ($(findstring x86_64,$(SYS_TYPE)), x86_64)
  CMD_amsdeps = $(DTVKIT_TOOLS_PATH)/amsdeps64
  CMD_outdeps = $(DTVKIT_TOOLS_PATH)/outdeps64
 else
  CMD_amsdeps = $(DTVKIT_TOOLS_PATH)/amsdeps32
  CMD_outdeps = $(DTVKIT_TOOLS_PATH)/outdeps32
 endif
else
 CMD_amsdeps = $(DTVKIT_TOOLS_PATH)/amsdeps
 CMD_outdeps = $(DTVKIT_TOOLS_PATH)/outdeps
endif

CMD_coan = $(DTVKIT_TOOLS_PATH)/coan

define d_to_g
   @mv $(DEPF).d $(DEPF).g
endef
define d_to_m
   @mv $(DEPF).d $(DEPF).m
endef


# define the commands for compiling ...
define compile
	@echo Compiling $(FULL_SRC_PATH)$<
	$(QUIET)$(DTVKIT_CC) $(DFLAG) $(CFLAGS) -o $@ -c $(FULL_SRC_PATH)$<
	$(d_to_g)
	@cat $(DEPF).g | sed -e 's/#.*//' -e 's/^[^:]*: *//' -e 's/ *\\$$//' -e '/^$$/ d' > $(DEPF).d
	@cat $(DEPF).d | sed -e 's/$$/ :/' > $(DEPF).t;
	$(d_to_m)
	@echo "FDEPS_$(*F)=" > $(DEPF).d
	-@$(CMD_coan) symbols -i -o -f $(DEPF).m 2>/dev/null | sed -e 's/.*_H$$//' -e '/^$$/ d' >> $(DEPF).d
	@cat $(DEPF).d | sed -e :a -e N -e 's/\n/ /' -e ta > $(DEPF).m
	@$(CMD_outdeps) $(*F) $(DEPF).x $(DEFINES)
	@cat $(DEPF).g | sed -e 's/\.\([a-z]*\)$$/.\1 \\/' -e 's/\.c$$/.c \\/' > $(DEPF).d;
	@cat $(DEPF).m $(DEPF).x $(DEPF).N $(DEPF).d $(DEPF).Q $(DEPF).t > $(DEPF).P;
	@rm $(DEPF).d $(DEPF).t $(DEPF).m $(DEPF).g $(DEPF).x
endef

define checkh
	@echo Checking $(FULL_SRC_PATH)$<
	$(QUIET)$(DTVKIT_CC) $(CFLAGS) -o $@ -c $(FULL_SRC_PATH)$<
endef

#
# Psuedo targets
#
.PHONY : force clean

#
# Default target
#
ifeq ($(CHECK_HEADERS),y)
default: $(HEADERS_CHECKED)
endif

default : $(MODULE_PREREQUISITES) $(OBJDIR) $(OBJS:%.o=%.N) $(TRGT_LIB)
	-@rm -f cmd_coan.mk

#
# Rule to create target library
#
$(TRGT_LIB): $(OBJS)
	@echo Building $@
	$(QUIET)$(DTVKIT_AR) rsc $@ $^
	@echo "PREVCSRCS=$(CSRCS:%.c=%)" > $(OBJDIR)/srcs.mk

#
# The compile rule
#
$(OBJDIR)/%.o: $(SRCDIR)/%.c | $(OBJDIR)
	$(compile)

$(OBJDIR)/%.N : $(OBJDIR)/%.E | $(OBJDIR)
	@mv $< $@

$(OBJDIR)/%.N : | $(OBJDIR)
	@echo Generating $(@F)
	@$(CMD_amsdeps) $* $@

$(OBJDIR)/%.h.checked: %.h | $(HEADER_OUT_DIRS)
	$(checkh)

#
# Rule to make required directories
#
$(OBJDIR) $(BIN_BUILD_PATH) $(INC_BUILD_PATH) $(SRC_BUILD_PATH) $(HEADER_OUT_DIRS):
	@echo Creating $@
	@mkdir -p $@

common_clean: module_clean
	rm -rf $(BIN_BUILD_PATH)/$(COMP)
	rm -rf $(TRGT_LIB)
	-rmdir $(BIN_BUILD_PATH)
	-rmdir $(INC_BUILD_PATH)
	-rmdir $(SRC_BUILD_PATH)

-include $(OBJS:%.o=%.P)

