/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header file - Function prototypes for check sum calcs
 *
 * @file    stbcsum.h
 * @date    14/10/2000
 */

// pre-processor mechanism so multiple inclusions don't cause compilation error

#ifndef _STBCSUM_H

#define _STBCSUM_H

#include "techtype.h"

//---Constant and macro definitions for public use-----------------------------

//---Enumerations for public use-----------------------------------------------

//---Global type defs for public use-------------------------------------------

//---Global Function prototypes for public use---------------------------------

U8BIT STB_CalcChecksum(U8BIT *data_ptr, U32BIT data_size);
BOOLEAN STB_CheckChecksum(U8BIT *data_ptr, U32BIT data_size);

U16BIT STB_GetBE16Bit(U16BIT *addr);
void STB_SetBE16Bit(U16BIT *addr, U16BIT value);

#endif //  _STBCSUM_H

//*****************************************************************************
// End of file
//*****************************************************************************

