/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header file - Function prototypes for NVM database
 *
 * @file    stbdbnvm.h
 * @date    06/09/2000
 */

// pre-processor mechanism so multiple inclusions don't cause compilation error

#ifndef _STBDBNVM_H

#define _STBDBNVM_H

#include "techtype.h"
#include "dba_nvm.h"

//---Constant and macro definitions for public use-----------------------------

#define NVM_INVALID_BLOCK_ID       0xffff

//---Enumerations for public use-----------------------------------------------

//---Global type defs for public use-------------------------------------------

//---Global Function prototypes for public use---------------------------------

void STB_InitNVMAccess(U16BIT offset);
void STB_InitNVMMap(void);
BOOLEAN STB_CheckNVMDatabaseIntegrity(void);
void STB_SetNVMAccessRAM(U8BIT *ram_ptr);
U8BIT* STB_GetNVMAccessRAM(void);

U16BIT STB_GetNVMBlockCount(void);
U16BIT STB_GetNVMBlocksUsed(void);
U16BIT STB_GetNVMBlockSize(void);
U16BIT STB_GetNVMBlocksNeeded(U16BIT size);

U16BIT STB_CreateNVMRecord(U8BIT rec_id, U16BIT size);
void STB_DestroyNVMRecord(U16BIT block_no);

void STB_SetNextNVMBlock(U16BIT block_no, U16BIT next_block);
U16BIT STB_GetNextNVMBlock(U16BIT block_no);

U16BIT STB_FindNVMRecordFromId(U8BIT rec_id, U16BIT last_blk);

void STB_NVMChanged(BOOLEAN state);
void STB_NVMFlushCache(BOOLEAN clear);
void STB_NVMSave(void);

void STB_SetNVMRecordString(U16BIT block_no, U16BIT offset, U16BIT size, U8BIT *string);
void STB_SetNVMRecordNumber(U16BIT block_no, U16BIT offset, U16BIT size, U32BIT value);

U8BIT* STB_GetNVMRecordString(U16BIT block_no, U16BIT offset, U16BIT size);
U32BIT STB_GetNVMRecordNumber(U16BIT block_no, U16BIT offset, U16BIT size);

void STB_WriteNVMData(U16BIT offset, U16BIT size, U8BIT *data_ptr);
BOOLEAN STB_ReadNVMData(U16BIT offset, U16BIT size, U8BIT *data_ptr);

#endif //  _STBDBNVM_H

//*****************************************************************************
// End of file
//*****************************************************************************

