/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header file - Function prototypes for RAM database
 *
 * @file    stbdbram.h
 * @date    06/09/2000
 */

// pre-processor mechanism so multiple inclusions don't cause compilation error

#ifndef _STBDBRAM_H

#define _STBDBRAM_H

#include "techtype.h"
#include "dba_nvm.h"

//---Constant and macro definitions for public use-----------------------------

//---Enumerations for public use-----------------------------------------------

//---Global type defs for public use-------------------------------------------

//---Global Function prototypes for public use---------------------------------

void STB_InitRAMAccess(void);
void STB_PurgeRAMRecords(void);

void* STB_CreateRAMRecord(U8BIT rec_id, U16BIT size, U16BIT nvm_block, void *parent);
void STB_DestroyRAMRecord(void *rec_ptr);

U8BIT STB_GetRAMRecordId(void *rec_ptr);
U16BIT STB_GetRAMRecordNVMBlock(void *rec_ptr);
U16BIT STB_GetRAMRecordPrevNVMBlock(void *rec_ptr);
U16BIT STB_GetRAMRecordNextNVMBlock(void *rec_ptr);
void* STB_GetRAMRecordParent(void *rec_ptr);
void STB_SetRAMRecordParent(void *rec_ptr, void *parent);

void STB_MoveRAMRecordBefore(void *rec_ptr, void *dst_ptr);
void STB_MoveRAMRecordAfter(void *rec_ptr, void *dst_ptr);

void* STB_FindRAMRecordFromId(U8BIT rec_id, void *parent, void *last_rec);
void* STB_FindRAMRecordFromNVMBlock(U16BIT nvm_block);

void STB_SetRAMRecordString(void *rec_ptr, U16BIT offset, U16BIT size, U8BIT *string);
void STB_SetRAMRecordNumber(void *rec_ptr, U16BIT offset, U16BIT size, U32BIT value);
void STB_SetRAMRecordPointer(void *rec_ptr, U16BIT offset, void* ptr);

U8BIT* STB_GetRAMRecordString(void *rec_ptr, U16BIT offset, U16BIT size);
U32BIT STB_GetRAMRecordNumber(void *rec_ptr, U16BIT offset, U16BIT size);
void*  STB_GetRAMRecordPointer(void *rec_ptr, U16BIT offset);

#endif //  _STBDBRAM_H

//*****************************************************************************
// End of file
//*****************************************************************************

