/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header file - Function prototypes for NVM control
 *
 * @file    stbnvm.h
 * @date    06/09/2000
 */
#ifndef _STBNVM_H

#define _STBNVM_H

#include "techtype.h"

//---Constant and macro definitions for public use-----------------------------

//---Enumerations for public use-----------------------------------------------

//---Global type defs for public use-------------------------------------------

//---Global Function prototypes for public use---------------------------------

void STB_NVMInitialise(void);

/**
 * @brief   Returns the number of bytes of data stored for the given data block
 * @param   data_block_id data block identifier
 * @return  size in bytes
 */
U32BIT STB_NVMGetDataBlockSize(U32BIT data_block_id);

/**
 * @brief   Reads data bytes for the given data block from NVM
 * @param   data_block_id data block from which the data is to be read
 * @param   num_bytes number of bytes to be read
 * @param   dest_addr buffer to read the data into
 * @return  TRUE if the data is read, FALSE otherwise
 */
BOOLEAN STB_NVMDataBlockRead(U32BIT data_block_id, U32BIT bytes, U8BIT *dest_addr);

/**
 * @brief   Writes data bytes for the given data block to NVM
 * @param   data_block_id data block to be written
 * @param   num_bytes number of bytes to be written
 * @param   src_addr data to be written
 * @return  TRUE if the data is written, FALSE otherwise
 */
BOOLEAN STB_NVMDataBlockWrite(U32BIT data_block_id, U32BIT num_bytes, U8BIT *src_addr);

#if 0
U32BIT STB_NVMGetDvbSize(void);
BOOLEAN STB_NVMDvbRead(U32BIT offset, U32BIT bytes, U8BIT *dest_addr);
BOOLEAN STB_NVMDvbWrite(U32BIT offset, U32BIT bytes, U8BIT *src_addr);
#endif

U32BIT STB_NVMGetSTBSize(void);
BOOLEAN STB_NVMSTBRead(U32BIT offset, U32BIT bytes, U8BIT *dest_addr);
BOOLEAN STB_NVMSTBWrite(U32BIT offset, U32BIT bytes, U8BIT *src_addr);

#endif //  _STBNVM_H

//*****************************************************************************
// End of file
//*****************************************************************************

