/*******************************************************************************
 * Copyright © 2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright © 2013 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Database layout
 * @file    layout.c
 * @date    01/01/2017
 * @author  Ocean Blue
 */

#include <sqlite3.h>

#include "dba.h"
#include "database.h"

const S32BIT database_layout_version = 5;

const S_DATA_TYPE database_type_uint = {SQLITE_INTEGER, "INT"};
const S_DATA_TYPE database_type_text = {SQLITE_TEXT, "TEXT"};
const S_DATA_TYPE database_type_blob = {SQLITE_BLOB, "BLOB"};

static const S_COLUMN table_record_lnb[] =
{
   {DBA_FIELD_LNB_TYPE, &database_type_uint},
   {DBA_FIELD_LNB_POWER, &database_type_uint},
   {DBA_FIELD_LNB_22K, &database_type_uint},
   {DBA_FIELD_LNB_12V, &database_type_uint},
   {DBA_FIELD_LNB_PULSEPOSN, &database_type_uint},
   {DBA_FIELD_LNB_DISPOSN, &database_type_uint},
   {DBA_FIELD_LNB_DISTONE, &database_type_uint},
   {DBA_FIELD_LNB_DISCSWITCH, &database_type_uint},
   {DBA_FIELD_LNB_DISUSWITCH, &database_type_uint},
   {DBA_FIELD_LNB_DISSMATV, &database_type_uint},
   {DBA_FIELD_LNB_DISREPEAT, &database_type_uint},
   {DBA_FIELD_LNB_UNICABLEFREQ, &database_type_uint},
   {DBA_FIELD_LNB_UNICABLECHAN, &database_type_uint},
   {DBA_FIELD_LNB_NAME, &database_type_text}
};

static const S_COLUMN table_record_satellite[] =
{
   {DBA_FIELD_SAT_DISH, &database_type_uint},
   {DBA_FIELD_SAT_LONGWE, &database_type_uint},
   {DBA_FIELD_SAT_LONGPOS, &database_type_uint},
   {DBA_FIELD_REC_NAME, &database_type_text}
};

static const S_COLUMN table_record_network[] =
{
   {DBA_FIELD_NET_ID, &database_type_uint},
   {DBA_FIELD_VERSION, &database_type_uint},
   {DBA_FIELD_ORIG_NET_ID, &database_type_uint},
   {DBA_FIELD_PROFILE_TYPE, &database_type_uint},
   {DBA_FIELD_PROFILE_CAM_ID, &database_type_uint},
   {DBA_FIELD_OPERATOR_SEARCH, &database_type_uint},
   {DBA_FIELD_OP_SEARCH_DATE, &database_type_uint},
   {DBA_FIELD_OP_SEARCH_TIME, &database_type_uint},
   {DBA_FIELD_FAVLIST_ID, &database_type_uint},
   {DBA_FIELD_REC_NAME, &database_type_text},
   {DBA_FIELD_PROFILE_NAME, &database_type_uint}
};

static const S_COLUMN table_record_sat_transport[] =
{
   {DBA_FIELD_TRAN_FREQ, &database_type_uint},
   {DBA_FIELD_TRAN_SRATE, &database_type_uint},
   {DBA_FIELD_STRAN_POL, &database_type_uint},
   {DBA_FIELD_STRAN_FEC, &database_type_uint},
   {DBA_FIELD_TRANSPORT_ID, &database_type_uint},
   {DBA_FIELD_ORIG_NET_ID, &database_type_uint},
   {DBA_FIELD_STRAN_MODULATION, &database_type_uint},
   {DBA_FIELD_STRAN_DVBS2, &database_type_uint},
   {DBA_FIELD_TRAN_SIGNAL_STRENGTH, &database_type_uint},
   {DBA_FIELD_TRAN_SIGNAL_QUALITY, &database_type_uint},
   {DBA_FIELD_VERSION, &database_type_uint}
};

static const S_COLUMN table_record_terr_transport[] =
{
   {DBA_FIELD_TRANSPORT_ID, &database_type_uint},
   {DBA_FIELD_ORIG_NET_ID, &database_type_uint},
   {DBA_FIELD_TRAN_FREQ, &database_type_uint},
   {DBA_FIELD_TTRAN_MODE, &database_type_uint},
   {DBA_FIELD_TTRAN_BWIDTH, &database_type_uint},
   {DBA_FIELD_TRAN_SIGNAL_STRENGTH, &database_type_uint},
   {DBA_FIELD_TRAN_SIGNAL_QUALITY, &database_type_uint},
   {DBA_FIELD_TTRAN_TERR_TYPE, &database_type_uint},
   {DBA_FIELD_TTRAN_PLP_ID, &database_type_uint},
   {DBA_FIELD_VERSION, &database_type_uint}
};

static const S_COLUMN table_record_cab_transport[] =
{
   {DBA_FIELD_TRANSPORT_ID, &database_type_uint},
   {DBA_FIELD_ORIG_NET_ID, &database_type_uint},
   {DBA_FIELD_TRAN_FREQ, &database_type_uint},
   {DBA_FIELD_TRAN_SRATE, &database_type_uint},
   {DBA_FIELD_CTRAN_MODE, &database_type_uint},
   {DBA_FIELD_TRAN_SIGNAL_STRENGTH, &database_type_uint},
   {DBA_FIELD_TRAN_SIGNAL_QUALITY, &database_type_uint},
   {DBA_FIELD_VERSION, &database_type_uint}
};

static const S_COLUMN table_record_service[] =
{
   {DBA_FIELD_SERV_ID, &database_type_uint},
   {DBA_FIELD_SERV_TYPE, &database_type_uint},
   {DBA_FIELD_SERV_LCN, &database_type_uint},
   {DBA_FIELD_SERV_REQ_LCN, &database_type_uint},
   {DBA_FIELD_SERV_FAV_GROUPS, &database_type_uint},
   {DBA_FIELD_SERV_HIDDEN, &database_type_uint},
   {DBA_FIELD_SERV_SELECTABLE, &database_type_uint},
   {DBA_FIELD_SERV_LOCKED, &database_type_uint},
   {DBA_FIELD_SERV_SCHED_DISABLED, &database_type_uint},
   {DBA_FIELD_SERV_NOWNEXT_DISABLED, &database_type_uint},
   {DBA_FIELD_SERV_FREESAT_ID, &database_type_uint},
   {DBA_FIELD_SERV_REGION_ID, &database_type_uint},
   {DBA_FIELD_SERV_LCN_EDITABLE, &database_type_uint},
   {DBA_FIELD_SERV_DELETED, &database_type_uint},
   {DBA_FIELD_REC_NAME, &database_type_text}
};

static const S_COLUMN table_record_timer[] =
{
   {DBA_FIELD_TIMER_HANDLE, &database_type_uint},
   {DBA_FIELD_TIMER_DISKID, &database_type_uint},
   {DBA_FIELD_TIMER_EVENTID, &database_type_uint},
   {DBA_FIELD_ORIG_NET_ID, &database_type_uint},
   {DBA_FIELD_TRANSPORT_ID, &database_type_uint},
   {DBA_FIELD_SERVICE_ID, &database_type_uint},
   {DBA_FIELD_TIMER_STARTTIME, &database_type_uint},
   {DBA_FIELD_TIMER_DURATION, &database_type_uint},
   {DBA_FIELD_TIMER_TYPE, &database_type_uint},
   {DBA_FIELD_TIMER_FREQUENCY, &database_type_uint},
   {DBA_FIELD_TIMER_RAMPVOLUME, &database_type_uint},
   {DBA_FIELD_TIMER_MISSED, &database_type_uint},
   {DBA_FIELD_CRID_RECOMMENDED, &database_type_uint},
   {DBA_FIELD_TIMER_EVENT_TRIGGERED, &database_type_uint},
   {DBA_FIELD_TIMER_NOTIFY_TIME, &database_type_uint},
   {DBA_FIELD_TIMER_START_PADDING, &database_type_uint},
   {DBA_FIELD_TIMER_END_PADDING, &database_type_uint},
   {DBA_FIELD_TIMER_DO_NOT_DELETE, &database_type_uint},
   {DBA_FIELD_REC_NAME, &database_type_text},
   {DBA_FIELD_TIMER_CRID, &database_type_text},
   {DBA_FIELD_TIMER_OTHERCRID, &database_type_text},
   {DBA_FIELD_TIMER_ADDITIONAL_INFO, &database_type_text}
};

static const S_COLUMN table_record_crid[] =
{
   {DBA_FIELD_CRID_EIT_DATE, &database_type_uint},
   {DBA_FIELD_TIMER_STARTTIME, &database_type_uint},
   {DBA_FIELD_SERVICE_ID, &database_type_uint},
   {DBA_FIELD_CRID_SERIES, &database_type_uint},
   {DBA_FIELD_CRID_RECOMMENDED, &database_type_uint},
   {DBA_FIELD_CRID_DO_NOT_DELETE, &database_type_uint},
   {DBA_FIELD_REC_NAME, &database_type_text},
   {DBA_FIELD_TIMER_CRID, &database_type_text}
};

static const S_COLUMN table_record_fav_list[] =
{
   {DBA_FIELD_FAVLIST_ID, &database_type_uint},
   {DBA_FIELD_FAVLIST_INDEX, &database_type_uint},
   {DBA_FIELD_FAVLIST_USER_DATA, &database_type_uint},
   {DBA_FIELD_REC_NAME, &database_type_text}
};

static const S_COLUMN table_record_fav_serv[] =
{
   {DBA_FIELD_FAVLIST_ID, &database_type_uint},
   {DBA_FIELD_FAVLIST_INDEX, &database_type_uint}
};

static const S_COLUMN table_record_lnb_band[] =
{
   {DBA_FIELD_BAND_POLARITY, &database_type_uint},
   {DBA_FIELD_BAND_MIN_FREQUENCY, &database_type_uint},
   {DBA_FIELD_BAND_MAX_FREQUENCY, &database_type_uint},
   {DBA_FIELD_BAND_LOCAL_OSC_FREQUENCY, &database_type_uint},
   {DBA_FIELD_BAND_LNB_VOLTAGE, &database_type_uint},
   {DBA_FIELD_BAND_22_KHZ, &database_type_uint}
};

static const S_COLUMN table_record_cicam_timer[] =
{
   {DBA_FIELD_PROFILE_CAM_ID, &database_type_uint},
   {DBA_FIELD_TIMER_HANDLE, &database_type_uint}
};

/* A table must appear after any intended parent type. A record cannot be of the same type as its parent */
const S_TABLE database_layout[] =
{
   {DBA_RECORD_LNB, table_record_lnb, ARRAY_LENGTH(table_record_lnb)},
   {DBA_RECORD_SATELLITE, table_record_satellite, ARRAY_LENGTH(table_record_satellite)},
   {DBA_RECORD_NETWORK, table_record_network, ARRAY_LENGTH(table_record_network)},
   {DBA_RECORD_SAT_TRANSPORT, table_record_sat_transport, ARRAY_LENGTH(table_record_sat_transport)},
   {DBA_RECORD_TERR_TRANSPORT, table_record_terr_transport, ARRAY_LENGTH(table_record_terr_transport)},
   {DBA_RECORD_CAB_TRANSPORT, table_record_cab_transport, ARRAY_LENGTH(table_record_cab_transport)},
   {DBA_RECORD_SERVICE, table_record_service, ARRAY_LENGTH(table_record_service)},
   {DBA_RECORD_TIMER, table_record_timer, ARRAY_LENGTH(table_record_timer)},
   {DBA_RECORD_CRID, table_record_crid, ARRAY_LENGTH(table_record_crid)},
   {DBA_RECORD_FAV_LIST, table_record_fav_list, ARRAY_LENGTH(table_record_fav_list)},
   {DBA_RECORD_FAV_SERV, table_record_fav_serv, ARRAY_LENGTH(table_record_fav_serv)},
   {DBA_RECORD_LNB_BAND, table_record_lnb_band, ARRAY_LENGTH(table_record_lnb_band)},
   {DBA_RECORD_CICAM_TIMER, table_record_cicam_timer, ARRAY_LENGTH(table_record_cicam_timer)}
};

const U32BIT database_layout_length = ARRAY_LENGTH(database_layout);

