/*******************************************************************************
 * Copyright  2016 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   application level common header
 * @file    ap_common.h
 * @date    30/09/2016
 */

// pre-processor mechanism so multiple inclusions don't cause compilation error
#ifndef _AP_COMMON_H
#define _AP_COMMON_H

#include "techtype.h"

//---Constant and macro definitions for public use-----------------------------

//---Enumerations for public use-----------------------------------------------

//---Global type defs for public use-------------------------------------------

typedef struct s_dvb_subt_info
{
   U16BIT cpage;
   U16BIT apage;
} S_DVB_SUBT_INFO;

typedef struct s_teletext_subt
{
   U8BIT magazine;
   U8BIT page;
} S_TELETEXT_INFO;

typedef struct
{
   BOOLEAN is_dvb_subt;
   union
   {
      S_DVB_SUBT_INFO subt;
      S_TELETEXT_INFO ttxt;
   } u;
} ADB_SUBT_INFO;

//---Global Function prototypes for public use---------------------------------

#endif /*_AP_COMMON_H*/
