/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2010 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Contains the initialise functions for IP
 * @file    ap_ipadd.h
 * @date    27/04/2010
 * @author  Ocean Blue
 */

#ifndef _AP_IPADD_H
#define _AP_IPADD_H

#include "techtype.h"

typedef enum
{
   IP_DHCP,
   IP_STATIC
} E_STB_IP_MODE;

/**
 * @brief   Connect to network based on IP_MODE from NVM e.g. restore from IP NVM and connect to
 *          network
 * @param   wait_for_completion if TRUE and the mode is DHCP this function blocks until the DHCP
 *          has returned a result
 */
void AIP_ConnectToNetwork(BOOLEAN wait_for_completion);

#endif
