/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Application header file
 *
 *          **************************************************************************************************
 * @file    app.h
 * @date    01/12/2004
 * @author  Ocean Blue
 */

#ifndef _APP_H
#define _APP_H

#include "techtype.h"

//---CONSTANT DEFINITIONS---------------------------------------------------------------------------
// application events
#define EV_SERVICE_NOT_RUNNING         0x0001
#define EV_SERVICE_AUDIO_PID_UPDATE    0x0002
#define EV_SERVICE_VIDEO_PID_UPDATE    0x0003
#define EV_SERVICE_SUBTITLE_UPDATE     0x0004
#define EV_SERVICE_SCRAMBLE_CHANGE     0x0005
#define EV_SERVICE_ANALOG_LOCKED       0x0006
#define EV_INDICATION_STATUS           0x0007
#define EV_SERVICE_ANALOG_STARTED      0x0008
#define EV_SERVICE_RUNNING             0x0009
#define EV_SERVICE_EIT_NOW_UPDATE      0x000a
#define EV_SERVICE_EIT_SCHED_UPDATE    0x000b
#define EV_SERVICE_ECM_PID_UPDATE      0x000c
#define EV_PVR_RECORDING_FAILED        0x000d
#define EV_SERVICE_VIDEO_CODEC_CHANGED 0x000e
#define EV_SERVICE_AUDIO_CODEC_CHANGED 0x000f
#define EV_SERVICE_CHANGED             0x0010
#define EV_SERVICE_STREAMS_CHANGED     0x0011
#define EV_SERVICE_SI_PID_UPDATE       0x0012
#define EV_TIME_CHANGED                0x0013
#define EV_CIPLUS_TUNE_COMPLETED       0x0014
#define EV_SERVICE_DELETED             0x0015
#define EV_TIMER_TRIGGERED             0x0016
#define EV_DECODE_PAUSED               0x0017
#define EV_DECODE_RESUMED              0x0018
#define EV_SWITCH_ALTERNATIVE_SERVICE  0x0019
#define EV_SERVICE_UPDATED             0x001a
#define EV_START_SERVICE_SEARCH        0x001b
#define EV_START_SSU_SEARCH            0x001c
#define EV_PVR_RECORDING_STARTED       0x001d
#define EV_PVR_RECORDING_STOPPED       0x001e
#define EV_PVR_BOOKING_CREATED         0x001f
#define EV_PVR_BOOKING_DELETED         0x0020
#define EV_PVR_RECORDING_DELETED       0x0021
#define EV_DELETE_SERVICE              0x0022   /* Service can't be deleted by DVBCore */
#define EV_SERVICE_MOVED               0x0023   /* Service has changed transport; retune is required to stay on it */
#define EV_SERVICE_ADDED               0x0024   /* Service has been added dynamically */
//
#define EV_SSU_UPDATE_DETECTED         0x00E0
#define EV_PVR_PLAY_STARTED            0x00E1
#define EV_PVR_PLAY_STOPPED            0x00E2
#define EV_PVR_PLAY_BOF                0x00E3
#define EV_PVR_PLAY_EOF                0x00E4

#define APP_EVENT_SERVICE_NOT_RUNNING           EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_NOT_RUNNING)
#define APP_EVENT_SERVICE_AUDIO_PID_UPDATE      EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_AUDIO_PID_UPDATE)
#define APP_EVENT_SERVICE_VIDEO_PID_UPDATE      EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_VIDEO_PID_UPDATE)
#define APP_EVENT_SERVICE_SUBTITLE_UPDATE       EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_SUBTITLE_UPDATE)
#define APP_EVENT_SERVICE_SCRAMBLE_CHANGE       EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_SCRAMBLE_CHANGE)
#define APP_EVENT_SERVICE_ANALOG_LOCKED         EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_ANALOG_LOCKED)
#define APP_EVENT_SERVICE_ANALOG_STARTED        EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_ANALOG_STARTED)
#define APP_EVENT_INDICATION_STATUS             EVENT_CODE(EV_CLASS_APPLICATION, EV_INDICATION_STATUS)
#define APP_EVENT_SERVICE_RUNNING               EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_RUNNING)
#define APP_EVENT_SERVICE_EIT_NOW_UPDATE        EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_EIT_NOW_UPDATE)
#define APP_EVENT_SERVICE_EIT_SCHED_UPDATE      EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_EIT_SCHED_UPDATE)
#define APP_EVENT_SERVICE_ECM_PID_UPDATE        EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_ECM_PID_UPDATE)
#define APP_EVENT_PVR_RECORDING_FAILED          EVENT_CODE(EV_CLASS_APPLICATION, EV_PVR_RECORDING_FAILED)
#define APP_EVENT_SERVICE_VIDEO_CODEC_CHANGED   EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_VIDEO_CODEC_CHANGED)
#define APP_EVENT_SERVICE_AUDIO_CODEC_CHANGED   EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_AUDIO_CODEC_CHANGED)
#define APP_EVENT_SERVICE_CHANGED               EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_CHANGED)
#define APP_EVENT_SERVICE_STREAMS_CHANGED       EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_STREAMS_CHANGED)
#define APP_EVENT_SERVICE_SI_PID_UPDATE         EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_SI_PID_UPDATE)
#define APP_EVENT_TIME_CHANGED                  EVENT_CODE(EV_CLASS_APPLICATION, EV_TIME_CHANGED)
#define APP_EVENT_CIPLUS_TUNE_COMPLETED         EVENT_CODE(EV_CLASS_APPLICATION, EV_CIPLUS_TUNE_COMPLETED)
#define APP_EVENT_SERVICE_DELETED               EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_DELETED)
#define APP_EVENT_TIMER_TRIGGERED               EVENT_CODE(EV_CLASS_APPLICATION, EV_TIMER_TRIGGERED)
#define APP_EVENT_DECODE_PAUSED                 EVENT_CODE(EV_CLASS_APPLICATION, EV_DECODE_PAUSED)
#define APP_EVENT_DECODE_RESUMED                EVENT_CODE(EV_CLASS_APPLICATION, EV_DECODE_RESUMED)
#define APP_EVENT_SWITCH_ALTERNATIVE_SERVICE    EVENT_CODE(EV_CLASS_APPLICATION, EV_SWITCH_ALTERNATIVE_SERVICE)
#define APP_EVENT_SERVICE_UPDATED               EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_UPDATED)
#define APP_EVENT_START_SERVICE_SEARCH          EVENT_CODE(EV_CLASS_APPLICATION, EV_START_SERVICE_SEARCH)
#define APP_EVENT_START_SSU_SEARCH              EVENT_CODE(EV_CLASS_APPLICATION, EV_START_SSU_SEARCH)
#define APP_EVENT_PVR_RECORDING_STARTED         EVENT_CODE(EV_CLASS_APPLICATION, EV_PVR_RECORDING_STARTED)
#define APP_EVENT_PVR_RECORDING_STOPPED         EVENT_CODE(EV_CLASS_APPLICATION, EV_PVR_RECORDING_STOPPED)
#define APP_EVENT_PVR_BOOKING_CREATED           EVENT_CODE(EV_CLASS_APPLICATION, EV_PVR_BOOKING_CREATED)
#define APP_EVENT_PVR_BOOKING_DELETED           EVENT_CODE(EV_CLASS_APPLICATION, EV_PVR_BOOKING_DELETED)
#define APP_EVENT_PVR_RECORDING_DELETED         EVENT_CODE(EV_CLASS_APPLICATION, EV_PVR_RECORDING_DELETED)
#define APP_EVENT_DELETE_SERVICE                EVENT_CODE(EV_CLASS_APPLICATION, EV_DELETE_SERVICE)
#define APP_EVENT_SERVICE_MOVED                 EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_MOVED)
#define APP_EVENT_SERVICE_ADDED                 EVENT_CODE(EV_CLASS_APPLICATION, EV_SERVICE_ADDED)
//
#define APP_EVENT_SSU_UPDATE_DETECTED           EVENT_CODE(EV_CLASS_APPLICATION, EV_SSU_UPDATE_DETECTED)
#define APP_EVENT_PVR_PLAY_STARTED              EVENT_CODE(EV_CLASS_APPLICATION, EV_PVR_PLAY_STARTED)
#define APP_EVENT_PVR_PLAY_STOPPED              EVENT_CODE(EV_CLASS_APPLICATION, EV_PVR_PLAY_STOPPED)
#define APP_EVENT_PVR_PLAY_BOF                  EVENT_CODE(EV_CLASS_APPLICATION, EV_PVR_PLAY_BOF)
#define APP_EVENT_PVR_PLAY_EOF                  EVENT_CODE(EV_CLASS_APPLICATION, EV_PVR_PLAY_EOF)


#define DISK_NAME_LEN               40    /* Max length for the name of a disk */

//---TYPEDEFS-STRUCTS-ENUMERATIONS------------------------------------------------------------------
typedef enum
{
   ACB_GET_SUBTITLE_PREF,
   ACB_GET_AD_PREF,
   ACB_GET_UI_LANG_PREF,
   ACB_GET_UI_BANNER_TRANSPARENCY,
   ACB_GET_UI_BANNER_TIMEOUT,
   ACB_GET_UI_SERVICE_MODE,
   ACB_NUM_INFO_TYPES
} E_ACB_INFO_TYPE;

typedef enum
{
   ACB_SERVICE_LIST_ALL,     /* All or any service type */
   ACB_SERVICE_LIST_TV_DATA, /* TV (including data) service type */
   ACB_SERVICE_LIST_RADIO    /* Radio service type */
} E_ACB_SERVICE_LIST_TYPE;

typedef struct
{
   BOOLEAN pref;
} S_ACB_SUBTITLE_PREF;

typedef struct
{
   BOOLEAN pref;
} S_ACB_AD_PREF;

typedef struct
{
   E_ACB_INFO_TYPE type;
   union
   {
      S_ACB_SUBTITLE_PREF subtitle;
      S_ACB_AD_PREF ad;
      U8BIT ui_lang_id;
      S32BIT banner_transparency;
      S32BIT banner_timeout;
      E_ACB_SERVICE_LIST_TYPE serv_type;
   } u;
} S_ACB_UI_INFO;

typedef enum
{
   DVB_INIT_NO_TELETEXT_OR_SUBTITLES,
   DVB_INIT_TELETEXT_ONLY,
   DVB_INIT_SUBTITLES_ONLY,
   DVB_INIT_TELETEXT_AND_SUBTITLES
} E_DVB_INIT_SUBS_TTXT;

/*!**************************************************************************
 * @brief   Callback function implemented in the UI. This function is called
 *          by the DVB module to query values defined in the UI (e.g. user
 *          preferences)
 * @param   S_ACB_UI_INFO (IN/OUT) pointer to the structure that contains
 *          the type of request and other fields to exchange information
 *          between the DVB and the UI. These fields can be input or output
 *          values depending on the query type.
 * @return  TRUE if the information is returned, FALSE otherwise
 ****************************************************************************/
typedef BOOLEAN (*ACB_INFO_CALLBACK)(S_ACB_UI_INFO *info);

/**
 * @brief The event notification callback function.
 *
 * Each registered function is called by the DVBCore to notify about DVB events.
 *
 * @param event Event ID, as defined in stberc.h
 * @param event_data Optional, event-specific data
 * @param data_size size of the event_data
 */
typedef void (*DVB_EVENT_HANDLER)(U32BIT event, void *event_data, U32BIT data_size);

//---DEFINE THE GLOBAL VARIABLES--------------------------------------------------------------------

//---FUNCTION PROTOTYPES----------------------------------------------------------------------------

/**
 * @brief   Main function to initialise the DVB.
 * @param   event_handler Callback function used to pass events to the UI.
 *                        If non-NULL value is passed-in the APP_RegisterDVBEventHandler()
 *                        is called in order to register the 1st event handler.
 * @param   subs_ttxt defines whether DVB subtitles and/or EBU teletext are to be supported
 * @return  TRUE if initialisation succeeds, FALSE otherwise.
 * @see APP_RegisterDVBEventHandler
 */
BOOLEAN APP_InitialiseDVB(DVB_EVENT_HANDLER event_handler, E_DVB_INIT_SUBS_TTXT subs_ttxt);

#if 0
void APP_TerminateDVB(void);
#endif

/**
 * @brief Register for DVB event notifications.
 *
 * Multiple clients can register their own event handlers. Each new handler
 * is added at the end of the list. For each event all registered handlers all
 * called.
 *
 * @param event_handler A call-back function to receive event notifications.
 * @return TRUE on success, FALSE otherwise.
 * @see APP_RegisterDVBEventHandler
 */
BOOLEAN APP_RegisterDVBEventHandler(DVB_EVENT_HANDLER event_handler);

/**
 * @brief Unregister a previously registered event handler.
 *
 * Find and remove the function from the registered handlers list. If the same
 * function was registered more than once, the 1st found occurrence will
 * be removed.
 *
 * @param event_handler A function pointer previously passed into the
 *        APP_RegisterDVBEventHandler function.
 * @return TRUE on success, FALSE otherwise.
 * @see APP_RegisterDVBEventHandler
 */
BOOLEAN APP_UnregisterDVBEventHandler(DVB_EVENT_HANDLER event_handler);

// version string/Number retrieval
U8BIT* App_GetVersionString(void);
U32BIT App_GetVersionNumber(void);

void APP_RegisterUIInfoCallback(ACB_INFO_CALLBACK ui_info_callback);

/**
 * @brief Enable classifying of repeat events by EV_CLASS_IS_REPEAT flag
 * @param enable TRUE - to turn on, FALSE - turn off (default)
 */
void APP_SetClassifyRepeatEvents(BOOLEAN enable);

#endif //  _APP_H
//**************************************************************************************************
// End of File
//**************************************************************************************************

