/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2012 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Application Version support functions
 * @file    dvbver.h
 * @date    24th September 2012
 * @author  Adam Sturtridge
 */

#ifndef _DVBVER_H
#define _DVBVER_H

#include <techtype.h>

typedef struct
{
   U8BIT major;
   U8BIT minor;
   U32BIT revision;
} DVB_VER_STRUCT;


U8BIT* App_DvbVersionString(void);
U32BIT App_DvbVersionNumber(void);
void App_DvbVersionData(DVB_VER_STRUCT *vptr);

#endif /*_DVBVER_H*/
