/*******************************************************************************
 * Copyright © 2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright © 2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Application configuration data
 *
 * @file    ap_cfdat.h
 * @date    8/04/2004
 * @author  Ocean Blue
 */

#ifndef _AP_CFDAT_H
#define _AP_CFDAT_H

#include "techtype.h"

//--------------------------------------------------------------------------------------------------
// the following data defines the configuration for the application. The data defines the tuning
// frequencies, menu languages, database languages, aerial power etc.
// It is included in ap_cfg.c and ap_dbdef.c.
//--------------------------------------------------------------------------------------------------


//---Constant and macro definitions for public use--------------------------------------------------

#define ACFG_INVALID_DB_LANG           255
#define ACFG_UNDEFINED_DB_LANG_CODE    0
#define ACFG_MAX_DB_LANG_CODES         3

#ifdef DECLARE_DB_LANG_LIST
// db language list - used in ap_dbdef.c
static const U32BIT db_lang_list[ACFG_NUM_DB_LANGUAGES] =
{
   ENGLISH_LANG_CODE,
   WELSH1_LANG_CODE,
   WELSH2_LANG_CODE,
   GAELIC_LANG_CODE,
   IRISH1_LANG_CODE,
   IRISH2_LANG_CODE,
   DUTCH1_LANG_CODE,
   DUTCH2_LANG_CODE,
   GERMAN1_LANG_CODE,
   GERMAN2_LANG_CODE,
   FRENCH1_LANG_CODE,
   FRENCH2_LANG_CODE,
   RUSSIAN_LANG_CODE,
   SIMPLIFIED_CHINESE_LANG_CODE,
   TRADITIONAL_CHINESE_LANG_CODE,
   FINNISH_LANG_CODE,
   SWEDISH_LANG_CODE,
   NORWEGIAN_LANG_CODE,
   DANISH_LANG_CODE,
   MANDARIN_LANG_CODE,
   CANTONESE_LANG_CODE,
   MAORI1_LANG_CODE,
   MAORI2_LANG_CODE,
   JAPANESE_LANG_CODE,
   ITALIAN_LANG_CODE,
   SPANISH1_LANG_CODE,
   SPANISH2_LANG_CODE,
   KOREAN_LANG_CODE,
   HINDI_LANG_CODE,
   CZECH1_LANG_CODE,
   CZECH2_LANG_CODE,
   SLOVAK1_LANG_CODE,
   SLOVAK2_LANG_CODE,
   AFRIKAANS_LANG_CODE,
   NDEBELE_LANG_CODE,
   NORTHERN_SOTHO_LANG_CODE,
   SOUTHERN_SOTHO_LANG_CODE,
   SWATI_LANG_CODE,
   TSONGA_LANG_CODE,
   TSWANA_LANG_CODE,
   VENDA_LANG_CODE,
   XHOSA_LANG_CODE,
   ZULU_LANG_CODE,
   CROATIAN_LANG_CODE,
   HUNGARIAN_LANG_CODE,
   LATVIAN_LANG_CODE,
   LUXEMBOURGISH_LANG_CODE,
   POLISH_LANG_CODE,
   PORTUGUESE_LANG_CODE,
   SERBIAN_LANG_CODE,
   ROMANIAN1_LANG_CODE,
   ROMANIAN2_LANG_CODE,
   ALBANIAN1_LANG_CODE,
   ALBANIAN2_LANG_CODE,
   SLOVENE_LANG_CODE,
   CATALAN_LANG_CODE,
   GALICIAN_LANG_CODE,
   BASQUE1_LANG_CODE,
   BASQUE2_LANG_CODE,
   UKRAINIAN_LANG_CODE,
   UND_LANG_CODE,
   ARABIC_LANG_CODE
};
#endif

#ifdef DECLARE_DATA_TABLES
// the following data tables are used in ap_cfg.c
static const U8BIT *language_strings[] =
{
   (U8BIT *)"English",                    /* DVB_LANGUAGE_ENGLISH */
   (U8BIT *)"Cymraeg",                    /* DVB_LANGUAGE_WELSH */
   (U8BIT *)"\x05" "G" "\xE0" "idhlig",   /* DVB_LANGUAGE_GAELIC */
   (U8BIT *)"Gaeilge",                    /* DVB_LANGUAGE_IRISH */
   (U8BIT *)"\x05" "Fran" "\xE7" "ais",   /* DVB_LANGUAGE_FRENCH */
   (U8BIT *)"Deutsch",                    /* DVB_LANGUAGE_GERMAN */
   (U8BIT *)"Nederlands",                 /* DVB_LANGUAGE_DUTCH */
   (U8BIT *)"\x01\xe0\xe3\xe1\xe1\xda\xd8\xd9 \xef\xed\xec\xf6\xda",    /* DVB_LANGUAGE_RUSSIAN */
   (U8BIT *)"Simple Chinese",             /* DVB_LANGUAGE_SIMPLIFIED_CHINESE */
   (U8BIT *)"Traditional Chinese",        /* DVB_LANGUAGE_TRADITIONAL_CHINESE */
   (U8BIT *)"suomi",                      /* DVB_LANGUAGE_FINNISH */
   (U8BIT *)"Svenska",                    /* DVB_LANGUAGE_SWEDISH */
   (U8BIT *)"norsk",                      /* DVB_LANGUAGE_NORWEGIAN */
   (U8BIT *)"dansk",                      /* DVB_LANGUAGE_DANISH */
   (U8BIT *)"Mandarin",                   /* DVB_LANGUAGE_MANDARIN */
   (U8BIT *)"Cantonese",                  /* DVB_LANGUAGE_CANTONESE */
   (U8BIT *)"Maori",                      /* DVB_LANGUAGE_MAORI */
   (U8BIT *)"Japanese",                   /* DVB_LANGUAGE_JAPANESE */
   (U8BIT *)"italiano",                   /* DVB_LANGUAGE_ITALIAN */
   (U8BIT *)"\x05" "espa" "\xF1" "ol",    /* DVB_LANGUAGE_SPANISH */
   (U8BIT *)"Korean",                     /* DVB_LANGUAGE_KOREAN */
   (U8BIT *)"Hindi",                      /* DVB_LANGUAGE_HINDI */
   (U8BIT *)"\x06\xE8" "e" "\xBA" "tina", /* DVB_LANGUAGE_CZECH */
   (U8BIT *)"\x06" "sloven" "\xE8" "ina", /* DVB_LANGUAGE_SLOVAK */
   (U8BIT *)"Afrikaans",                  /* DVB_LANGUAGE_AFRIKAANS */
   (U8BIT *)"IsiNdebele",                 /* DVB_LANGUAGE_NDEBELE */
   (U8BIT *)"Sepedi",                     /* DVB_LANGUAGE_NORTHERN_SOTHO */
   (U8BIT *)"Sesotho",                    /* DVB_LANGUAGE_SOUTHERN_SOTHO */
   (U8BIT *)"SiSwati",                    /* DVB_LANGUAGE_SWATI */
   (U8BIT *)"Xitsonga",                   /* DVB_LANGUAGE_TSONGA */
   (U8BIT *)"Setswana",                   /* DVB_LANGUAGE_TSWANA */
   (U8BIT *)"Tshivenda",                  /* DVB_LANGUAGE_VENDA */
   (U8BIT *)"IsiXhosa",                   /* DVB_LANGUAGE_XHOSA */
   (U8BIT *)"IsiZulu",                    /* DVB_LANGUAGE_ZULU */
   (U8BIT *)"hrvatski jezik",             /* DVB_LANGUAGE_CROATIAN */
   (U8BIT *)"magyar",                     /* DVB_LANGUAGE_HUNGARIAN */
   (U8BIT *)"\x0B" "latvie" "\xA8" "u valoda", /* DVB_LANGUAGE_LATVIAN */
   (U8BIT *)"\x0B" "L" "\xEB" "tzebuergesch", /* DVB_LANGUAGE_LUXEMBOURGISH */
   (U8BIT *)"polski",                     /* DVB_LANGUAGE_POLISH */
   (U8BIT *)"\x0b" "portugu" "\xea" "s",  /* DVB_LANGUAGE_PORTUGUESE */
   (U8BIT *)"\x01\xe1\xe0\xdf\xe1\xda\xd8 \xf8\xd5\xd7\xd8\xda",  /* DVB_LANGUAGE_SERBIAN */
   (U8BIT *)"\x0b" "limba rom" "\xe2" "n" "\xe3", /* DVB_LANGUAGE_ROMANIAN */
   (U8BIT *)"gjuha shqipe",               /* DVB_LANGUAGE_ALBANIAN */
   (U8BIT *)"slovenski",                  /* DVB_LANGUAGE_SLOVENE */
   (U8BIT *)"\x0b" "catal" "\xe0",        /* DVB_LANGUAGE_CATALAN */
   (U8BIT *)"galego",                     /* DVB_LANGUAGE_GALICIAN */
   (U8BIT *)"euskara",                    /* DVB_LANGUAGE_BASQUE */
   (U8BIT *)"\x01\xe3\xda\xe0\xd0\xf7\xdd\xe1\xec\xda\xd0 \xdc\xde\xd2\xd0",   /* DVB_LANGUAGE_UKRAINIAN */
   (U8BIT *)"\x02" "al-" "\xEB" "arabiyyah"  /* DVB_LANGUAGE_ARABIC */
};

/* VHF + UHF analog tuning table */
static const ACFG_ANA_RF_CHANNEL_DATA vhf_uhf_ana_rf_channel_table[] =
{
   {(U8BIT *)"Ch 2", 48250000},
   {(U8BIT *)"Ch 3", 55250000},
   {(U8BIT *)"Ch 4", 62250000},
   {(U8BIT *)"Ch 5", 175250000},
   {(U8BIT *)"Ch 6", 182250000},
   {(U8BIT *)"Ch 7", 189250000},
   {(U8BIT *)"Ch 8", 196250000},
   {(U8BIT *)"Ch 9", 203250000},
   {(U8BIT *)"Ch10", 210250000},
   {(U8BIT *)"Ch11", 217250000},
   {(U8BIT *)"Ch12", 224250000},
   {(U8BIT *)"Ch21", 471250000},
   {(U8BIT *)"Ch22", 479250000},
   {(U8BIT *)"Ch23", 487250000},
   {(U8BIT *)"Ch24", 495250000},
   {(U8BIT *)"Ch25", 503250000},
   {(U8BIT *)"Ch26", 511250000},
   {(U8BIT *)"Ch27", 519250000},
   {(U8BIT *)"Ch28", 527250000},
   {(U8BIT *)"Ch29", 535250000},
   {(U8BIT *)"Ch30", 543250000},
   {(U8BIT *)"Ch31", 551250000},
   {(U8BIT *)"Ch32", 559250000},
   {(U8BIT *)"Ch33", 567250000},
   {(U8BIT *)"Ch34", 575250000},
   {(U8BIT *)"Ch35", 583250000},
   {(U8BIT *)"Ch36", 591250000},
   {(U8BIT *)"Ch37", 599250000},
   {(U8BIT *)"Ch38", 607250000},
   {(U8BIT *)"Ch39", 615250000},
   {(U8BIT *)"Ch40", 623250000},
   {(U8BIT *)"Ch41", 631250000},
   {(U8BIT *)"Ch42", 639250000},
   {(U8BIT *)"Ch43", 647250000},
   {(U8BIT *)"Ch44", 655250000},
   {(U8BIT *)"Ch45", 663250000},
   {(U8BIT *)"Ch46", 671250000},
   {(U8BIT *)"Ch47", 679250000},
   {(U8BIT *)"Ch48", 687250000},
   {(U8BIT *)"Ch49", 695250000},
   {(U8BIT *)"Ch50", 703250000},
   {(U8BIT *)"Ch51", 711250000},
   {(U8BIT *)"Ch52", 719250000},
   {(U8BIT *)"Ch53", 727250000},
   {(U8BIT *)"Ch54", 735250000},
   {(U8BIT *)"Ch55", 743250000},
   {(U8BIT *)"Ch56", 751250000},
   {(U8BIT *)"Ch57", 759250000},
   {(U8BIT *)"Ch58", 767250000},
   {(U8BIT *)"Ch59", 775250000},
   {(U8BIT *)"Ch60", 783250000},
   {(U8BIT *)"Ch61", 791250000},
   {(U8BIT *)"Ch62", 799250000},
   {(U8BIT *)"Ch63", 807250000},
   {(U8BIT *)"Ch64", 815250000},
   {(U8BIT *)"Ch65", 823250000},
   {(U8BIT *)"Ch66", 831250000},
   {(U8BIT *)"Ch67", 839250000},
   {(U8BIT *)"Ch68", 847250000},
   {(U8BIT *)"Ch69", 855250000}
};

/* UHF analog tuning table */
static const ACFG_ANA_RF_CHANNEL_DATA uhf_ana_rf_channel_table[] =
{
   {(U8BIT *)"Ch21", 471250000},
   {(U8BIT *)"Ch22", 479250000},
   {(U8BIT *)"Ch23", 487250000},
   {(U8BIT *)"Ch24", 495250000},
   {(U8BIT *)"Ch25", 503250000},
   {(U8BIT *)"Ch26", 511250000},
   {(U8BIT *)"Ch27", 519250000},
   {(U8BIT *)"Ch28", 527250000},
   {(U8BIT *)"Ch29", 535250000},
   {(U8BIT *)"Ch30", 543250000},
   {(U8BIT *)"Ch31", 551250000},
   {(U8BIT *)"Ch32", 559250000},
   {(U8BIT *)"Ch33", 567250000},
   {(U8BIT *)"Ch34", 575250000},
   {(U8BIT *)"Ch35", 583250000},
   {(U8BIT *)"Ch36", 591250000},
   {(U8BIT *)"Ch37", 599250000},
   {(U8BIT *)"Ch38", 607250000},
   {(U8BIT *)"Ch39", 615250000},
   {(U8BIT *)"Ch40", 623250000},
   {(U8BIT *)"Ch41", 631250000},
   {(U8BIT *)"Ch42", 639250000},
   {(U8BIT *)"Ch43", 647250000},
   {(U8BIT *)"Ch44", 655250000},
   {(U8BIT *)"Ch45", 663250000},
   {(U8BIT *)"Ch46", 671250000},
   {(U8BIT *)"Ch47", 679250000},
   {(U8BIT *)"Ch48", 687250000},
   {(U8BIT *)"Ch49", 695250000},
   {(U8BIT *)"Ch50", 703250000},
   {(U8BIT *)"Ch51", 711250000},
   {(U8BIT *)"Ch52", 719250000},
   {(U8BIT *)"Ch53", 727250000},
   {(U8BIT *)"Ch54", 735250000},
   {(U8BIT *)"Ch55", 743250000},
   {(U8BIT *)"Ch56", 751250000},
   {(U8BIT *)"Ch57", 759250000},
   {(U8BIT *)"Ch58", 767250000},
   {(U8BIT *)"Ch59", 775250000},
   {(U8BIT *)"Ch60", 783250000},
   {(U8BIT *)"Ch61", 791250000},
   {(U8BIT *)"Ch62", 799250000},
   {(U8BIT *)"Ch63", 807250000},
   {(U8BIT *)"Ch64", 815250000},
   {(U8BIT *)"Ch65", 823250000},
   {(U8BIT *)"Ch66", 831250000},
   {(U8BIT *)"Ch67", 839250000},
   {(U8BIT *)"Ch68", 847250000},
   {(U8BIT *)"Ch69", 855250000}
};

/* VHF + UHF DVB-T and DVB-T2 tuning table */
static const ACFG_TER_RF_CHANNEL_DATA vhf_uhf_t_t2_ter_rf_channel_table[] =
{
   {(U8BIT *)"Ch 2", 50500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch 2", 50500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 3", 57500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch 3", 57500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 4", 64500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch 4", 64500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 5", 177500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch 5", 177500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 6", 184500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch 6", 184500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 7", 191500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch 7", 191500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 8", 198500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch 8", 198500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 9", 205500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch 9", 205500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch10", 212500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch10", 212500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch11", 219500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch11", 219500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch12", 226500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch12", 226500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch21", 474000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch21", 474000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch22", 482000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch22", 482000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch23", 490000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch23", 490000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch24", 498000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch24", 498000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch25", 506000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch25", 506000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch26", 514000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch26", 514000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch27", 522000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch27", 522000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch28", 530000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch28", 530000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch29", 538000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch29", 538000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch30", 546000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch30", 546000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch31", 554000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch31", 554000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch32", 562000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch32", 562000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch33", 570000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch33", 570000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch34", 578000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch34", 578000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch35", 586000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch35", 586000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch36", 594000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch36", 594000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch37", 602000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch37", 602000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch38", 610000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch38", 610000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch39", 618000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch39", 618000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch40", 626000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch40", 626000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch41", 634000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch41", 634000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch42", 642000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch42", 642000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch43", 650000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch43", 650000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch44", 658000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch44", 658000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch45", 666000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch45", 666000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch46", 674000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch46", 674000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch47", 682000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch47", 682000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch48", 690000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch48", 690000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch49", 698000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch49", 698000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch50", 706000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch50", 706000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch51", 714000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch51", 714000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch52", 722000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch52", 722000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch53", 730000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch53", 730000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch54", 738000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch54", 738000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch55", 746000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch55", 746000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch56", 754000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch56", 754000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch57", 762000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch57", 762000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch58", 770000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch58", 770000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch59", 778000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch59", 778000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch60", 786000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch60", 786000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch61", 794000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch61", 794000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch62", 802000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch62", 802000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch63", 810000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch63", 810000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch64", 818000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch64", 818000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch65", 826000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch65", 826000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch66", 834000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch66", 834000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch67", 842000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch67", 842000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch68", 850000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch68", 850000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch69", 858000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch69", 858000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT}
};

/* UHF DVB-T and DVB-T2 tuning table */
static const ACFG_TER_RF_CHANNEL_DATA uhf_t_t2_ter_rf_channel_table[] =
{
   {(U8BIT *)"Ch21", 474000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch21", 474000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch22", 482000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch22", 482000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch23", 490000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch23", 490000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch24", 498000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch24", 498000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch25", 506000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch25", 506000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch26", 514000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch26", 514000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch27", 522000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch27", 522000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch28", 530000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch28", 530000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch29", 538000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch29", 538000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch30", 546000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch30", 546000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch31", 554000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch31", 554000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch32", 562000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch32", 562000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch33", 570000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch33", 570000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch34", 578000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch34", 578000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch35", 586000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch35", 586000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch36", 594000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch36", 594000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch37", 602000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch37", 602000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch38", 610000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch38", 610000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch39", 618000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch39", 618000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch40", 626000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch40", 626000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch41", 634000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch41", 634000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch42", 642000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch42", 642000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch43", 650000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch43", 650000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch44", 658000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch44", 658000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch45", 666000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch45", 666000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch46", 674000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch46", 674000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch47", 682000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch47", 682000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch48", 690000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch48", 690000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch49", 698000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch49", 698000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch50", 706000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch50", 706000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch51", 714000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch51", 714000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch52", 722000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch52", 722000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch53", 730000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch53", 730000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch54", 738000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch54", 738000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch55", 746000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch55", 746000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch56", 754000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch56", 754000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch57", 762000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch57", 762000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch58", 770000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch58", 770000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch59", 778000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch59", 778000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch60", 786000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch60", 786000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch61", 794000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch61", 794000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch62", 802000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch62", 802000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch63", 810000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch63", 810000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch64", 818000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch64", 818000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch65", 826000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch65", 826000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch66", 834000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch66", 834000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch67", 842000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch67", 842000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch68", 850000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch68", 850000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch69", 858000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch69", 858000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT}
};

/* VHF + UHF DVB-T tuning table */
static const ACFG_TER_RF_CHANNEL_DATA vhf_uhf_t_ter_rf_channel_table[] =
{
   {(U8BIT *)"Ch 2", 50500000, TBWIDTH_7MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 3", 57500000, TBWIDTH_7MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 4", 64500000, TBWIDTH_7MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 5", 177500000, TBWIDTH_7MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 6", 184500000, TBWIDTH_7MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 7", 191500000, TBWIDTH_7MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 8", 198500000, TBWIDTH_7MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch 9", 205500000, TBWIDTH_7MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch10", 212500000, TBWIDTH_7MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch11", 219500000, TBWIDTH_7MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch12", 226500000, TBWIDTH_7MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch21", 474000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch22", 482000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch23", 490000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch24", 498000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch25", 506000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch26", 514000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch27", 522000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch28", 530000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch29", 538000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch30", 546000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch31", 554000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch32", 562000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch33", 570000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch34", 578000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch35", 586000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch36", 594000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch37", 602000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch38", 610000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch39", 618000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch40", 626000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch41", 634000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch42", 642000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch43", 650000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch44", 658000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch45", 666000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch46", 674000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch47", 682000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch48", 690000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch49", 698000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch50", 706000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch51", 714000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch52", 722000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch53", 730000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch54", 738000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch55", 746000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch56", 754000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch57", 762000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch58", 770000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch59", 778000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch60", 786000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch61", 794000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch62", 802000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch63", 810000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch64", 818000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch65", 826000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch66", 834000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch67", 842000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch68", 850000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch69", 858000000, TBWIDTH_8MHZ, MODE_COFDM_8K, TERR_TYPE_DVBT}
};

/* UHF DVB-T tuning table */
static const ACFG_TER_RF_CHANNEL_DATA uhf_t_ter_rf_channel_table[] =
{
   {(U8BIT *)"Ch21", 474000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch22", 482000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch23", 490000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch24", 498000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch25", 506000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch26", 514000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch27", 522000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch28", 530000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch29", 538000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch30", 546000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch31", 554000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch32", 562000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch33", 570000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch34", 578000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch35", 586000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch36", 594000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch37", 602000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch38", 610000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch39", 618000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch40", 626000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch41", 634000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch42", 642000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch43", 650000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch44", 658000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch45", 666000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch46", 674000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch47", 682000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch48", 690000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch49", 698000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch50", 706000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch51", 714000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch52", 722000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch53", 730000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch54", 738000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch55", 746000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch56", 754000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch57", 762000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch58", 770000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch59", 778000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch60", 786000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch61", 794000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch62", 802000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch63", 810000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch64", 818000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch65", 826000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch66", 834000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch67", 842000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch68", 850000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch69", 858000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT}
};

static const ACFG_CAB_RF_CHANNEL_DATA deu_cab_rf_channel_table[] =
{
   {(U8BIT *)"D73", 73000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S02", 113000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S02", 114000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S03", 121000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S03", 122000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S04", 129000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S04", 130000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S05", 137000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S05", 138000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S21", 306000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S22", 314000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S23", 322000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S24", 330000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S25", 338000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S26", 346000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S27", 354000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S28", 362000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S29", 370000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S30", 378000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S31", 386000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S32", 394000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S33", 402000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S34", 410000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S35", 418000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S36", 426000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S37", 434000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S38", 442000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S39", 450000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S40", 458000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"S41", 466000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K21", 474000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K22", 482000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K23", 490000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K24", 498000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K25", 506000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K26", 514000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K27", 522000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K28", 530000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K29", 538000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K30", 546000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K31", 554000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K32", 562000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K33", 570000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K34", 578000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K35", 586000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K36", 594000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K37", 602000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K38", 610000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K39", 618000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K40", 626000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K41", 634000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K42", 642000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K43", 650000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K44", 658000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K45", 666000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K46", 674000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K47", 682000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K48", 690000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K49", 698000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K50", 706000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K51", 714000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K52", 722000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K53", 730000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K54", 738000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K55", 746000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K56", 754000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K57", 762000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K58", 770000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K59", 778000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K60", 786000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K61", 794000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K62", 802000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K63", 810000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K64", 818000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K65", 826000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K66", 834000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K67", 842000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K68", 850000000, MODE_QAM_AUTO, 6900},
   {(U8BIT *)"K69", 858000000, MODE_QAM_AUTO, 6900}
};

#if 0 /* Not sure where these freqs came from. Normally chans 6-12 are 7MHz rather than 8 */
      /* Russian DVB-T tuning table */
static const ACFG_TER_RF_CHANNEL_DATA rus_ter_rf_channel_table[] =
{
   {(U8BIT *)"Ch6", 178000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch7", 186000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch8", 194000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch9", 202000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch10", 210000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch11", 218000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch12", 226000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch21", 474000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch22", 482000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch23", 490000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch24", 498000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch25", 506000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch26", 514000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch27", 522000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch28", 530000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch29", 538000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch30", 546000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch31", 554000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch32", 562000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch33", 570000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch34", 578000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch35", 586000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch36", 594000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch37", 602000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch38", 610000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch39", 618000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch40", 626000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch41", 634000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch42", 642000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch43", 650000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch44", 658000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch45", 666000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch46", 674000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch47", 682000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch48", 690000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch49", 698000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch50", 706000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch51", 714000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch52", 722000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch53", 730000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch54", 738000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch55", 746000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch56", 754000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch57", 762000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch58", 770000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch59", 778000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch60", 786000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch61", 794000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch62", 802000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch63", 810000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch64", 818000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch65", 826000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch66", 834000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch67", 842000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch68", 850000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch69", 858000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT}
};
#endif

/* Australian DVB-T tuning table */
static const ACFG_TER_RF_CHANNEL_DATA aus_ter_rf_channel_table[] =
{
   {(U8BIT *)"Ch6", 177500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch7", 184500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch8", 191500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch9", 198500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch9A", 205500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch10", 212500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch11", 219500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch12", 226500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch28", 529500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch29", 536500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch30", 543500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch31", 550500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch32", 557500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch33", 564500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch34", 571500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch35", 578500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch36", 585500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch37", 592500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch38", 599500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch39", 606500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch40", 613500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch41", 620500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch42", 627500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch43", 634500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch44", 641500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch45", 648500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch46", 655500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch47", 662500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch48", 669500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch49", 676500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch50", 683500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch51", 690500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch52", 697500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch53", 704500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch54", 711500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch55", 718500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch56", 725500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch57", 732500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch58", 739500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch59", 746500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch60", 753500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch61", 760500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch62", 767500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch63", 774500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch64", 781500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch65", 788500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch66", 795500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch67", 802500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch68", 809500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch69", 816500000, TBWIDTH_7MHZ, MODE_COFDM_2K, TERR_TYPE_DVBT}
};

/* Finnish DVB-T and DVB-T2 tuning table */
static const ACFG_TER_RF_CHANNEL_DATA fin_terr_rf_channel_table[] =
{
   {(U8BIT *)"Ch5", 177500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch5", 177500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch6", 184500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch6", 184500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch7", 191500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch7", 191500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch8", 198500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch8", 198500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch9", 205500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch9", 205500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch10", 212500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch10", 212500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch11", 219500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch11", 219500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch12", 226500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch12", 226500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch21", 474000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch21", 474000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch22", 482000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch22", 482000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch23", 490000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch23", 490000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch24", 498000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch24", 498000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch25", 506000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch25", 506000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch26", 514000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch26", 514000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch27", 522000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch27", 522000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch28", 530000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch28", 530000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch29", 538000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch29", 538000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch30", 546000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch30", 546000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch31", 554000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch31", 554000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch32", 562000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch32", 562000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch33", 570000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch33", 570000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch34", 578000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch34", 578000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch35", 586000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch35", 586000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch36", 594000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch36", 594000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch37", 602000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch37", 602000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch38", 610000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch38", 610000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch39", 618000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch39", 618000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch40", 626000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch40", 626000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch41", 634000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch41", 634000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch42", 642000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch42", 642000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch43", 650000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch43", 650000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch44", 658000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch44", 658000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch45", 666000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch45", 666000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch46", 674000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch46", 674000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch47", 682000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch47", 682000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch48", 690000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch48", 690000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch49", 698000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch49", 698000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch50", 706000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch50", 706000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch51", 714000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch51", 714000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch52", 722000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch52", 722000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch53", 730000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch53", 730000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch54", 738000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch54", 738000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch55", 746000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch55", 746000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch56", 754000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch56", 754000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch57", 762000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch57", 762000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch58", 770000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch58", 770000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch59", 778000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch59", 778000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch60", 786000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch60", 786000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch61", 794000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch61", 794000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch62", 802000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch62", 802000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch63", 810000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch63", 810000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch64", 818000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch64", 818000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch65", 826000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch65", 826000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch66", 834000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch66", 834000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch67", 842000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch67", 842000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch68", 850000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch68", 850000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch69", 858000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch69", 858000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT}
};

static const ACFG_CAB_RF_CHANNEL_DATA fin_cab_rf_channel_table[] =
{
   {(U8BIT *)"Ch0", 114000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch1", 122000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch2", 130000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch3", 138000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch4", 146000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch5", 154000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch6", 162000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch7", 170000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch8", 178000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch9", 186000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch10", 194000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch11", 202000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch12", 210000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch13", 218000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch14", 226000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch15", 234000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch16", 242000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch17", 250000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch18", 258000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch19", 266000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch20", 274000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch21", 282000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch22", 290000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch23", 298000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch24", 306000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch25", 314000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch26", 322000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch27", 330000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch28", 338000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch29", 346000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch30", 354000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch31", 362000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch32", 370000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch33", 378000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch34", 386000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch35", 394000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch36", 402000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch37", 410000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch38", 418000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch39", 426000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch40", 434000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch41", 442000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch42", 450000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch43", 458000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch44", 466000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch45", 474000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch46", 482000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch47", 490000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch48", 498000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch49", 506000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch50", 514000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch51", 522000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch52", 530000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch53", 538000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch54", 546000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch55", 554000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch56", 562000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch57", 570000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch58", 578000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch59", 586000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch60", 594000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch61", 602000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch62", 610000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch63", 618000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch64", 626000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch65", 634000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch66", 642000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch67", 650000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch68", 658000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch69", 666000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch70", 674000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch71", 682000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch72", 690000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch73", 698000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch74", 706000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch75", 714000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch76", 722000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch77", 730000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch78", 738000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch79", 746000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch80", 754000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch81", 762000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch82", 770000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch83", 778000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch84", 786000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch85", 794000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch86", 802000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch87", 810000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch88", 818000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch89", 826000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch90", 834000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch91", 842000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch92", 850000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO},
   {(U8BIT *)"Ch93", 858000000, MODE_QAM_AUTO, SYMBOL_RATE_AUTO}
};

/* South African DVB-T and DVB-T2 tuning table */
static const ACFG_TER_RF_CHANNEL_DATA zaf_ter_rf_channel_table[] =
{
   {(U8BIT *)"Ch4", 178000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch4", 178000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch5", 186000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch5", 186000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch6", 194000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch6", 194000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch7", 202000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch7", 202000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch8", 210000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch8", 210000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch9", 218000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch9", 218000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch10", 226000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch10", 226000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch11", 234000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch11", 234000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch12", 242000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch12", 242000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch13", 250000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch13", 250000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch21", 474000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch21", 474000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch22", 482000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch22", 482000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch23", 490000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch23", 490000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch24", 498000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch24", 498000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch25", 506000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch25", 506000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch26", 514000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch26", 514000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch27", 522000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch27", 522000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch28", 530000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch28", 530000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch29", 538000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch29", 538000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch30", 546000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch30", 546000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch31", 554000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch31", 554000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch32", 562000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch32", 562000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch33", 570000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch33", 570000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch34", 578000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch34", 578000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch35", 586000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch35", 586000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch36", 594000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch36", 594000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch37", 602000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch37", 602000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch38", 610000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch38", 610000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch39", 618000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch39", 618000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch40", 626000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch40", 626000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch41", 634000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch41", 634000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch42", 642000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch42", 642000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch43", 650000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch43", 650000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch44", 658000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch44", 658000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch45", 666000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch45", 666000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch46", 674000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch46", 674000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch47", 682000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch47", 682000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch48", 690000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch48", 690000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch49", 698000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch49", 698000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch50", 706000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch50", 706000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch51", 714000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch51", 714000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch52", 722000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch52", 722000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch53", 730000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch53", 730000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch54", 738000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch54", 738000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch55", 746000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch55", 746000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch56", 754000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch56", 754000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch57", 762000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch57", 762000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch58", 770000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch58", 770000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch59", 778000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch59", 778000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch60", 786000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch60", 786000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch61", 794000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch61", 794000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch62", 802000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch62", 802000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch63", 810000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch63", 810000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch64", 818000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch64", 818000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch65", 826000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch65", 826000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch66", 834000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch66", 834000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch67", 842000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch67", 842000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch68", 850000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch68", 850000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch69", 858000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch69", 858000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT}
};

/* South America cable tuning table */
static const ACFG_CAB_RF_CHANNEL_DATA southamerica_cab_rf_channel_table[] =
{
   {(U8BIT *)"C1", 57000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C2", 63000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C3", 69000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C4", 75000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C5", 81000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C6", 87000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C7", 93000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C8", 99000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C9", 105000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C10", 111000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C11", 117000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C12", 123000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C13", 129000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C14", 135000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C15", 141000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C16", 147000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C17", 153000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C18", 159000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C19", 165000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C20", 171000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C21", 177000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C22", 183000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C23", 189000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C24", 195000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C25", 201000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C26", 207000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C27", 213000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C28", 219000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C29", 225000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C30", 231000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C31", 237000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C32", 243000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C33", 249000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C34", 255000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C35", 261000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C36", 267000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C37", 273000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C38", 279000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C39", 285000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C40", 291000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C41", 297000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C42", 303000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C43", 309000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C44", 315000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C45", 321000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C46", 327000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C47", 333000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C48", 339000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C49", 345000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C50", 351000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C51", 357000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C52", 363000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C53", 369000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C54", 375000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C55", 381000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C56", 387000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C57", 393000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C58", 399000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C59", 405000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C60", 411000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C61", 417000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C62", 423000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C63", 429000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C64", 435000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C65", 441000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C66", 447000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C67", 453000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C68", 459000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C69", 465000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C70", 471000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C71", 477000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C72", 483000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C73", 489000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C74", 495000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C75", 501000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C76", 507000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C77", 513000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C78", 519000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C79", 525000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C80", 531000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C81", 537000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C82", 543000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C83", 549000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C84", 555000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C85", 561000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C86", 567000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C87", 573000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C88", 579000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C89", 585000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C90", 591000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C91", 597000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C92", 603000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C93", 609000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C94", 615000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C95", 621000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C96", 627000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C97", 633000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C98", 639000000, MODE_QAM_64, 5057},
   {(U8BIT *)"C99", 645000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CA0", 651000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CA1", 657000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CA2", 663000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CA3", 669000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CA4", 675000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CA5", 681000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CA6", 687000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CA7", 693000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CA8", 699000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CA9", 705000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CB0", 711000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CB1", 717000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CB2", 723000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CB3", 729000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CB4", 735000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CB5", 741000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CB6", 747000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CB7", 753000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CB8", 759000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CB9", 765000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CC0", 771000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CC1", 777000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CC2", 783000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CC3", 789000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CC4", 795000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CC5", 801000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CC6", 807000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CC7", 813000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CC8", 819000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CC9", 825000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CD0", 831000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CD1", 837000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CD2", 843000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CD3", 849000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CD4", 855000000, MODE_QAM_64, 5057},
   {(U8BIT *)"CD5", 861000000, MODE_QAM_64, 5057}
};

/* Ireland DVB-T and DVB-T2 tuning table */
static const ACFG_TER_RF_CHANNEL_DATA irl_terr_rf_channel_table[] =
{
   {(U8BIT *)"Ch5", 177500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch5", 177500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch6", 184500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch6", 184500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch7", 191500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch7", 191500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch8", 198500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch8", 198500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch9", 205500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch9", 205500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch10", 212500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch10", 212500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch11", 219500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch11", 219500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch12", 226500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch12", 226500000, TBWIDTH_7MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch21", 474000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch21", 474000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch22", 482000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch22", 482000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch23", 490000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch23", 490000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch24", 498000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch24", 498000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch25", 506000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch25", 506000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch26", 514000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch26", 514000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch27", 522000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch27", 522000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch28", 530000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch28", 530000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch29", 538000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch29", 538000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch30", 546000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch30", 546000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch31", 554000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch31", 554000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch32", 562000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch32", 562000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch33", 570000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch33", 570000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch34", 578000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch34", 578000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch35", 586000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch35", 586000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch36", 594000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch36", 594000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch37", 602000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch37", 602000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch38", 610000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch38", 610000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch39", 618000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch39", 618000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch40", 626000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch40", 626000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch41", 634000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch41", 634000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch42", 642000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch42", 642000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch43", 650000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch43", 650000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch44", 658000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch44", 658000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch45", 666000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch45", 666000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch46", 674000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch46", 674000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch47", 682000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch47", 682000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch48", 690000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch48", 690000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch49", 698000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch49", 698000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch50", 706000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch50", 706000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch51", 714000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch51", 714000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch52", 722000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch52", 722000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch53", 730000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch53", 730000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch54", 738000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch54", 738000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch55", 746000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch55", 746000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch56", 754000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch56", 754000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch57", 762000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch57", 762000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch58", 770000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch58", 770000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch59", 778000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch59", 778000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch60", 786000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch60", 786000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT},
   {(U8BIT *)"Ch61", 794000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT2},
   {(U8BIT *)"Ch61", 794000000, TBWIDTH_8MHZ, MODE_COFDM_UNDEFINED, TERR_TYPE_DVBT}
};

static const ACFG_CAB_RF_CHANNEL_DATA taiwan_cab_rf_channel_table[] =
{
   {(U8BIT *)"C1", 57000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C2", 63000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C3", 69000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C4", 75000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C5", 81000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C6", 87000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C7", 93000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C8", 99000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C9", 105000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C10", 111000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C11", 117000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C12", 123000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C13", 129000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C14", 135000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C15", 141000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C16", 147000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C17", 153000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C18", 159000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C19", 165000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C20", 171000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C21", 177000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C22", 183000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C23", 189000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C24", 195000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C25", 201000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C26", 207000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C27", 213000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C28", 219000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C29", 225000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C30", 231000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C31", 237000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C32", 243000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C33", 249000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C34", 255000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C35", 261000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C36", 267000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C37", 273000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C38", 279000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C39", 285000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C40", 291000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C41", 297000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C42", 303000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C43", 309000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C44", 315000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C45", 321000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C46", 327000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C47", 333000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C48", 339000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C49", 345000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C50", 351000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C51", 357000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C52", 363000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C53", 369000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C54", 375000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C55", 381000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C56", 387000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C57", 393000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C58", 399000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C59", 405000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C60", 411000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C61", 417000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C62", 423000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C63", 429000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C64", 435000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C65", 441000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C66", 447000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C67", 453000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C68", 459000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C69", 465000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C70", 471000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C71", 477000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C72", 483000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C73", 489000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C74", 495000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C75", 501000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C76", 507000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C77", 513000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C78", 519000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C79", 525000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C80", 531000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C81", 537000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C82", 543000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C83", 549000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C84", 555000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C85", 561000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C86", 567000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C87", 573000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C88", 579000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C89", 585000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C90", 591000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C91", 597000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C92", 603000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C93", 609000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C94", 615000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C95", 621000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C96", 627000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C97", 633000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C98", 639000000, MODE_QAM_256, 5217},
   {(U8BIT *)"C99", 645000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CA0", 651000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CA1", 657000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CA2", 663000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CA3", 669000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CA4", 675000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CA5", 681000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CA6", 687000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CA7", 693000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CA8", 699000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CA9", 705000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CB0", 711000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CB1", 717000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CB2", 723000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CB3", 729000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CB4", 735000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CB5", 741000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CB6", 747000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CB7", 753000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CB8", 759000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CB9", 765000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CC0", 771000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CC1", 777000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CC2", 783000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CC3", 789000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CC4", 795000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CC5", 801000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CC6", 807000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CC7", 813000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CC8", 819000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CC9", 825000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CD0", 831000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CD1", 837000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CD2", 843000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CD3", 849000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CD4", 855000000, MODE_QAM_256, 5217},
   {(U8BIT *)"CD5", 861000000, MODE_QAM_256, 5217}
};

// country data definitions...
#ifdef COUNTRY_UK
static const ACFG_LANGUAGE_IDS gbr_db_lang_data[] =
{
   // name string,   lang code
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_DB_LANG_UND, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_WELSH, {ACFG_DB_LANG_WELSH1, ACFG_DB_LANG_WELSH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_GAELIC, {ACFG_DB_LANG_GAELIC, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_IRISH, {ACFG_DB_LANG_IRISH2, ACFG_INVALID_DB_LANG}}
};

static ACFG_DYNAMIC_SI_UPDATES gbr_terr_si_updates[] =
{
   {
      (ACFG_DYNAMIC_SI_UPDATE_LCNS |
       ACFG_DYNAMIC_SI_UPDATE_SERVICE_ADD |
       ACFG_DYNAMIC_SI_UPDATE_SERVICE_REMOVE |
       ACFG_DYNAMIC_SI_UPDATE_SERVICE_MOVE),
      0x233a           /* UK terrestrial network ID */
   },
   {ACFG_DYNAMIC_SI_UPDATE_NONE, ADB_INVALID_DVB_ID}
};
#endif

#ifdef COUNTRY_NETHERLANDS
static const ACFG_LANGUAGE_IDS nld_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_DUTCH, {ACFG_DB_LANG_DUTCH1, ACFG_DB_LANG_DUTCH2, ACFG_INVALID_DB_LANG}}
};

static ACFG_COUNTRY_SPECIFIC_DESCRIPTOR nl_si_descs[] =
{
   {0x83, USER_DEF_DESCRIP_LOGICAL_CHAN_NUM},
   {0x00, USER_DEF_DESCRIP_NOT_USED}
};
#endif

#ifdef COUNTRY_GERMANY
static const ACFG_LANGUAGE_IDS deu_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_GERMAN, {ACFG_DB_LANG_GERMAN1, ACFG_DB_LANG_GERMAN2, ACFG_INVALID_DB_LANG}}
};

static ACFG_COUNTRY_SPECIFIC_DESCRIPTOR deu_si_descs[] =
{
   {0x83, USER_DEF_DESCRIP_LOGICAL_CHAN_NUM},
   {0x00, USER_DEF_DESCRIP_NOT_USED}
};
#endif

#ifdef COUNTRY_FRANCE
static const ACFG_LANGUAGE_IDS fra_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_FRENCH, {ACFG_DB_LANG_FRENCH1, ACFG_DB_LANG_FRENCH2, ACFG_INVALID_DB_LANG}}
};

static ACFG_COUNTRY_SPECIFIC_DESCRIPTOR fra_si_descs[] =
{
   {0x83, USER_DEF_DESCRIP_LOGICAL_CHAN_NUM},
   {0x00, USER_DEF_DESCRIP_NOT_USED}
};
#endif

#ifdef COUNTRY_RUSSIA
static const ACFG_LANGUAGE_IDS rus_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_RUSSIAN, {ACFG_DB_LANG_RUSSIAN, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_AUSTRALIA
static const ACFG_REGION_DATA aus_region_data[] =
{
   // name_str,   id
   {(U8BIT *)"NSW/ACT", 2},
   {(U8BIT *)"VIC", 3},
   {(U8BIT *)"QLD", 4},
   {(U8BIT *)"SA", 5},
   {(U8BIT *)"WA", 6},
   {(U8BIT *)"TAS", 7},
   {(U8BIT *)"NT", 8}
};

static const ACFG_LANGUAGE_IDS aus_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}}
};

static ACFG_COUNTRY_SPECIFIC_DESCRIPTOR aus_si_descs[] =
{
   {0x83, USER_DEF_DESCRIP_LOGICAL_CHAN_NUM},
   {0x84, USER_DEF_DESCRIP_PREF_NAME_LIST},
   {0x85, USER_DEF_DESCRIP_PREF_NAME_ID},
   {0x00, USER_DEF_DESCRIP_NOT_USED}
};
#endif

#ifdef COUNTRY_CHINA
static const ACFG_LANGUAGE_IDS chi_db_lang_data[] =
{
   // name string,   lang code
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_SIMPLIFIED_CHINESE, {ACFG_DB_LANG_SIMPLIFIED_CHINESE, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_TRADITIONAL_CHINESE, {ACFG_DB_LANG_TRADITIONAL_CHINESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_FINLAND
static const ACFG_LANGUAGE_IDS fin_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_FINNISH, {ACFG_DB_LANG_FINNISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_SWEDISH, {ACFG_DB_LANG_SWEDISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_NORWEGIAN, {ACFG_DB_LANG_NORWEGIAN, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_DANISH, {ACFG_DB_LANG_DANISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}}
};

static ACFG_DYNAMIC_SI_UPDATES fin_terr_si_updates[] =
{
   {
      (ACFG_DYNAMIC_SI_UPDATE_LCNS | ACFG_DYNAMIC_SI_UPDATE_SERVICE_ADD | ACFG_DYNAMIC_SI_UPDATE_SERVICE_REMOVE),
      0x20f6           /* Finnish terrestrial network ID */
   },
   {ACFG_DYNAMIC_SI_UPDATE_NONE, ADB_INVALID_DVB_ID}
};
#endif

#ifdef COUNTRY_AUSTRIA
static const ACFG_LANGUAGE_IDS aut_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_GERMAN, {ACFG_DB_LANG_GERMAN1, ACFG_DB_LANG_GERMAN2, ACFG_INVALID_DB_LANG}}
};

static ACFG_COUNTRY_SPECIFIC_DESCRIPTOR aut_si_descs[] =
{
   {0x83, USER_DEF_DESCRIP_LOGICAL_CHAN_NUM},
   {0x00, USER_DEF_DESCRIP_NOT_USED}
};
#endif

#ifdef COUNTRY_SWITZERLAND
static const ACFG_LANGUAGE_IDS che_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_GERMAN, {ACFG_DB_LANG_GERMAN1, ACFG_DB_LANG_GERMAN2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_FRENCH, {ACFG_DB_LANG_FRENCH1, ACFG_DB_LANG_FRENCH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ITALIAN, {ACFG_DB_LANG_ITALIAN, ACFG_INVALID_DB_LANG}}
};

static ACFG_COUNTRY_SPECIFIC_DESCRIPTOR che_si_descs[] =
{
   {0x83, USER_DEF_DESCRIP_LOGICAL_CHAN_NUM},
   {0x00, USER_DEF_DESCRIP_NOT_USED}
};
#endif

#ifdef COUNTRY_CZECHREP
static const ACFG_LANGUAGE_IDS cze_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_CZECH, {ACFG_DB_LANG_CZECH1, ACFG_DB_LANG_CZECH2, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_SLOVAKIA
static const ACFG_LANGUAGE_IDS svk_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SLOVAK, {ACFG_DB_LANG_SLOVAK1, ACFG_DB_LANG_SLOVAK2, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_SOUTHAFRICA
static const ACFG_LANGUAGE_IDS zaf_db_lang_data[] =
{
   // name string,      lang code
   {DVB_LANGUAGE_AFRIKAANS, {ACFG_DB_LANG_AFRIKAANS, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_NDEBELE, {ACFG_DB_LANG_NDEBELE, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_NORTHERN_SOTHO, {ACFG_DB_LANG_NORTHERN_SOTHO, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_SOUTHERN_SOTHO, {ACFG_DB_LANG_SOUTHERN_SOTHO, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_SWATI, {ACFG_DB_LANG_SWATI, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_TSONGA, {ACFG_DB_LANG_TSONGA, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_TSWANA, {ACFG_DB_LANG_TSWANA, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_VENDA, {ACFG_DB_LANG_VENDA, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_XHOSA, {ACFG_DB_LANG_XHOSA, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ZULU, {ACFG_DB_LANG_ZULU, ACFG_INVALID_DB_LANG}}
};

static ACFG_COUNTRY_SPECIFIC_DESCRIPTOR sa_si_descs[] =
{
   {0x83, USER_DEF_DESCRIP_LOGICAL_CHAN_NUM},
   {0x00, USER_DEF_DESCRIP_NOT_USED}
};
#endif

#ifdef COUNTRY_BELGIUM
static const ACFG_LANGUAGE_IDS bel_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_DUTCH, {ACFG_DB_LANG_DUTCH1, ACFG_DB_LANG_DUTCH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_FRENCH, {ACFG_DB_LANG_FRENCH1, ACFG_DB_LANG_FRENCH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_GERMAN, {ACFG_DB_LANG_GERMAN1, ACFG_DB_LANG_GERMAN2, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_CROATIA
static const ACFG_LANGUAGE_IDS hrv_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_CROATIAN, {ACFG_DB_LANG_CROATIAN, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_HUNGARY
static const ACFG_LANGUAGE_IDS hun_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_HUNGARIAN, {ACFG_DB_LANG_HUNGARIAN, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_ITALY
static const ACFG_LANGUAGE_IDS ita_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_ITALIAN, {ACFG_DB_LANG_ITALIAN, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_LATVIA
static const ACFG_LANGUAGE_IDS lva_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_LATVIAN, {ACFG_DB_LANG_LATVIAN, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_RUSSIAN, {ACFG_DB_LANG_RUSSIAN, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_LUXEMBOURG
static const ACFG_LANGUAGE_IDS lux_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_LUXEMBOURGISH, {ACFG_DB_LANG_LUXEMBOURGISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_FRENCH, {ACFG_DB_LANG_FRENCH1, ACFG_DB_LANG_FRENCH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_GERMAN, {ACFG_DB_LANG_GERMAN1, ACFG_DB_LANG_GERMAN2, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_POLAND
static const ACFG_LANGUAGE_IDS pol_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_POLISH, {ACFG_DB_LANG_POLISH, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_PORTUGAL
static const ACFG_LANGUAGE_IDS por_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_SERBIA
static const ACFG_LANGUAGE_IDS srb_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SERBIAN, {ACFG_DB_LANG_SERBIAN, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ROMANIAN, {ACFG_DB_LANG_ROMANIAN1, ACFG_DB_LANG_ROMANIAN2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_HUNGARIAN, {ACFG_DB_LANG_HUNGARIAN, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_SLOVAK, {ACFG_DB_LANG_SLOVAK1, ACFG_DB_LANG_SLOVAK2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_CROATIAN, {ACFG_DB_LANG_CROATIAN, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ALBANIAN, {ACFG_DB_LANG_ALBANIAN1, ACFG_DB_LANG_ALBANIAN2, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_SLOVENIA
static const ACFG_LANGUAGE_IDS svn_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SLOVENE, {ACFG_DB_LANG_SLOVENE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_SPAIN
static const ACFG_LANGUAGE_IDS esp_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_CATALAN, {ACFG_DB_LANG_CATALAN, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_GALICIAN, {ACFG_DB_LANG_GALICIAN, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_BASQUE, {ACFG_DB_LANG_BASQUE1, ACFG_DB_LANG_BASQUE2, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_SWEDEN
static const ACFG_LANGUAGE_IDS swe_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SWEDISH, {ACFG_DB_LANG_SWEDISH, ACFG_INVALID_DB_LANG}}
};

static ACFG_DYNAMIC_SI_UPDATES swe_terr_si_updates[] =
{
   {
      (ACFG_DYNAMIC_SI_UPDATE_LCNS | ACFG_DYNAMIC_SI_UPDATE_SERVICE_ADD | ACFG_DYNAMIC_SI_UPDATE_SERVICE_REMOVE),
      0x22f1           /* Swedish terrestrial network ID */
   },
   {ACFG_DYNAMIC_SI_UPDATE_NONE, ADB_INVALID_DVB_ID}
};
#endif

#ifdef COUNTRY_UKRAINE
static const ACFG_LANGUAGE_IDS ukr_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_UKRAINIAN, {ACFG_DB_LANG_UKRAINIAN, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_RUSSIAN, {ACFG_DB_LANG_RUSSIAN, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_ARGENTINA
static const ACFG_LANGUAGE_IDS arg_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_BOLIVIA
static const ACFG_LANGUAGE_IDS bol_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_BRAZIL
static const ACFG_LANGUAGE_IDS bra_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_CHILE
static const ACFG_LANGUAGE_IDS chl_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_COLOMBIA
static const ACFG_LANGUAGE_IDS col_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_COSTARICA
static const ACFG_LANGUAGE_IDS cri_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_DOMINICANREP
static const ACFG_LANGUAGE_IDS dma_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_ECUADOR
static const ACFG_LANGUAGE_IDS ecu_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_ELSALVADOR
static const ACFG_LANGUAGE_IDS slv_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_GUATEMALA
static const ACFG_LANGUAGE_IDS gtm_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_HONDURAS
static const ACFG_LANGUAGE_IDS hnd_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_MEXICO
static const ACFG_LANGUAGE_IDS mex_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_NICARAGUA
static const ACFG_LANGUAGE_IDS nic_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_PANAMA
static const ACFG_LANGUAGE_IDS pan_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_PERU
static const ACFG_LANGUAGE_IDS per_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_VENEZUELA
static const ACFG_LANGUAGE_IDS ven_db_lang_data[] =
{
   // name string,   db lang id
   {DVB_LANGUAGE_SPANISH, {ACFG_DB_LANG_SPANISH1, ACFG_DB_LANG_SPANISH2, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_PORTUGUESE, {ACFG_DB_LANG_PORTUGUESE, ACFG_INVALID_DB_LANG}}
};
#endif

#ifdef COUNTRY_DENMARK
static const ACFG_LANGUAGE_IDS dnk_db_lang_data[] =
{
   // name string,   lang code
   {DVB_LANGUAGE_DANISH, {ACFG_DB_LANG_DANISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_DB_LANG_UND, ACFG_INVALID_DB_LANG}},
};

static ACFG_DYNAMIC_SI_UPDATES dnk_terr_si_updates[] =
{
   {
      (ACFG_DYNAMIC_SI_UPDATE_LCNS | ACFG_DYNAMIC_SI_UPDATE_SERVICE_ADD | ACFG_DYNAMIC_SI_UPDATE_SERVICE_REMOVE),
      0x20d0           /* Danish terrestrial network ID */
   },
   {ACFG_DYNAMIC_SI_UPDATE_NONE, ADB_INVALID_DVB_ID}
};
#endif

#ifdef COUNTRY_NORWAY
static const ACFG_LANGUAGE_IDS nor_db_lang_data[] =
{
   // name string,   lang code
   {DVB_LANGUAGE_NORWEGIAN, {ACFG_DB_LANG_NORWEGIAN, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_DB_LANG_UND, ACFG_INVALID_DB_LANG}},
};

static ACFG_DYNAMIC_SI_UPDATES nor_terr_si_updates[] =
{
   {
      (ACFG_DYNAMIC_SI_UPDATE_LCNS | ACFG_DYNAMIC_SI_UPDATE_SERVICE_ADD | ACFG_DYNAMIC_SI_UPDATE_SERVICE_REMOVE),
      0x2242           /* Norwegian terrestrial network ID */
   },
   {ACFG_DYNAMIC_SI_UPDATE_NONE, ADB_INVALID_DVB_ID}
};
#endif

#ifdef COUNTRY_IRELAND
static const ACFG_LANGUAGE_IDS irl_db_lang_data[] =
{
   // name string,   lang code
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_DB_LANG_UND, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_IRISH, {ACFG_DB_LANG_IRISH1, ACFG_DB_LANG_IRISH2, ACFG_INVALID_DB_LANG}}
};

static ACFG_COUNTRY_SPECIFIC_DESCRIPTOR irl_si_descs[] =
{
   {0x83, USER_DEF_DESCRIP_LOGICAL_CHAN_NUM},
   {0x00, USER_DEF_DESCRIP_NOT_USED}
};

static ACFG_DYNAMIC_SI_UPDATES irl_terr_si_updates[] =
{
   {
      (ACFG_DYNAMIC_SI_UPDATE_LCNS | ACFG_DYNAMIC_SI_UPDATE_SERVICE_ADD | ACFG_DYNAMIC_SI_UPDATE_SERVICE_REMOVE),
      0x2174           /* Irish terrestrial network ID */
   },
   {ACFG_DYNAMIC_SI_UPDATE_NONE, ADB_INVALID_DVB_ID}
};
#endif

#ifdef COUNTRY_TAIWAN
static const ACFG_REGION_DATA twn_region_data[] =
{
};

static const ACFG_LANGUAGE_IDS twn_db_lang_data[] =
{
   // name string,   lang code
   {DVB_LANGUAGE_ENGLISH, {ACFG_DB_LANG_ENGLISH, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_SIMPLIFIED_CHINESE, {ACFG_DB_LANG_SIMPLIFIED_CHINESE, ACFG_INVALID_DB_LANG}},
   {DVB_LANGUAGE_TRADITIONAL_CHINESE, {ACFG_DB_LANG_TRADITIONAL_CHINESE, ACFG_INVALID_DB_LANG}}
};

static const ACFG_COUNTRY_SPECIFIC_DESCRIPTOR twn_si_descs[] =
{
   {0x84, USER_DEF_DESCRIP_SDT_CODE},
   {0x93, USER_DEF_DESCRIP_LOGICAL_CHAN_NUM},
   {0x00, USER_DEF_DESCRIP_NOT_USED}
};

static ACFG_DYNAMIC_SI_UPDATES twn_cab_si_updates[] =
{
#if 1  // FIXME: The dynamic-update causes a significant stability issue.
   {
      (ACFG_DYNAMIC_SI_UPDATE_LCNS | ACFG_DYNAMIC_SI_UPDATE_SERVICE_ADD | ACFG_DYNAMIC_SI_UPDATE_SERVICE_REMOVE),
      ADB_INVALID_DVB_ID           /* DVB network ID */
   },
#endif
   {ACFG_DYNAMIC_SI_UPDATE_NONE, ADB_INVALID_DVB_ID}
};
#endif

#ifdef COUNTRY_AUSTRALIA
static const U8BIT aus_content_conversion_array[] =
{
   ADB_EVENT_CONTENT_UNCLASSIFIED,        // level_1 = 0x00
   ADB_EVENT_CONTENT_MOVIE,               //           0x01
   ADB_EVENT_CONTENT_NEWS,                //           0x02
   ADB_EVENT_CONTENT_ENTERTAINMENT,       //           0x03
   ADB_EVENT_CONTENT_SPORT,               //           0x04
   ADB_EVENT_CONTENT_CHILD,               //           0x05
   ADB_EVENT_CONTENT_MUSIC,               //           0x06
   ADB_EVENT_CONTENT_ARTS,                //           0x07
   ADB_EVENT_CONTENT_SOCIAL,              // Current affairs
   ADB_EVENT_CONTENT_EDUCATION,           //           0x09
   ADB_EVENT_CONTENT_LEISURE,             //           0x0a
   ADB_EVENT_CONTENT_SPECIAL,             //           0x0b
   ADB_EVENT_CONTENT_RESERVED1,           // Comedy
   ADB_EVENT_CONTENT_RESERVED2,           // Drama
   ADB_EVENT_CONTENT_RESERVED3,           // Documentary
   ADB_EVENT_CONTENT_UNCLASSIFIED         //           0x0f
};
#endif
#ifdef COUNTRY_UK
static const U8BIT uk_content_conversion_array[] =
{
   ADB_EVENT_CONTENT_UNCLASSIFIED,        // level_1 = 0x00
   ADB_EVENT_CONTENT_MOVIE,               //           0x01
   ADB_EVENT_CONTENT_NEWS,                //           0x02
   ADB_EVENT_CONTENT_ENTERTAINMENT,       //           0x03
   ADB_EVENT_CONTENT_SPORT,               //           0x04
   ADB_EVENT_CONTENT_CHILD,               //           0x05
   ADB_EVENT_CONTENT_ENTERTAINMENT,       //           0x06
   ADB_EVENT_CONTENT_NEWS,                //           0x07
   ADB_EVENT_CONTENT_NEWS,                //           0x08
   ADB_EVENT_CONTENT_EDUCATION,           //           0x09
   ADB_EVENT_CONTENT_LEISURE,             //           0x0a
   ADB_EVENT_CONTENT_UNCLASSIFIED,        //           0x0b
   ADB_EVENT_CONTENT_UNCLASSIFIED,        //           0x0c
   ADB_EVENT_CONTENT_UNCLASSIFIED,        //           0x0d
   ADB_EVENT_CONTENT_UNCLASSIFIED,        //           0x0e
   ADB_EVENT_CONTENT_USERDEFINED          // Maps to DRAMA, but only if descriptor is preceded by a UK private data specifier
};
#endif

/* Generic content conversion array, based on level_1 values defined in ETSI 300 468,
 * for all countries that don't define their own. */
static const U8BIT content_conversion_array[] =
{
   ADB_EVENT_CONTENT_UNCLASSIFIED,        // level_1 = 0x00
   ADB_EVENT_CONTENT_MOVIE,               //           0x01
   ADB_EVENT_CONTENT_NEWS,                //           0x02
   ADB_EVENT_CONTENT_ENTERTAINMENT,       //           0x03
   ADB_EVENT_CONTENT_SPORT,               //           0x04
   ADB_EVENT_CONTENT_CHILD,               //           0x05
   ADB_EVENT_CONTENT_MUSIC,               //           0x06
   ADB_EVENT_CONTENT_ARTS,                //           0x07
   ADB_EVENT_CONTENT_SOCIAL,              //           0x08
   ADB_EVENT_CONTENT_EDUCATION,           //           0x09
   ADB_EVENT_CONTENT_LEISURE,             //           0x0a
   ADB_EVENT_CONTENT_SPECIAL,             //           0x0b
   ADB_EVENT_CONTENT_UNCLASSIFIED,        //           0x0c
   ADB_EVENT_CONTENT_UNCLASSIFIED,        //           0x0d
   ADB_EVENT_CONTENT_UNCLASSIFIED,        //           0x0e
   ADB_EVENT_CONTENT_UNCLASSIFIED         //           0x0f
};

/* Please add new countries in alphabetical order (based on the English country name) */
static ACFG_COUNTRY_CONFIG country_data_table[] =
{
#ifdef COUNTRY_ARGENTINA
   // Argentina definitions
   {
      (U8BIT *)"Argentina",
      COUNTRY_CODE_ARGENTINA,                                        // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(arg_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)arg_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_AUSTRALIA
   // australia definitions
   {
      (U8BIT *)"Australia",
      COUNTRY_CODE_AUSTRALIA,                                        // 3 character country code
      0x00000000,                                                    // private data specifier
      350,                                                           // terrestrial first unallocated LCN
      399,                                                           // terrestrial last unallocated LCN
      350,                                                           // cable first unallocated LCN
      399,                                                           // cable last unallocated LCN
      350,                                                           // satellite first unallocated LCN
      399,                                                           // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseUK,                                          /* Using UK function as this is effectively */
      DBDEF_TidyDatabaseUK,                                          /* it would have been using previously */
      DBDEF_TidyDatabaseUK,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      (sizeof(aus_region_data) / sizeof(ACFG_REGION_DATA)),         // number of regions
      (ACFG_REGION_DATA *)aus_region_data,                          // ptr to region data array
      (U8BIT *)aus_content_conversion_array,                         // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(aus_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)aus_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(aus_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)aus_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      aus_si_descs,                                                  // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_AUSTRIA
   // austria definitions
   {
      (U8BIT *)"\x0B\xD6" "sterreich",
      COUNTRY_CODE_AUSTRIA,                                          // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      (sizeof(deu_cab_rf_channel_table) / sizeof(ACFG_CAB_RF_CHANNEL_DATA)), // num cable rf channels
      (ACFG_CAB_RF_CHANNEL_DATA *)deu_cab_rf_channel_table,                  // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(aut_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)aut_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      aut_si_descs,                                                  // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_BELGIUM
   // Belgium definitions
   {
      (U8BIT *)"Belgie",
      COUNTRY_CODE_BELGIUM,                                          // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(bel_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)bel_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_BOLIVIA
   // Bolivia definitions
   {
      (U8BIT *)"Bolivia",
      COUNTRY_CODE_BOLIVIA,                                          // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(bol_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)bol_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_BRAZIL
   // Brazil definitions
   {
      (U8BIT *)"Brasil",
      COUNTRY_CODE_BRAZIL,                                           // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(bra_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)bra_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_CHILE
   // Chile definitions
   {
      (U8BIT *)"Chile",
      COUNTRY_CODE_CHILE,                                            // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(chl_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)chl_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_CHINA
   // China definitions
   {
      (U8BIT *)"China",
      COUNTRY_CODE_CHINA,                                            // 3 character country code
      0x00000000,                                                    // private data specifier
      800,                                                           // terrestrial first unallocated LCN
      899,                                                           // terrestrial last unallocated LCN
      800,                                                           // cable first unallocated LCN
      899,                                                           // cable last unallocated LCN
      800,                                                           // satellite first unallocated LCN
      899,                                                           // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(chi_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)chi_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_COLOMBIA
   // Colombia definitions
   {
      (U8BIT *)"Colombia",
      COUNTRY_CODE_COLOMBIA,                                         // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(col_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)col_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_COSTARICA
   // Costa Rica definitions
   {
      (U8BIT *)"Costa Rica",
      COUNTRY_CODE_COSTARICA,                                        // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(cri_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)cri_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_CROATIA
   // Croatia definitions
   {
      (U8BIT *)"Hrvatska",
      COUNTRY_CODE_CROATIA,                                          // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(vhf_uhf_t_t2_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)vhf_uhf_t_t2_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(hrv_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)hrv_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_CZECHREP
   // czech republic definitions
   {
      (U8BIT *)"\x06\xC8" "esk" "\xE1" " republika",
      COUNTRY_CODE_CZECHREP,                                         // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      (sizeof(deu_cab_rf_channel_table) / sizeof(ACFG_CAB_RF_CHANNEL_DATA)), // num cable rf channels
      (ACFG_CAB_RF_CHANNEL_DATA *)deu_cab_rf_channel_table,                  // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(cze_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)cze_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_DOMINICANREP
   // Dominican Republic definitions
   {
      (U8BIT *)"\x0b" "Rep" "\xFA" "blica Dominicana",
      COUNTRY_CODE_DOMINICANREP,                                     // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(dma_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)dma_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_ECUADOR
   // Ecuador definitions
   {
      (U8BIT *)"Ecuador",
      COUNTRY_CODE_ECUADOR,                                          // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(ecu_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)ecu_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_ELSALVADOR
   // El Salvador definitions
   {
      (U8BIT *)"El Salvador",
      COUNTRY_CODE_ELSALVADOR,                                       // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(slv_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)slv_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_FINLAND
   // Finnish definitions
   {
      (U8BIT *)"Suomen",
      COUNTRY_CODE_FINLAND,                                          // 3 character country code
      0x00000029,                                                    // private data specifier
      800,                                                           // terrestrial first unallocated LCN
      999,                                                           // terrestrial last unallocated LCN
      800,                                                           // cable first unallocated LCN
      899,                                                           // cable last unallocated LCN
      800,                                                           // satellite first unallocated LCN
      899,                                                           // satellite last unallocated LCN
      DBDEF_AllocateLcnsFinland,
      DBDEF_AllocateLcnsFinland,
      DBDEF_AllocateLcnsFinland,
      DBDEF_TidyDatabaseNordig,
      DBDEF_TidyDatabaseNordig,
      DBDEF_TidyDatabaseNordig,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(fin_terr_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)fin_terr_rf_channel_table,          // ptr to tuning table
      (sizeof(fin_cab_rf_channel_table) / sizeof(ACFG_CAB_RF_CHANNEL_DATA)), // num cable rf channels
      (ACFG_CAB_RF_CHANNEL_DATA *)fin_cab_rf_channel_table,          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      TRUE,                                                          // nordig
      TRUE,                                                          // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(fin_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)fin_db_lang_data,                        // ptr to db lang data
      2,                                                             // How many times per day the box should do an EIT search if in stand-by
      2,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      fin_terr_si_updates,                                           // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_FRANCE
   // france definitions
   {
      (U8BIT *)"\x05" "Fran" "\xE7" "aise",
      COUNTRY_CODE_FRANCE,                                           // 3 character country code
      0x00000000,                                                    // private data specifier
      800,                                                           // terrestrial first unallocated LCN
      899,                                                           // terrestrial last unallocated LCN
      800,                                                           // cable first unallocated LCN
      899,                                                           // cable last unallocated LCN
      800,                                                           // satellite first unallocated LCN
      899,                                                           // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(vhf_uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)vhf_uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(fra_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)fra_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      fra_si_descs,                                                  // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_GERMANY
   // germany definitions
   {
      (U8BIT *)"Deutschland",
      COUNTRY_CODE_GERMANY,                                          // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      (sizeof(vhf_uhf_ana_rf_channel_table) / sizeof(ACFG_ANA_RF_CHANNEL_DATA)), // num analog rf channels
      (ACFG_ANA_RF_CHANNEL_DATA *)vhf_uhf_ana_rf_channel_table,                  // analog rf table
      (sizeof(vhf_uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)vhf_uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      (sizeof(deu_cab_rf_channel_table) / sizeof(ACFG_CAB_RF_CHANNEL_DATA)), // num cable rf channels
      (ACFG_CAB_RF_CHANNEL_DATA *)deu_cab_rf_channel_table,                  // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(deu_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)deu_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      deu_si_descs,                                                  // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_GUATEMALA
   // Guatemala definitions
   {
      (U8BIT *)"Guatemala",
      COUNTRY_CODE_GUATEMALA,                                        // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(gtm_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)gtm_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_HONDURAS
   // Honduras definitions
   {
      (U8BIT *)"Honduras",
      COUNTRY_CODE_HONDURAS,                                         // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(hnd_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)hnd_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_HUNGARY
   // Hungary definitions
   {
      (U8BIT *)"\x05" "Magyarorsz" "\xe1" "g",
      COUNTRY_CODE_HUNGARY,                                          // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(hun_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)hun_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_ITALY
   // Italy definitions
   {
      (U8BIT *)"Italia",
      COUNTRY_CODE_ITALY,                                            // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(vhf_uhf_t_t2_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)vhf_uhf_t_t2_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(ita_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)ita_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_LATVIA
   // Latvia definitions
   {
      (U8BIT *)"Latvija",
      COUNTRY_CODE_LATVIA,                                           // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(lva_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)lva_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_LUXEMBOURG
   // Luxembourg definitions
   {
      (U8BIT *)"Luxembourg",
      COUNTRY_CODE_LUXEMBOURG,                                       // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(vhf_uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)vhf_uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(lux_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)lux_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_MEXICO
   // Mexico definitions
   {
      (U8BIT *)"\x0b" "M" "\xE9" "xico",
      COUNTRY_CODE_MEXICO,                                           // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(mex_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)mex_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_NICARAGUA
   // Nicaragua definitions
   {
      (U8BIT *)"Nicaragua",
      COUNTRY_CODE_NICARAGUA,                                        // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(nic_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)nic_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_NETHERLANDS
   // Netherlands definitions
   {
      (U8BIT *)"Nederland",
      COUNTRY_CODE_NETHERLANDS,                                      // 3 character country code
      0x00000000,                                                    // private data specifier
      800,                                                           // terrestrial first unallocated LCN
      899,                                                           // terrestrial last unallocated LCN
      800,                                                           // cable first unallocated LCN
      899,                                                           // cable last unallocated LCN
      800,                                                           // satellite first unallocated LCN
      899,                                                           // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(vhf_uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)),  // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)vhf_uhf_t_ter_rf_channel_table,                   // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(nld_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)nld_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      nl_si_descs,                                                   // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_PANAMA
   // Panama definitions
   {
      (U8BIT *)"\x0b" "Panam" "\xe1",
      COUNTRY_CODE_PANAMA,                                           // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(pan_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)pan_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_PERU
   // Peru definitions
   {
      (U8BIT *)"\x0b" "Per" "\xFA",
      COUNTRY_CODE_PERU,                                             // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      (sizeof(southamerica_cab_rf_channel_table) / sizeof(ACFG_CAB_RF_CHANNEL_DATA)), // num cable rf channels
      (ACFG_CAB_RF_CHANNEL_DATA *)southamerica_cab_rf_channel_table,                  // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(per_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)per_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_POLAND
   // Poland definitions
   {
      (U8BIT *)"Polska",
      COUNTRY_CODE_POLAND,                                           // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(pol_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)pol_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_PORTUGAL
   // Portugal definitions
   {
      (U8BIT *)"Portugal",
      COUNTRY_CODE_PORTUGAL,                                         // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(por_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)por_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_RUSSIA
   // Russian definitions
   {
      (U8BIT *)"\x01\xc0\xde\xe1\xe1\xd8\xef",
      COUNTRY_CODE_RUSSIA,                                           // 3 character country code
      0x00000000,                                                    // private data specifier
      800,                                                           // terrestrial first unallocated LCN
      899,                                                           // terrestrial last unallocated LCN
      800,                                                           // cable first unallocated LCN
      899,                                                           // cable last unallocated LCN
      800,                                                           // satellite first unallocated LCN
      899,                                                           // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_t2_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_t2_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(rus_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)rus_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_SERBIA
   // Serbia definitions
   {
      (U8BIT *)"Srbija",
      COUNTRY_CODE_SERBIA,                                           // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_t2_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_t2_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(srb_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)srb_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_SLOVAKIA
   // slovakia definitions
   {
      (U8BIT *)"Slovensko",
      COUNTRY_CODE_SLOVAKIA,                                         // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(vhf_uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)vhf_uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      (sizeof(deu_cab_rf_channel_table) / sizeof(ACFG_CAB_RF_CHANNEL_DATA)), // num cable rf channels
      (ACFG_CAB_RF_CHANNEL_DATA *)deu_cab_rf_channel_table,                  // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(svk_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)svk_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_SLOVENIA
   // Slovenia definitions
   {
      (U8BIT *)"Slovenija",
      COUNTRY_CODE_SLOVENIA,                                         // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(svn_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)svn_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_SOUTHAFRICA
   // South Africa definitions
   {
      (U8BIT *)"South Africa",
      COUNTRY_CODE_SOUTHAFRICA,                                      // 3 character country code
      0x000022c6,                                                    // SABC private data specifier
      800,                                                           // terrestrial first unallocated LCN
      899,                                                           // terrestrial last unallocated LCN
      800,                                                           // cable first unallocated LCN
      899,                                                           // cable last unallocated LCN
      800,                                                           // satellite first unallocated LCN
      899,                                                           // satellite last unallocated LCN
      DBDEF_AllocateLcnsUK,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseUK,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      1260,                                                          // start watershed
      330,                                                           // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      NULL,                                                          // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(zaf_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)),  // num terrestrial rf channels
      (ACFG_TER_RF_CHANNEL_DATA *)zaf_ter_rf_channel_table,                   // terrestrial rf table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(zaf_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)zaf_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      sa_si_descs,                                                   // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_SPAIN
   // Spain definitions
   {
      (U8BIT *)"\x0b" "Espa" "\xf1" "a",
      COUNTRY_CODE_SPAIN,                                           // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(esp_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)esp_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_SWEDEN
   // Sweden definitions
   {
      (U8BIT *)"Sverige",
      COUNTRY_CODE_SWEDEN,                                           // 3 character country code
      0x000022f1,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_t2_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_t2_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(swe_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)swe_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      swe_terr_si_updates,                                           // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_SWITZERLAND
   // switzerland definitions
   {
      (U8BIT *)"Schweiz",
      COUNTRY_CODE_SWITZERLAND,                                      // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      (sizeof(deu_cab_rf_channel_table) / sizeof(ACFG_CAB_RF_CHANNEL_DATA)), // num cable rf channels
      (ACFG_CAB_RF_CHANNEL_DATA *)deu_cab_rf_channel_table,                  // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(che_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)che_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      che_si_descs,                                                  // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_UK
   // uk definitions
   {
      (U8BIT *)"UK",                                                 // country name
      COUNTRY_CODE_UK,                                               // 3 character country code
      0x0000233a,                                                    // UK DTT private data specifier
      800,                                                           // terrestrial first unallocated LCN
      899,                                                           // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsUK,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseUK,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseSatUK,
      1260,                                                          // start watershed
      330,                                                           // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)uk_content_conversion_array,                          // table used for converting event types
      (sizeof(uhf_ana_rf_channel_table) / sizeof(ACFG_ANA_RF_CHANNEL_DATA)),  // num analog rf channels
      (ACFG_ANA_RF_CHANNEL_DATA *)uhf_ana_rf_channel_table,                   // analog rf table
      (sizeof(uhf_t_t2_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)),  // num terrestrial rf channels
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_t2_ter_rf_channel_table,                   // terrestrial rf table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      4,                                                             // number of symbol rates
      {22000, 23000, 27500, 29500},                                  // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(gbr_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)gbr_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      0,                                                             // Fall back language for those countries that don't have a secondary language concept.
                                                                     // It's an index in the db_lang_array
      gbr_terr_si_updates,                                           // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_UKRAINE
   // Ukraine definitions
   {
      (U8BIT *)"\x01\xc3\xda\xe0\xd0\xf7\xdd\xd0",
      COUNTRY_CODE_UKRAINE,                                          // 3 character country code
      0x00000000,                                                    // private data specifier
      1,                                                             // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1,                                                             // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1,                                                             // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_t2_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_t2_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      10714,                                                         // min sat freq
      12740,                                                         // max sat freq
      5,                                                             // sat freq inc
      3,                                                             // number of symbol rates
      {22000, 27500, 29500},                                         // sat symbol rates
      TRUE,                                                          // scan DVB-S2
      TRUE,                                                          // aerial power reqd
      TRUE,                                                          // default aerial power
      TRUE,                                                          // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(ukr_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)ukr_db_lang_data,                        // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_VENEZUELA
   // Venezuela definitions
   {
      (U8BIT *)"Venezuela",
      COUNTRY_CODE_VENEZUELA,                                        // 3 character country code
      0x00000000,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(ven_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)ven_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_DENMARK
   // Denmark definitions
   {
      (U8BIT *)"Danmark",
      COUNTRY_CODE_DENMARK,                                          // 3 character country code
      0x00000031,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(vhf_uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)vhf_uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      TRUE,                                                          // nordig
      TRUE,                                                          // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(dnk_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)dnk_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      dnk_terr_si_updates,                                           // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_NORWAY
   // Norway definitions
   {
      (U8BIT *)"Norge",
      COUNTRY_CODE_NORWAY,                                           // 3 character country code
      0x00000030,                                                    // private data specifier
      1000,                                                          // terrestrial first unallocated LCN
      9999,                                                          // terrestrial last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(uhf_t_ter_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)uhf_t_ter_rf_channel_table,                  // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      TRUE,                                                          // nordig
      TRUE,                                                          // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(nor_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)nor_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      nor_terr_si_updates,                                           // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_IRELAND
   // Ireland definitions
   {
      (U8BIT *)"\x05\xc9" "ire",
      COUNTRY_CODE_IRELAND,                                          // 3 character country code
      0x000022ce,                                                    // private data specifier
      1000,                                                          // first unallocated LCN
      9999,                                                          // last unallocated LCN
      1000,                                                          // cable first unallocated LCN
      9999,                                                          // cable last unallocated LCN
      1000,                                                          // satellite first unallocated LCN
      9999,                                                          // satellite last unallocated LCN
      DBDEF_AllocateLcnsIreland,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseNordig,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      (sizeof(irl_terr_rf_channel_table) / sizeof(ACFG_TER_RF_CHANNEL_DATA)), // num rf channels in table
      (ACFG_TER_RF_CHANNEL_DATA *)irl_terr_rf_channel_table,          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      TRUE,                                                          // nordig
      TRUE,                                                          // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(irl_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),       // number of db lang options
      (ACFG_LANGUAGE_IDS *)irl_db_lang_data,                        // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      irl_si_descs,                                                  // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      irl_terr_si_updates,                                           // Tables of default dynamic SI update types
      NULL,
      NULL
   },
#endif

#ifdef COUNTRY_TAIWAN
   // Taiwan definitions
   {
      (U8BIT *)"Taiwan",                                             // country name string id
      COUNTRY_CODE_TAIWAN,                                           // 3 character country code
      0x00000000,                                                    // private data specifier
      800,                                                           // terrestrial first unallocated LCN
      899,                                                           // terrestrial last unallocated LCN
      7000,                                                          // cable first unallocated LCN
      8999,                                                          // cable last unallocated LCN
      800,                                                           // satellite first unallocated LCN
      899,                                                           // satellite last unallocated LCN
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_AllocateLcnsDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      DBDEF_TidyDatabaseDefault,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      (sizeof(twn_region_data) / sizeof(ACFG_REGION_DATA)),          // number of regions
      (ACFG_REGION_DATA *)twn_region_data,                           // ptr to region data array
      (U8BIT *)content_conversion_array,                             // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      (sizeof(taiwan_cab_rf_channel_table) / sizeof(ACFG_CAB_RF_CHANNEL_DATA)), // num cable rf channels
      (ACFG_CAB_RF_CHANNEL_DATA *)taiwan_cab_rf_channel_table,       // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      (sizeof(twn_db_lang_data) / sizeof(ACFG_LANGUAGE_IDS)),        // number of db lang options
      (ACFG_LANGUAGE_IDS *)twn_db_lang_data,                         // ptr to db lang data
      1,                                                             // How many times per day the box should do an EIT search if in stand-by
      10,                                                            // Maximum time (in minutes) needed to receive all the events on a transport
      twn_si_descs,                                                  // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,                                                          // Tables of default dynamic SI update types
      twn_cab_si_updates,
      NULL
   },
#endif

/* The user defined country must be the last entry in the country_data_table */
#ifdef COUNTRY_USERDEFINED
   // Definitions for a user defined country config
   {
      (U8BIT *)"User Defined",                                       // country name
      COUNTRY_CODE_USERDEFINED,                                      // country code
      0,                                                             // private data specifier
      0,                                                             // first unallocated LCN
      0,                                                             // last unallocated LCN
      0,                                                             // cable first unallocated LCN
      0,                                                             // cable last unallocated LCN
      0,                                                             // satellite first unallocated LCN
      0,                                                             // satellite last unallocated LCN
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0xffff,                                                        // start watershed
      0xffff,                                                        // end watershed
      0,                                                             // number of regions
      NULL,                                                          // ptr to region data array
      NULL,                                                          // table used for converting event types
      0,                                                             // num analog rf channels
      NULL,                                                          // analog rf table
      0,                                                             // num rf channels in table
      NULL,                                                          // ptr to tuning table
      0,                                                             // num cable rf channels
      NULL,                                                          // cable rf table
      0,                                                             // min sat freq
      0,                                                             // max sat freq
      0,                                                             // sat freq inc
      0,                                                             // number of symbol rates
      {0},                                                           // sat symbol rates
      FALSE,                                                         // scan DVB-S2
      FALSE,                                                         // aerial power reqd
      FALSE,                                                         // default aerial power
      FALSE,                                                         // aerial tuning screen required
      FALSE,                                                         // nordig
      FALSE,                                                         // terr nordig
      FALSE,                                                         // cab nordig
      FALSE,                                                         // sat nordig
      0,                                                             // number of db lang options
      NULL,                                                          // ptr to db lang data
      0,                                                             // How many times per day the box should do an EIT search if in stand-by
      0,                                                             // Maximum time (in minutes) needed to receive all the events on a transport
      NULL,                                                          // Country specific SI descriptors
      ACFG_INVALID_LANG,                                             // Fall back language for those countries that don't have a secondary language concept
                                                                     // It's an index in the db_lang_array
      NULL,
      NULL,
      NULL
   },
#endif
};
#endif

#endif //  _AP_CFDAT_H

//**************************************************************************************************
// End of File
//**************************************************************************************************
