/*******************************************************************************
 * Copyright  2016 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Application level CI Host Control functions
 * @file    ap_cihc.h
 * @date    December 2016
 * @author  Adam Sturtridge
 */

#ifndef AP_CIHC_H
#define AP_CIHC_H
#ifdef COMMON_INTERFACE

/*---includes for this file--------------------------------------------------*/

/* compiler library header files */

/* third party header files */

/* DVBCore header files */
#include "techtype.h"
#include "stbci.h"

/*---Constant and macro definitions for public use-----------------------------*/

/*---Enumerations for public use-----------------------------------------------*/

/*---Global type defs for public use-------------------------------------------*/

/*---Global Function prototypes for public use---------------------------------*/

/**
 * @brief    Initialise CI Host Control support
 */
void ACI_HcInitialise(void);

/**
 * @brief   Ask the module to restore replaced PIDs and to close the session
 *          with the host control resource
 * @param   module specifies module required
 * @return  TRUE if operation successful, FALSE otherwise
 */
BOOLEAN ACI_HcAskRelease(U32BIT module);

/**
 * @brief   Send status of tune operation to the CAM host control module
 * @param   module host control module
 * @param   status tune operation status
 * @return  TRUE if valid module, FALSE otherwise
 */
BOOLEAN ACI_HcTuneReply(U32BIT module, E_STB_CI_TUNE_STATUS status);

#endif /*COMMON_INTERFACE*/
#endif /* AP_CIHC_H */

/******************************************************************************
** End of file
******************************************************************************/
