/*******************************************************************************
 * Copyright  2016 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Application level CI Operator Profile functions
 * @file    ap_ciop.h
 * @date    December 2016
 * @author  Adam Sturtridge
 */

#ifndef AP_CIOP_H
#define AP_CIOP_H
#ifdef COMMON_INTERFACE

/*---includes for this file--------------------------------------------------*/

/* compiler library header files */

/* third party header files */

/* DVBCore header files */
#include "techtype.h"
#include "stbci.h"

/*---Constant and macro definitions for public use-----------------------------*/

/*---Enumerations for public use-----------------------------------------------*/

/*---Global type defs for public use-------------------------------------------*/

/*---Global Function prototypes for public use---------------------------------*/

/**
 * @brief    Initialise CI Operator Profile support
 */
void ACI_OpInitialise(void);

/**
 * @brief   Process CAM removal from slot for CA support
 * @param   slot_id CI slot identifier
 */
void ACI_OpSlotRemove(U8BIT slot_id);

/**
 * @brief   Ask the opertaor module to restore replaced PIDs
 * @param   module specifies module required
 * @return  TRUE if operation successful, FALSE otherwise
 */
BOOLEAN ACI_OpAskRelease(U32BIT module);

/**
 * @brief   This function is called by the host to send the status of the tune
 *          operation to the module.
 * @param   path - decode path used for tuning
 * @param   module - host control module
 * @param   status - tune operation status
 * @return  TRUE if operation succeeded, FALSE otherwise
 */
BOOLEAN ACI_OpTuneReply(U8BIT path, U32BIT module, E_STB_CI_TUNE_STATUS status);

/**
 * @brief   Called by the host to request changing to an operator profile
 * @param   module - operator profile module
 * @return  TRUE if request succeeded, FALSE otherwise
 */
BOOLEAN ACI_RequestOperatorStatus(U32BIT module);

/**
 * @brief   Request the current operator module to exit operator profile
 * @return  TRUE if request succeeded, FALSE otherwise
 */
BOOLEAN ACI_OperatorExit(void);

/**
 * @brief   Called by the app to start an operator profile search that has been requested
 * @param   module - operator module
 * @return  TRUE if the search is started, FALSE otherwise
 */
BOOLEAN ACI_StartOperatorSearch(U32BIT module);

/**
 * @brief   Returns the Operator Profile module associated with a CICAM ID.
 * @param   cicam_id CICAM ID
 * @param   module Pointer to the Operator Profile module
 * @return  TRUE if the module could be found, FALSE otherwise
 */
BOOLEAN ACI_FindOperatorProfileModule(U32BIT cicam_id, U32BIT *module);

#endif /*COMMON_INTERFACE*/
#endif /* AP_CIOP_H */

/******************************************************************************
** End of file
******************************************************************************/
