/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2011 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   State machine to control the DVB
 * @file    ap_state.c
 * @date    July 2011
 * @author  Ocean Blue
 */

//---includes for this file----------------------------------------------------
// compiler library header files

// third party header files

// Ocean Blue Software header files

#include "techtype.h"
#include "dbgfuncs.h"


//---constant definitions for this file----------------------------------------
#ifdef STATE_DEBUG
   #define STATE_DBG(x) STB_SPDebugWrite x
#else
   #define STATE_DBG(x)
#endif


//---local typedefs, structs, enumerations for this file--------------------------------------------
typedef enum
{
   DVB_STATE_ON,
   DVB_STATE_STANDBY,
   DVB_STATE_STANDBY_RECORDING,
   DVB_STATE_STANDBY_SERV_SEARCH,
   DVB_STATE_STANDBY_SSU_SEARCH
//   DVB_STATE_STANDBY_EIT_SEARCH
} E_DVB_STATE;


//---local (static) variable declarations for this file------------------------
//   (internal variables declared static to make them local)
static E_DVB_STATE dvb_state;

//---local function prototypes for this file-----------------------------------
//   (internal functions declared static to make them local)


/*!**************************************************************************
   @brief
 ****************************************************************************/
void ASTE_Initialise(void)
{
   FUNCTION_START(ASTE_Initialise);

   dvb_state = DVB_STATE_ON;

   FUNCTION_FINISH(ASTE_Initialise);
}

/*!**************************************************************************
   @brief
 ****************************************************************************/
void ASTE_EnterStandby(BOOLEAN recording)
{
   FUNCTION_START(ASTE_EnterStandby);

   /* Only change the state if ON as all other states are standby states already */
   if (dvb_state == DVB_STATE_ON)
   {
      if (recording)
      {
         dvb_state = DVB_STATE_STANDBY_RECORDING;
      }
      else
      {
         dvb_state = DVB_STATE_STANDBY;
      }
   }

   FUNCTION_FINISH(ASTE_EnterStandby);
}

/*!**************************************************************************
   @brief
 ****************************************************************************/
void ASTE_LeaveStandby(void)
{
   FUNCTION_START(ASTE_LeaveStandby);

   //if (dvb_state == DVB_STATE_STANDBY)
   {
      dvb_state = DVB_STATE_ON;
   }

   FUNCTION_FINISH(ASTE_LeaveStandby);
}

/*!**************************************************************************
   @brief
 ****************************************************************************/
BOOLEAN ASTE_InStandby(void)
{
   BOOLEAN retval;

   FUNCTION_START(ASTE_InStandby);

   if (dvb_state == DVB_STATE_ON)
   {
      retval = FALSE;
   }
   else
   {
      retval = TRUE;
   }

   FUNCTION_FINISH(ASTE_InStandby);

   return(retval);
}

/*!**************************************************************************
   @brief
 ****************************************************************************/
void ASTE_StartRecording(void)
{
   FUNCTION_START(ASTE_StartRecording);

   if (dvb_state == DVB_STATE_STANDBY)
   {
      dvb_state = DVB_STATE_STANDBY_RECORDING;
   }

   FUNCTION_FINISH(ASTE_StartRecording);
}

/*!**************************************************************************
   @brief
 ****************************************************************************/
void ASTE_StartServiceSearch(void)
{
   FUNCTION_START(ASTE_StartServiceSearch);

   if (dvb_state == DVB_STATE_STANDBY)
   {
      dvb_state = DVB_STATE_STANDBY_SERV_SEARCH;
   }

   FUNCTION_FINISH(ASTE_StartServiceSearch);
}

/*!**************************************************************************
   @brief
 ****************************************************************************/
void ASTE_StartSSUSearch(void)
{
   FUNCTION_START(ASTE_StartSSUSearch);

   if (dvb_state == DVB_STATE_STANDBY)
   {
      dvb_state = DVB_STATE_STANDBY_SSU_SEARCH;
   }

   FUNCTION_FINISH(ASTE_StartSSUSearch);
}

/*!**************************************************************************
   @brief
 ****************************************************************************/
void ASTE_SearchComplete(void)
{
   FUNCTION_START(ASTE_SearchComplete);

   if ((dvb_state == DVB_STATE_STANDBY_SERV_SEARCH) || (dvb_state == DVB_STATE_STANDBY_SSU_SEARCH))
   {
      dvb_state = DVB_STATE_STANDBY;
   }

   FUNCTION_FINISH(ASTE_SearchComplete);
}

//--------------------------------------------------------------------------------------------------
// local function definitions
//--------------------------------------------------------------------------------------------------

/*!**************************************************************************
 ****************************************************************************/

