/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Blank description
 * @file    dvbver.c
 * @date    01/12/2004
 * @author  Ocean Blue
 */
#include <string.h>
#include <dvbver.h>

/* The DVB_VER_* must be defined (via compiler -D flag) */
#ifndef DVB_VER_MAJOR
#error DVB_VER_MAJOR is undefined!
#endif
#ifndef DVB_VER_MINOR
#error DVB_VER_MINOR is undefined!
#endif
#ifndef DVB_VER_PATCH
#error DVB_VER_PATCH is undefined!
#endif

#define xstr(s) str(s)
#define str(s) # s
#define DVB_VER_STRING (xstr(DVB_VER_MAJOR) "." xstr(DVB_VER_MINOR) "." xstr(DVB_VER_PATCH))

static const char *dvb_version_string = DVB_VER_STRING;

static const DVB_VER_STRUCT dvb_ver_number = {
   DVB_VER_MAJOR, DVB_VER_MINOR, DVB_VER_PATCH
};


U8BIT* App_DvbVersionString(void)
{
   return (U8BIT *)(dvb_version_string);
}

U32BIT App_DvbVersionNumber(void)
{
   return((dvb_ver_number.major << 16) | (dvb_ver_number.minor << 8) | (dvb_ver_number.revision));
}

void App_DvbVersionData(DVB_VER_STRUCT *vptr)
{
   if (vptr != NULL)
   {
      memcpy(vptr, &dvb_ver_number, sizeof(DVB_VER_STRUCT));
   }
}

