# Variables added for the build system

# Uncomment the following to build on the Raspberry Pi
#export DTVKIT_OSTYPE=rpi

# Location of DTVKIT root folder

export DTVKIT_ROOT=`readlink -f ..`

# Folder where the compilation products will be placed. This overrides the default 'build'
#export DTVKIT_OUTPUT_DIR=

export DTVKIT_CC=cc
export DTVKIT_AR=ar

# For 64 bit compilation, set this to '1' 
export DTVKIT_USE_STDINT=0

# Additional compiler options
export DTVKIT_ADDITIONAL_COMPILER_OPTIONS="-Wall -Wextra -m32"
# For 64 bit compilation and to build on the Raspberry Pi, '-m32' MUST be removed
#export DTVKIT_ADDITIONAL_COMPILER_OPTIONS="-Wall -Wextra"

# When compiling in release mode, this overrides the default -O2
#export DTVKIT_OPTIMISATION_OPTION=

# If set to 'release', it overrides the default mode 'debug'
#export DTVKIT_BUILD_MODE=

# Location of third party libraries source code
# Needed by libmedia.a
export DTVKIT_JPEG_INCLUDE_PATH=/usr/include
export DTVKIT_PNG_INCLUDE_PATH=/usr/include/libpng
export DTVKIT_ZLIB_INCLUDE_PATH=/usr/include

# Country specific settings
# Setting the variables below will add support for the corresponding country settings to be included
#export DTVKIT_COUNTRY_LATVIA=1
#export DTVKIT_COUNTRY_SOUTHAFRICA=1
#export DTVKIT_COUNTRY_SWEDEN=1
#export DTVKIT_COUNTRY_BELGIUM=1
#export DTVKIT_COUNTRY_UKRAINE=1
#export DTVKIT_COUNTRY_ITALY=1
#export DTVKIT_COUNTRY_SLOVAKIA=1
#export DTVKIT_COUNTRY_FINLAND=1
#export DTVKIT_COUNTRY_AUSTRIA=1
#export DTVKIT_COUNTRY_GERMANY=1
#export DTVKIT_COUNTRY_SERBIA=1
#export DTVKIT_COUNTRY_PORTUGAL=1
#export DTVKIT_COUNTRY_CHINA=1
#export DTVKIT_COUNTRY_POLAND=1
#export DTVKIT_COUNTRY_NETHERLANDS=1
#export DTVKIT_COUNTRY_SLOVENIA=1
#export DTVKIT_COUNTRY_HUNGARY=1
#export DTVKIT_COUNTRY_RUSSIA=1
#export DTVKIT_COUNTRY_CZECHREP=1
export DTVKIT_COUNTRY_UK=1
#export DTVKIT_COUNTRY_AUSTRALIA=1
#export DTVKIT_COUNTRY_LUXEMBOURG=1
#export DTVKIT_COUNTRY_SWITZERLAND=1
#export DTVKIT_COUNTRY_SPAIN=1
#export DTVKIT_COUNTRY_FRANCE=1
#export DTVKIT_COUNTRY_CROATIA=1
#export DTVKIT_COUNTRY_ARGENTINA=1
#export DTVKIT_COUNTRY_BOLIVIA=1
#export DTVKIT_COUNTRY_BRAZIL=1
#export DTVKIT_COUNTRY_CHILE=1
#export DTVKIT_COUNTRY_COLOMBIA=1
#export DTVKIT_COUNTRY_COSTARICA=1
#export DTVKIT_COUNTRY_DOMINICANREP=1
#export DTVKIT_COUNTRY_ECUADOR=1
#export DTVKIT_COUNTRY_ELSALVADOR=1
#export DTVKIT_COUNTRY_GUATEMALA=1
#export DTVKIT_COUNTRY_HONDURAS=1
#export DTVKIT_COUNTRY_MEXICO=1
#export DTVKIT_COUNTRY_NICARAGUA=1
#export DTVKIT_COUNTRY_PANAMA=1
#export DTVKIT_COUNTRY_PERU=1
#export DTVKIT_COUNTRY_VENEZUELA=1
#export DTVKIT_COUNTRY_DENMARK=1
#export DTVKIT_COUNTRY_NORWAY=1
#export DTVKIT_COUNTRY_IRELAND=1
#export DTVKIT_COUNTRY_USERDEFINED=1

# Colour depth. Default is 32 bit, export one of the following values to override the default
#export DTVKIT_COLOUR_DEPTH=8
#export DTVKIT_COLOUR_DEPTH=16

# Export the following value if you need support for ST 32 bit colour depth, where the maximum
# value for alpha is 0x80 (Only available for 32 bit colour depth)
#export DTVKIT_OSD_ST_MODE=1

# By default the EIT tables are reported in segments. Change the following to 0 to change
# the behaviour to report each section as it's received.
export DTVKIT_EIT_REPORT_SEGMENTS=1

# Change the following to 1 to enable an event to be sent when the EITpf 'now' changes on every service
export DTVKIT_SEND_ALL_NOW_EVENTS=0

# Set this to '1' to include support for DVB-SSU OTA
# If this is enabled, then the include path for the DSMCC module should also be set (see below)
export DTVKIT_INCLUDE_OTA_SSU=0

# Export the following values to compile in ADB functions to import/export the service database
# and specify the location of the libxml2 include directory
#export DTVKIT_XML_SUPPORT=1
#export DTVKIT_LIBXML2_INCLUDE_PATH=/usr/include/libxml2

#export DTVKIT_HUFFMAN_INCLUDE_PATH=

# Export the following value to include support for HbbTV 1.5, using DTVKit HBBTV component
#export DTVKIT_INCLUDE_HBBTV=1
# Export the following value to include support for HbbTV 2.0 integration - e.g DTVKit vxk-dvb component
#export DTVKIT_INCLUDE_HBBTV=2

# When DTVKIT_INCLUDE_HBBTV=1 the following must point the inc folder in DTVKit HBBTV component
#export DTVKIT_HBBTV_INCLUDE_PATH=$DTVKIT_ROOT/HBBTV/inc

# Export the following value to enable Common Interface (and CI Plus) support
# export DTVKIT_INTEGRATE_CI=1

# Export this to set location of the Common Interface header files - when building for CI Plus.
# export DTVKIT_CIPLUS_INCLUDE_PATH=$DTVKIT_ROOT/CIPlus1.4/include

# Export when building for CI+ with ECP support and building for TEE
# export DTVKIT_BUILD_FOR_TEE=1

# In CI+ ECP mode, disable mechanism of using CI+ TA to send control keys (flag only applies when building for TEE)
# export DTVKIT_CIPLUS_EXPOSE_CCK=1

# Export one of the following values to include support for MHEG5, using DTVKit MHEG5 component
# export DTVKIT_INTEGRATE_MHEG5=dsmcc
# export DTVKIT_INTEGRATE_MHEG5=ciplus
# export DTVKIT_INTEGRATE_MHEG5=dsmcc/ciplus

# Enable MHEG5 Interaction Channel Extension (IC)
# export DTVKIT_MHEG5_IC=1

# Enable MHEG5 Interaction Channel Streaming Extension (ICS)
# export DTVKIT_MHEG5_IC_STREAMING=1

# When DTVKIT_INTEGRATE_MHEG5 is set, point to MHEG5 include folder with
# export DTVKIT_MHEG5_INCLUDE_PATH=$DTVKIT_ROOT/MHEG5/include

# Location of the DSMCC engine header files
#export DTVKIT_DSMCC_INCLUDE_PATH=$DTVKIT_ROOT/DSMCC/include

# Use SQLite instead of NVM database
#export DTVKIT_INTEGRATE_SQLITE=1

# Default database file used by SQLite
export DTVKIT_DEFAULT_SQLITE_FILE=./dtvkit.sqlite3

