/*******************************************************************************
 * Copyright © 2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright © 2014 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 * 
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief    Definition of functions common withing externals/HBBTV
 * @file     common.h
 * @date     February 2014
 * @author   Sergio Panseri
 */

/* pre-processor mechanism so multiple inclusions don't cause compilation error*/

#ifndef _COMMON_H
#define _COMMON_H

#include "techtype.h"
#include "hbbtv_sif_service.h"


/*---Constant and macro definitions for public use-----------------------------*/

/*---Enumerations for public use-----------------------------------------------*/

/*---Global type defs for public use-------------------------------------------*/

/*---Global Function prototypes for public use---------------------------------*/

/**
 * @brief   Fills in the event details structure given the event handle
 * @param   event Event handle
 * @param   service Service handle
 * @param   details Pointer to the structure to fill in. HBBTV_ReleaseEventDetails can be called
 *          passing the structure pointer to ensure any allocated data relative to the event is 
 *          freed
 */
void EXT_HbbtvGetEvent(void *event, void *service, S_HBBTV_EVENT_DETAILS *details);

/**
 * @brief   Returns the recording ID associated with the specified timer handle and recording handle
 * @param   timer Timer handle
 * @param   recording Recording handle
 * @return  Recording ID
 */
U32BIT EXT_HbbtvPVRGetRecID(U32BIT timer, U32BIT recording);

/**
 * @brief   Initialises the PVR resources needed by the HbbTV external interface
 */
void EXT_HbbtvPVRInitialise(void);

/**
 * @brief   Releases the PVR resources allocated by the HbbTV external interface
 */
void EXT_HbbtvPVRTerminate(void);

/**
 * @brief   Initialises the Service resources needed by the HbbTV external interface
 */
void EXT_HbbtvServiceInitialise(void);

/**
 * @brief   Releases the Service resources allocated by the HbbTV external interface
 */
void EXT_HbbtvServiceTerminate(void);

#endif /* _COMMON_H */
