/*******************************************************************************
 * Copyright © 2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright © 2014 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 * 
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief         DVBCore external interface for the HbbTV engine
 * @file          control.c
 * @date          April 2014
 * @author        Sergio Panseri
 */


/* compiler library header files */
#include <stdio.h>

/* third party header files */
#include <techtype.h>
#include <dbgfuncs.h>

#include "hbbtv_sif_service.h"
#include "common.h"

/**
 * @brief   Initialises the HbbTV external interface
 */
void EXT_HbbtvInitialise(void)
{
   FUNCTION_START(EXT_HbbtvInitialise);
   EXT_HbbtvPVRInitialise();
   EXT_HbbtvServiceInitialise();
   FUNCTION_FINISH(EXT_HbbtvInitialise);
}

/**
 * @brief   Terminates the HbbTV external interface
 */
void EXT_HbbtvTerminate(void)
{
   FUNCTION_START(EXT_HbbtvTerminate);
   EXT_HbbtvPVRTerminate();
   EXT_HbbtvServiceTerminate();
   FUNCTION_FINISH(EXT_HbbtvTerminate);
}
