/*******************************************************************************
 * Copyright © 2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright © 2014 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 * 
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief      System Interface, debug
 * @file       debug.c
 * @date       January 2014
 * @author     Sergio
 */
 
/*---includes for this file--------------------------------------------------*/

/* compiler library header files */
#include <stdio.h>
#include <stdarg.h>

/* third party header files */

#include <techtype.h>
#include <dbgfuncs.h>
#include "hbbtv_sif_types.h"

/*---constant definitions for this file--------------------------------------*/

/*---local typedef structs for this file-------------------------------------*/

/*---local (static) variable declarations for this file----------------------*/
/*   (internal variables declared static to make them local)                 */

/*---local function prototypes for this file---------------------------------*/
/*   (internal functions declared static to make them local)                 */

/*---local function definitions----------------------------------------------*/

/*---global function definitions---------------------------------------------*/

void HBBTV_DBGPrint(const char * format, ...)
{
   va_list ap;

   FUNCTION_START(HBBTV_DBGPrint);

   va_start(ap, format);
   vprintf(format, ap);
   fflush(stdout);
   va_end(ap);

   FUNCTION_FINISH(HBBTV_DBGPrint);
}
