/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2014 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header internal to DVB MHEG interface files
 * @file    dvbmh_int.h
 * @date    12/03/2014
 * @author  Adam Sturtridge
 */

#ifndef _DVBMH_INT_H
#define _DVBMH_INT_H

#include "techtype.h"
#include "stbdpc.h"

#define INVALID_PID 0

void DVBMH_PlayAudio(U8BIT path, U16BIT audio_pid, E_STB_DP_AUDIO_CODEC codec, U16BIT ad_pid);

void DVBMH_PlayVideo(U8BIT path, U16BIT video_pid, E_STB_DP_VIDEO_CODEC codec);

BOOLEAN DVBMH_ShowSubtitles(void);

/**
 * @brief  Notify video has started, and unblank video if IC Stream is valid
 */
void DVBMH_NotifyVideoStarted(void);

#endif /*_DVBMH_INT_H*/
