/*******************************************************************************
 * Copyright © 2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright © 2014 Broadcom Corporation
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief      DVB Interface for MHEG5 engine - Events
 * @file       events.c
 * @date       July 2014
 * @author     Tomasz Bury
 */

/*---includes for this file--------------------------------------------------*/

#include "techtype.h"
#include "dbgfuncs.h"
#include "stberc.h"
#include "dvbevents.h"
#include "app.h"
#include "dvbmh_int.h"

static F_NotifyDvbEvent event_handler = NULL;

static void DVB_MhegEventHandler(U32BIT event, void *event_data, U32BIT data_size)
{
   (void)event_data;
   (void)data_size;

   FUNCTION_START(DVB_MhegEventHandler);

   switch (event)
   {
      case STB_EVENT_VIDEO_DECODE_STOPPED:
      {
         /* Notify MHEG video stream stopped playing */
         event_handler(DVB_EVENT_VIDEO_STOPPED, 0);
         break;
      }

      case STB_EVENT_AUDIO_DECODE_STOPPED:
      {
         /* Notify MHEG audio stream stopped playing */
         event_handler(DVB_EVENT_AUDIO_STOPPED, 0);
         break;
      }

      case STB_EVENT_SAMPLE_DECODE_STOPPED:
      {
         /* Notify MHEG sample stopped playing */
         event_handler(DVB_EVENT_SAMPLE_STOPPED, 0);
         break;
      }

      case STB_EVENT_SAMPLE_DECODE_STARTED:
      {
         /* Notify MHEG sample started playing */
         event_handler(DVB_EVENT_SAMPLE_STARTED, 0);
         break;
      }

      case STB_EVENT_AUDIO_DECODE_STARTED:
      {
         event_handler(DVB_EVENT_AUDIO_STARTED, 0);
         break;
      }

      case STB_EVENT_VIDEO_DECODE_STARTED:
      {
         DVBMH_NotifyVideoStarted();
         event_handler(DVB_EVENT_VIDEO_STARTED, 0);
         break;
      }

   #if defined(COMMON_INTERFACE)
     case STB_EVENT_CI_REMOVE:
         event_handler(DVB_EVENT_CICAM_REMOVE, *(U8BIT*)event_data);
         break;
   #endif

      default: /* ignore other DVB events */
         break;
   }

   FUNCTION_FINISH(DVB_MhegEventHandler);
}

E_MhegErr DVB_MhegEventsStart(F_NotifyDvbEvent handler)
{
   E_MhegErr result = MHERR_OTHER;

   FUNCTION_START(DVB_MhegEventsStart);

   event_handler = handler;

   if (event_handler)
   {
      if (APP_RegisterDVBEventHandler(DVB_MhegEventHandler))
         result = MHERR_OK;
   }

   FUNCTION_FINISH(DVB_MhegEventsStart);

   return result;
}

E_MhegErr DVB_MhegEventsStop()
{
   E_MhegErr result = MHERR_OTHER;

   FUNCTION_START(DVB_MhegEventsStop);

   if (event_handler)
   {
      if (APP_UnregisterDVBEventHandler(DVB_MhegEventHandler))
         result = MHERR_OK;
   }

   FUNCTION_FINISH(DVB_MhegEventsStop);

   return result;
}

