/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2014 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief    MHEG-5 Memory-related function
 * @file     memory.c
 * @date     31 January 2014
 * @author   Adam Sturtridge
 */

#undef DEBUG_FUNCTION

/*---includes for this file--------------------------------------------------*/

#include "techtype.h"
#include "dbgfuncs.h"
#include "stb_memory.h"
#include "stbheap.h"

/*---constant definitions for this file--------------------------------------*/

/*---local typedef structs for this file-------------------------------------*/

/*---local (static) variable declarations for this file----------------------*/
/*   (internal variables declared static to make them local) */

/*---local function prototypes for this file---------------------------------*/
/*   (internal functions declared static to make them local) */


/*---global function definitions---------------------------------------------*/

/**
 * @brief   Allocates the specified number of bytes
 * @param   size Required size of new memory block.
 * @return  Pointer to memory location.
 */
void* STB_MemAlloc(U32BIT memSize)
{
   void *data;

   FUNCTION_START(STB_MemAlloc);

   data = STB_AppGetMemory(memSize);

   FUNCTION_FINISH(STB_MemAlloc);

   return data;
}

/**
 * @brief   Releases previously allocated memory.
 * @param   ptr Pointer to the memory block to be freed
 */
void STB_MemFree(void *ptr)
{
   FUNCTION_START(STB_MemFree);

   STB_AppFreeMemory(ptr);

   FUNCTION_FINISH(STB_MemFree);
}

/****************************************************************************
** End of file
*****************************************************************************/
