/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2014 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Macro definition for memory debug
 * @file    dbgmemory.h
 * @date    January 2014
 * @author  Sergio Panseri
 */

// pre-processor mechanism so multiple inclusions don't cause compilation error
#ifndef _DBGMEMORY_H
#define _DBGMEMORY_H

#ifndef PGW_ENABLED
#ifndef _STBHEAP_C
// uncomment these #defines for memory write debuging
// you would also need to build the required functionality
// into the stb library ---> ie. by uncommenting the
// relevant #defines in source file stbheap.c
//#define DEBUG_MEMCOPY
//#define DEBUG_TEST_APPHEAP
//#define DEBUG_TEST_STBHEAP
#endif
#endif

// Define macros and function prototypes associated with debug facilities...
#ifdef DEBUG_MEMCOPY

   #include <stdarg.h>

   #define memcpy(s1, s2, n)  STB_MemCopy((s1), (s2), (n))
void* STB_MemCopy(void *s1, const void *s2, U16BIT n);

   #define memmove(s1, s2, n) STB_MemMove((s1), (s2), (n))
void* STB_MemMove(void *s1, const void *s2, U16BIT n);

   #define memset(s, c, n)    STB_MemSet((s), (c), (n))
void* STB_MemSet(void *s, int c, U16BIT n);

   #define strcpy(s1, s2)    STB_StrCopy((s1), (s2))
char* STB_StrCopy(char *s1, const char *s2);

   #define strncpy(s1, s2, n) STB_StrNCopy((s1), (s2), (n))
char* STB_StrNCopy(char *s1, const char *s2, U16BIT n);

   #define strcat(s1, s2)    STB_StrCat((s1), (s2))
char* STB_StrCat(char *s1, const char *s2);

   #define strncat(s1, s2, n) STB_StrNCat((s1), (s2), (n))
char* STB_StrNCat(char *s1, const char *s2, U16BIT n);

   #define vsprintf(s1, fmt, va)    STB_VSPrintF((s1), (fmt), (va))
int STB_VSPrintF(char *s1, const char *fmt, va_list va);

   #define sprintf                STB_SPrintF
int STB_SPrintF(char *s1, const char *fmt, ...);

   #define snprintf              STB_SNPrintF
int STB_SNPrintF(char *s1, U16BIT n, const char *fmt, ...);
#endif //#ifdef DEBUG_MEMCOPY

#ifdef DEBUG_TEST_APPHEAP
   #define DBG_CHECK_APPHEAP()   STB_CheckAppHeap()
void STB_CheckAppHeap(void);
#else
   #define DBG_CHECK_APPHEAP()
#endif //#ifdef DEBUG_TEST_APPHEAP

#ifdef DEBUG_TEST_STBHEAP
   #define DBG_CHECK_STBHEAP()   STB_CheckStbHeap()
void STB_CheckStbHeap(void);
#else
   #define DBG_CHECK_STBHEAP()
#endif //#ifdef DEBUG_TEST_STBHEAP

#endif // _DBGMEMORY_H

