/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2010 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Media image functions
 * @file    media_image.h
 * @date    22 November 2010
 * @author  Steve Ford
 */

/* pre-processor mechanism so multiple inclusions don't cause compilation error*/

#ifndef MEDIA_IMAGE_H
#define MEDIA_IMAGE_H

/*---includes for this file--------------------------------------------------*/

/* compiler library header files */

/* third party header files */

/* DVBCore header files */
#include "techtype.h"
#include "stbhwc.h"

/*---Constant and macro definitions for public use-----------------------------*/

/*---Enumerations for public use-----------------------------------------------*/

/*---Global Function prototypes for public use---------------------------------*/
BOOLEAN STB_IMGConvertPNG(U8BIT *image_data, U32BIT image_data_size, U8BIT **output_data,
   U32BIT *output_data_size, U16BIT *pixel_width, U16BIT *pixel_height);

BOOLEAN STB_IMGConvertJPEG(U8BIT *image_data, U32BIT image_data_size, U8BIT **output_data,
   U32BIT *output_data_size, U16BIT *pixel_width, U16BIT *pixel_height);

#endif /* MEDIA_IMAGE_H */

/******************************************************************************
** End of file
******************************************************************************/
