/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2009 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   API interfacing the midware with Intellibyte loader library
 * @file    stbota.h
 * @date    06/10/2009
 * @author  Sergio Panseri
 */
#ifndef _STBOTA_H
#define _STBOTA_H

#include "techtype.h"

/*---Constant and macro definitions for public use-----------------------------*/

/*---Enumerations for public use-----------------------------------------------*/

/*---Global type defs for public use-------------------------------------------*/
typedef BOOLEAN (*F_SSU_VERSION_CALLBACK)(U32BIT group_id, U32BIT group_size, U16BIT hw_model,
   U16BIT hw_version, U16BIT sw_model, U16BIT sw_version);

/*---Global Function prototypes for public use---------------------------------*/

/**
 * @brief   Starts the over-the-air download process
 * @param   onet_id original network ID of the transport containing the DSM-CC carousel
 * @param   tran_id transport ID of the transport containing the DSM-CC carousel
 * @param   serv_id service ID of the DSM-CC carousel, or DVB_INVALID_ID if the PID is given
 * @param   download_pid PID containing the download, or DVB_INVALID_ID if the service ID is given
 * @param   version_cb callback function that will be called when version info becomes available.
 *                     If the callback is NULL then the update will always be accepted
 * @return  TRUE if the update process is started, FALSE otherwise
 */
BOOLEAN STB_OTAStartLoader(U8BIT path, U16BIT onet_id, U16BIT tran_id, U16BIT serv_id,
   U16BIT download_pid, F_SSU_VERSION_CALLBACK version_cb);

/**
 * @brief   Returns the SSU download progress as a percentage
 * @return  Download progress as a percentage
 */
U8BIT STB_OTAGetProgress(void);

/**
 * @brief   This function should be called to unblock the download process.
 *          This can be used to in the case where an update may not be mandatory to allow
 *          a user to reject an update.
 * @param   status TRUE if the download should continue, FALSE otherwise
 */
void STB_OTAContinueDownload(BOOLEAN status);

/**
 * @brief   Stops the download process
 */
void STB_OTAStopLoader(void);

#endif /*  _STBOTA_H */

/******************************************************************************
** End of file
******************************************************************************/
