/*******************************************************************************
 * Copyright  2016 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2012 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief    CI Conditional Access
 * @file     stbcica.h
 * @date     28 November 2016
 * @author   Adam Sturtridge
 */

#ifndef _STBCICA_H
#define _STBCICA_H

#include "techtype.h"

/*---Constant and macro definitions for public use-----------------------------*/

/*---Enumerations for public use-----------------------------------------------*/

/*---Global type defs for public use-------------------------------------------*/

/*---Global Function prototypes for public use---------------------------------*/

/**
 * @brief   Tell whether CA descriptors were found in PMT and that CA system is
 *          supported.
 * @param   slot_id slot ID (0, 1, ...)
 * @param   pmt_data PMT data for the service
 * @return  BOOLEAN - TRUE if allowed
 */
BOOLEAN STB_CiCaSystemSupported(U8BIT slot_id, U8BIT *pmt_data);

/**
 * @brief    Report PMT to CI stack
 * @param    slot_id - slot ID (0, 1, ...)
 * @param    pmt - PMT for the service (section)
 */
void STB_CiCaReportPmt(U8BIT slot_id, U8BIT *pmt);

#endif /* _STBCICA_H */
