/*******************************************************************************
 * Copyright  2016 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2012 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief    CI Content Control - descrambler keys
 * @file     stbcikeys.h
 * @date     28 November 2016
 * @author   Adam Sturtridge
 */

#ifndef _STBCIKEYS_H
#define _STBCIKEYS_H

#include "techtype.h"

/*---Constant and macro definitions for public use-----------------------------*/

/*---Enumerations for public use-----------------------------------------------*/

/*---Global type defs for public use-------------------------------------------*/

/*---Global Function prototypes for public use---------------------------------*/

/**
 * @brief   Apply stored CC keys (if any) on given path
 * @param   path Path to apply keys on
 * @param   slot_id zero-based CI slot identifier (0, 1, ...)
 */
void STB_CiKeysApply(U8BIT path, U8BIT slot_id);

/**
 * @brief   Clear CC keys (if any) from given path
 * @param   path Path to clear keys from
 * @param   slot_id zero-based CI slot identifier (0, 1, ...)
 */
void STB_CiKeysClear(U8BIT path, U8BIT slot_id);

#endif /* _STBCIKEYS_H */
