/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header file - Function prototypes for heap memory
 *
 * @file    stbheap.h
 * @date    06/09/2000
 */
#ifndef _STBHEAP_H

#define _STBHEAP_H

#include "techtype.h"

//---Constant and macro definitions for public use-----------------------------

#ifndef PGW_ENABLED
//#define PGW_ENABLED
#endif

//---Enumerations for public use-----------------------------------------------

//---Global type defs for public use-------------------------------------------

//---Global Function prototypes for public use---------------------------------

void STB_HeapInitialise(void);

// RAM functions
#ifndef PGW_ENABLED
void* STB_GetMemory(U32BIT bytes);
void STB_FreeMemory(void *addr);
void* STB_ResizeMemory(void *ptr, U32BIT new_num_bytes);

void* STB_AppGetMemory(U32BIT bytes);
void STB_AppFreeMemory(void *addr);
void* STB_AppResizeMemory(void *ptr, U32BIT new_num_bytes);
#else
void* STB_GetMemoryPGW(U32BIT bytes, char *filename, int linenum);
void STB_FreeMemoryPGW(void *addr, char *filename, int linenum);
void* STB_ResizeMemoryPGW(void *ptr, U32BIT size, char *filename, int lineno);

void* STB_AppGetMemoryPGW(U32BIT bytes, char *filename, int linenum);
void STB_AppFreeMemoryPGW(void *addr, char *filename, int linenum);
void* STB_AppResizeMemoryPGW(void *ptr, U32BIT size, char *filename, int lineno);

void STB_MemoryDumpPGW(BOOLEAN full);

   #define STB_GetMemory(a)         STB_GetMemoryPGW(a, __FILE__, __LINE__)
   #define STB_FreeMemory(a)        STB_FreeMemoryPGW(a, __FILE__, __LINE__)
   #define STB_ResizeMemory(a, b)    STB_ResizeMemoryPGW(a, b, __FILE__, __LINE__)

   #define STB_AppGetMemory(a)      STB_AppGetMemoryPGW(a, __FILE__, __LINE__)
   #define STB_AppFreeMemory(a)     STB_AppFreeMemoryPGW(a, __FILE__, __LINE__)
   #define STB_AppResizeMemory(a, b) STB_AppResizeMemoryPGW(a, b, __FILE__, __LINE__)
#endif
void STB_AppRegisterCacheFreeFunction(BOOLEAN (*callback_function)(void));

void STB_GetHeapStats(U32BIT *total_app, U32BIT *max_app, U32BIT *num_app,
   U32BIT *total_mem, U32BIT *max_mem, U32BIT *num_mem);

#endif //  _STBHEAP_H

//*****************************************************************************
// End of file
//*****************************************************************************

