/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header file - macros and function prototypes for public use
 *
 * @file    stbinit.h
 * @date    13/10/2000
 */
#ifndef _STBINIT_H

#define _STBINIT_H

//---Constant and macro definitions for public use-----------------------------

//---Enumerations for public use-----------------------------------------------

typedef enum e_stb_ttxt_subt_control
{
   NO_TELETEXT_OR_SUBTITLES,
   EBU_SUBTITLES,                // enables teletext subtitles facilities
   DVB_SUBTITLES,                // enables DVB subtitle facilities
   DVB_SUBTITLES_AND_TELETEXT,   // enables DVB subtitles and teletext decoding without VBI
   DECODED_TELETEXT_WITH_VBI,    // enables teletext decoding and display on osd, and output via VBI
   DECODED_TELETEXT_WITHOUT_VBI, // enables teletext decoding and display on osd, no output via VBI
   VBI_TELETEXT                  // enables teletext output via VBI
} E_STB_TTXT_SUBT_CONTROL;


//---Global type defs for public use-------------------------------------------

//---Global Function prototypes for public use---------------------------------

void STB_Initialise(E_STB_TTXT_SUBT_CONTROL ttxt_subt_cntrl);

#endif //  _STBINIT_H

//*****************************************************************************
// End of file
//*****************************************************************************

