/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header file - Function prototypes for PES collection task
 *
 * @file    stbpes.h
 * @date    19/02/2004
 * @author  Ocean Blue
 */

// pre-processor mechanism so multiple inclusions don't cause compilation error

#ifndef _STBPES_H
#define _STBPES_H

#include "techtype.h"

//---Constant and macro definitions for public use-----------------------------

//---Enumerations for public use-----------------------------------------------

//---Global type defs for public use-------------------------------------------

//---Global Function prototypes for public use---------------------------------

void STB_PesCollectionTaskInitialise(void);

void STB_FlushPesCollectionTask(void);

U32BIT STB_RegisterPesCollectionCallback(void (*callback_function)(U32BIT, U8BIT, void *, U32BIT),
   U8BIT lowest_data_identifier, U8BIT highest_data_identifier);

void STB_UnregisterPesCollectionCallback(U32BIT handle);

void STB_ChangePesCollectionPID(U8BIT path, U16BIT text_pid);

#endif //  _STBPES_H

//*****************************************************************************
// End of file
//*****************************************************************************
