/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2007 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   PVR messages database access functions header file.
 * @file    stbpvrmsg.h
 * @date    Nov 2007
 * @author  Chris Aldworth
 */
/* pre-processor mechanism so multiple inclusions don't cause compilation error*/
#ifndef _STBPVRMSG_H

#define _STBPVRMSG_H

#include "techtype.h"

/*---Global Function prototypes for public use---------------------------------*/

BOOLEAN STB_PVRInitialiseMessages(void);
BOOLEAN STB_PVRAddMessage(U8BIT *message);
BOOLEAN STB_PVRDeleteMessage(U16BIT handle);
BOOLEAN STB_PVRCheckMessages(void);
U16BIT STB_PVRGetNumMessages(void);
U16BIT STB_PVRGetMessages(U16BIT **handle_array);
BOOLEAN STB_PVRGetMessageInfo(U16BIT handle, U16BIT *date, U8BIT *hour, U8BIT *min);
U8BIT* STB_PVRGetMessageText(U16BIT handle);

#endif /* _STBPVRMSG_H */

/*****************************************************************************
 * End of file
 *****************************************************************************/
