/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2014 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header file - Function prototypes for A/V control
 * @file    vtctype.h
 * @date    06/02/2014
 * @author  Ocean Blue
 */

// pre-processor mechanism so multiple inclusions don't cause compilation error
#ifndef _VTCTYPE_H
#define _VTCTYPE_H

#include "osdtype.h"


//---Constant and macro definitions for public use-----------------------------

//---Enumerations for public use-----------------------------------------------

typedef enum
{
   ASPECT_MODE_AUTO,
   ASPECT_MODE_4_3,
   ASPECT_MODE_16_9,
   ASPECT_MODE_14_9,
   ASPECT_MODE_ZOOM,
   ASPECT_MODE_CUSTOM
} E_VIDEO_ASPECT_MODE, E_STB_AV_ASPECT_MODE;

typedef enum
{
   FORMAT_CONVERSION_UNKNOWN,
   FORMAT_CONVERSION_IGNORE,
   FORMAT_CONVERSION_PANSCAN,
   FORMAT_CONVERSION_LETTERBOX,
   FORMAT_CONVERSION_LETTERBOX_14_9,
   FORMAT_CONVERSION_PILLAR_BOX,
   FORMAT_CONVERSION_ZOOM_4_3,
   FORMAT_CONVERSION_ZOOM_14_9,
   FORMAT_CONVERSION_PANSCAN_14_9,
   FORMAT_CONVERSION_FULL_4_3,
   FORMAT_CONVERSION_CENTRE_14_9,
   FORMAT_CONVERSION_CENTRE_4_3
} E_FORMAT_CONVERSION;

//---Global type defs for public use-------------------------------------------

/**
 * @brief   Callback used by the VTC module to determine what format conversion needs to
 *          be applied when the aspect mode is ASPECT_MODE_CUSTOM. The functions must
 *          return the desired format conversion for the video and display aspect ration pair.
 */
typedef E_FORMAT_CONVERSION (*F_VT_CUSTOM_MODE_CALLBACK)(E_ASPECT_RATIO video_aspect_ratio,
   E_ASPECT_RATIO display_aspect_ratio);


#endif /*_VTCTYPE_H*/
