/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Contains character map tables for converting single byte ascii codes above 0xa0
 *          to unicode codes
 *
 * @file    asciimap.h
 * @date    23/05/2001
 */

#ifndef _ASCIIMAP_H

#define _ASCIIMAP_H

#include "techtype.h"


//---constant definitions---------------------------------------------------------------------------

#define CHAR_TABLE_START_ASCII_CODE    0xa0
#define MAX_CHAR_MAP_TABLES            16

#define NULL_CHAR                                                 0x0000

#define UC_NO_BREAK_SPACE                                         0x00a0
#define UC_INVERTED_EXCLAMATION_MARK                              0x00a1
#define UC_CENT_SIGN                                              0x00a2
#define UC_POUND_SIGN                                             0x00a3
#define UC_CURRENCY_SIGN                                          0x00a4
#define UC_YEN_SIGN                                               0x00a5
#define UC_BROKEN_BAR                                             0x00a6
#define UC_SECTION_SIGN                                           0x00a7
#define UC_DIAERESIS                                              0x00a8
#define UC_COPYRIGHT_SIGN                                         0x00a9
#define UC_FEMININE_ORDINAL_INDICATOR                             0x00aa
#define UC_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK              0x00ab
#define UC_NOT_SIGN                                               0x00ac
#define UC_SOFT_HYPHEN                                            0x00ad
#define UC_REGISTERED_SIGN                                        0x00ae
#define UC_MACRON                                                 0x00af
#define UC_DEGREE_SIGN                                            0x00b0
#define UC_PLUS_MINUS_SIGN                                        0x00b1
#define UC_SUPERSCRIPT_TWO                                        0x00b2
#define UC_SUPERSCRIPT_THREE                                      0x00b3
#define UC_ACUTE_ACCENT                                           0x00b4
#define UC_MICRO_SIGN                                             0x00b5
#define UC_PILCROW_SIGN                                           0x00b6
#define UC_MIDDLE_DOT                                             0x00b7
#define UC_CEDILLA                                                0x00b8
#define UC_SUPERSCRIPT_ONE                                        0x00b9
#define UC_MASCULINE_ORDINAL_INDICATOR                            0x00ba
#define UC_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK             0x00bb
#define UC_VULGAR_FRACTION_ONE_QUARTER                            0x00bc
#define UC_VULGAR_FRACTION_ONE_HALF                               0x00bd
#define UC_VULGAR_FRACTION_THREE_QUARTERS                         0x00be
#define UC_INVERTED_QUESTION_MARK                                 0x00bf
#define UC_LATIN_CAPITAL_LETTER_A_WITH_GRAVE                      0x00c0
#define UC_LATIN_CAPITAL_LETTER_A_WITH_ACUTE                      0x00c1
#define UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX                 0x00c2
#define UC_LATIN_CAPITAL_LETTER_A_WITH_TILDE                      0x00c3
#define UC_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS                  0x00c4
#define UC_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE                 0x00c5
#define UC_LATIN_CAPITAL_LIGATURE_AE                              0x00c6
#define UC_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA                    0x00c7
#define UC_LATIN_CAPITAL_LETTER_E_WITH_GRAVE                      0x00c8
#define UC_LATIN_CAPITAL_LETTER_E_WITH_ACUTE                      0x00c9
#define UC_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX                 0x00ca
#define UC_LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS                  0x00cb
#define UC_LATIN_CAPITAL_LETTER_I_WITH_GRAVE                      0x00cc
#define UC_LATIN_CAPITAL_LETTER_I_WITH_ACUTE                      0x00cd
#define UC_LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX                 0x00ce
#define UC_LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS                  0x00cf
#define UC_LATIN_CAPITAL_LETTER_ETH                               0x00d0
#define UC_LATIN_CAPITAL_LETTER_N_WITH_TILDE                      0x00d1
#define UC_LATIN_CAPITAL_LETTER_O_WITH_GRAVE                      0x00d2
#define UC_LATIN_CAPITAL_LETTER_O_WITH_ACUTE                      0x00d3
#define UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX                 0x00d4
#define UC_LATIN_CAPITAL_LETTER_O_WITH_TILDE                      0x00d5
#define UC_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS                  0x00d6
#define UC_MULTIPLICATION_SIGN                                    0x00d7
#define UC_LATIN_CAPITAL_LETTER_O_WITH_STROKE                     0x00d8
#define UC_LATIN_CAPITAL_LETTER_U_WITH_GRAVE                      0x00d9
#define UC_LATIN_CAPITAL_LETTER_U_WITH_ACUTE                      0x00da
#define UC_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX                 0x00db
#define UC_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS                  0x00dc
#define UC_LATIN_CAPITAL_LETTER_Y_WITH_ACUTE                      0x00dd
#define UC_LATIN_CAPITAL_LETTER_THORN                             0x00de
#define UC_LATIN_SMALL_LETTER_SHARP_S                             0x00df
#define UC_LATIN_SMALL_LETTER_A_WITH_GRAVE                        0x00e0
#define UC_LATIN_SMALL_LETTER_A_WITH_ACUTE                        0x00e1
#define UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX                   0x00e2
#define UC_LATIN_SMALL_LETTER_A_WITH_TILDE                        0x00e3
#define UC_LATIN_SMALL_LETTER_A_WITH_DIAERESIS                    0x00e4
#define UC_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE                   0x00e5
#define UC_LATIN_SMALL_LIGATURE_AE                                0x00e6
#define UC_LATIN_SMALL_LETTER_C_WITH_CEDILLA                      0x00e7
#define UC_LATIN_SMALL_LETTER_E_WITH_GRAVE                        0x00e8
#define UC_LATIN_SMALL_LETTER_E_WITH_ACUTE                        0x00e9
#define UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX                   0x00ea
#define UC_LATIN_SMALL_LETTER_E_WITH_DIAERESIS                    0x00eb
#define UC_LATIN_SMALL_LETTER_I_WITH_GRAVE                        0x00ec
#define UC_LATIN_SMALL_LETTER_I_WITH_ACUTE                        0x00ed
#define UC_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX                   0x00ee
#define UC_LATIN_SMALL_LETTER_I_WITH_DIAERESIS                    0x00ef
#define UC_LATIN_SMALL_LETTER_ETH                                 0x00f0
#define UC_LATIN_SMALL_LETTER_N_WITH_TILDE                        0x00f1
#define UC_LATIN_SMALL_LETTER_O_WITH_GRAVE                        0x00f2
#define UC_LATIN_SMALL_LETTER_O_WITH_ACUTE                        0x00f3
#define UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX                   0x00f4
#define UC_LATIN_SMALL_LETTER_O_WITH_TILDE                        0x00f5
#define UC_LATIN_SMALL_LETTER_O_WITH_DIAERESIS                    0x00f6
#define UC_DIVISION_SIGN                                          0x00f7
#define UC_LATIN_SMALL_LETTER_O_WITH_STROKE                       0x00f8
#define UC_LATIN_SMALL_LETTER_U_WITH_GRAVE                        0x00f9
#define UC_LATIN_SMALL_LETTER_U_WITH_ACUTE                        0x00fa
#define UC_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX                   0x00fb
#define UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS                    0x00fc
#define UC_LATIN_SMALL_LETTER_Y_WITH_ACUTE                        0x00fd
#define UC_LATIN_SMALL_LETTER_THORN                               0x00fe
#define UC_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS                    0x00ff
#define UC_LATIN_CAPITAL_LETTER_A_WITH_MACRON                     0x0100
#define UC_LATIN_SMALL_LETTER_A_WITH_MACRON                       0x0101
#define UC_LATIN_CAPITAL_LETTER_A_WITH_BRIEVE                     0x0102
#define UC_LATIN_SMALL_LETTER_A_WITH_BRIEVE                       0x0103
#define UC_LATIN_CAPITAL_LETTER_A_WITH_OGONEK                     0x0104
#define UC_LATIN_SMALL_LETTER_A_WITH_OGONEK                       0x0105
#define UC_LATIN_CAPITAL_LETTER_C_WITH_ACUTE                      0x0106
#define UC_LATIN_SMALL_LETTER_C_WITH_ACUTE                        0x0107
#define UC_LATIN_CAPITAL_LETTER_C_WITH_CIRCUMFLEX                 0x0108
#define UC_LATIN_SMALL_LETTER_C_WITH_CIRCUMFLEX                   0x0109
#define UC_LATIN_CAPITAL_LETTER_C_WITH_DOT_ABOVE                  0x010a
#define UC_LATIN_SMALL_LETTER_C_WITH_DOT_ABOVE                    0x010b
#define UC_LATIN_CAPITAL_LETTER_C_WITH_CARON                      0x010c
#define UC_LATIN_SMALL_LETTER_C_WITH_CARON                        0x010d
#define UC_LATIN_CAPITAL_LETTER_D_WITH_CARON                      0x010e
#define UC_LATIN_SMALL_LETTER_D_WITH_CARON                        0x010f
#define UC_LATIN_CAPITAL_LETTER_D_WITH_STROKE                     0x0110
#define UC_LATIN_SMALL_LETTER_D_WITH_STROKE                       0x0111
#define UC_LATIN_CAPITAL_LETTER_E_WITH_MACRON                     0x0112
#define UC_LATIN_SMALL_LETTER_E_WITH_MACRON                       0x0113
#define UC_LATIN_CAPITAL_LETTER_E_WITH_BREVE                      0x0114
#define UC_LATIN_SMALL_LETTER_E_WITH_BREVE                        0x0115
#define UC_LATIN_CAPITAL_LETTER_E_WITH_DOT_ABOVE                  0x0116
#define UC_LATIN_SMALL_LETTER_E_WITH_DOT_ABOVE                    0x0117
#define UC_LATIN_CAPITAL_LETTER_E_WITH_OGONEK                     0x0118
#define UC_LATIN_SMALL_LETTER_E_WITH_OGONEK                       0x0119
#define UC_LATIN_CAPITAL_LETTER_E_WITH_CARON                      0x011a
#define UC_LATIN_SMALL_LETTER_E_WITH_CARON                        0x011b
#define UC_LATIN_CAPITAL_LETTER_G_WITH_CIRCUMFLEX                 0x011c
#define UC_LATIN_SMALL_LETTER_G_WITH_CIRCUMFLEX                   0x011d
#define UC_LATIN_CAPITAL_LETTER_G_WITH_BREVE                      0x011e
#define UC_LATIN_SMALL_LETTER_G_WITH_BREVE                        0x011f
#define UC_LATIN_CAPITAL_LETTER_G_WITH_DOT_ABOVE                  0x0120
#define UC_LATIN_SMALL_LETTER_G_WITH_DOT_ABOVE                    0x0121
#define UC_LATIN_CAPITAL_LETTER_G_WITH_CEDILLA                    0x0122
#define UC_LATIN_SMALL_LETTER_G_WITH_CEDILLA                      0x0123
#define UC_LATIN_CAPITAL_LETTER_H_WITH_CIRCUMFLEX                 0x0124
#define UC_LATIN_SMALL_LETTER_H_WITH_CIRCUMFLEX                   0x0125
#define UC_LATIN_CAPITAL_LETTER_H_WITH_STROKE                     0x0126
#define UC_LATIN_SMALL_LETTER_H_WITH_STROKE                       0x0127
#define UC_LATIN_CAPITAL_LETTER_I_WITH_TILDE                      0x0128
#define UC_LATIN_SMALL_LETTER_I_WITH_TILDE                        0x0129
#define UC_LATIN_CAPITAL_LETTER_I_WITH_MACRON                     0x012a
#define UC_LATIN_SMALL_LETTER_I_WITH_MACRON                       0x012b
#define UC_LATIN_CAPITAL_LETTER_I_WITH_BREVE                      0x012c
#define UC_LATIN_SMALL_LETTER_I_WITH_BREVE                        0x012d
#define UC_LATIN_CAPITAL_LETTER_I_WITH_OGONEK                     0x012e
#define UC_LATIN_SMALL_LETTER_I_WITH_OGONEK                       0x012f
#define UC_LATIN_CAPITAL_LETTER_I_WITH_DOT_ABOVE                  0x0130
#define UC_LATIN_SMALL_LETTER_DOTLESS_I                           0x0131
#define UC_LATIN_CAPITAL_LIGATURE_IJ                              0x0132
#define UC_LATIN_SMALL_LIGATURE_IJ                                0x0133
#define UC_LATIN_CAPITAL_LETTER_J_WITH_CIRCUMFLEX                 0x0134
#define UC_LATIN_SMALL_LETTER_J_WITH_CIRCUMFLEX                   0x0135
#define UC_LATIN_CAPITAL_LETTER_K_WITH_CEDILLA                    0x0136
#define UC_LATIN_SMALL_LETTER_K_WITH_CEDILLA                      0x0137
#define UC_LATIN_SMALL_LETTER_KRA                                 0x0138
#define UC_LATIN_CAPITAL_LETTER_L_WITH_ACUTE                      0x0139
#define UC_LATIN_SMALL_LETTER_L_WITH_ACUTE                        0x013a
#define UC_LATIN_CAPITAL_LETTER_L_WITH_CEDILLA                    0x013b
#define UC_LATIN_SMALL_LETTER_L_WITH_CEDILLA                      0x013c
#define UC_LATIN_CAPITAL_LETTER_L_WITH_CARON                      0x013d
#define UC_LATIN_SMALL_LETTER_L_WITH_CARON                        0x013e
#define UC_LATIN_CAPITAL_LETTER_L_WITH_MIDDLE_DOT                 0x013f
#define UC_LATIN_SMALL_LETTER_L_WITH_MIDDLE_DOT                   0x0140
#define UC_LATIN_CAPITAL_LETTER_L_WITH_STROKE                     0x0141
#define UC_LATIN_SMALL_LETTER_L_WITH_STROKE                       0x0142
#define UC_LATIN_CAPITAL_LETTER_N_WITH_ACUTE                      0x0143
#define UC_LATIN_SMALL_LETTER_N_WITH_ACUTE                        0x0144
#define UC_LATIN_CAPITAL_LETTER_N_WITH_CEDILLA                    0x0145
#define UC_LATIN_SMALL_LETTER_N_WITH_CEDILLA                      0x0146
#define UC_LATIN_CAPITAL_LETTER_N_WITH_CARON                      0x0147
#define UC_LATIN_SMALL_LETTER_N_WITH_CARON                        0x0148
#define UC_LATIN_SMALL_LETTER_N_PRECEDED_BY_APOSTROPHE            0x0149
#define UC_LATIN_CAPITAL_ENG                                      0x014a
#define UC_LATIN_CAPITAL_LETTER_ENG                               0x014a
#define UC_LATIN_SMALL_LETTER_ENG                                 0x014b
#define UC_LATIN_CAPITAL_LETTER_O_WITH_MACRON                     0x014c
#define UC_LATIN_SMALL_LETTER_O_WITH_MACRON                       0x014d
#define UC_LATIN_CAPITAL_LETTER_O_WITH_BREVE                      0x014e
#define UC_LATIN_SMALL_LETTER_O_WITH_BREVE                        0x014f
#define UC_LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_ACUTE               0x0150
#define UC_LATIN_SMALL_LETTER_O_WITH_DOUBLE_ACUTE                 0x0151
#define UC_LATIN_CAPITAL_LIGATURE_OE                              0x0152
#define UC_LATIN_SMALL_LIGATURE_OE                                0x0153
#define UC_LATIN_CAPITAL_LETTER_R_WITH_ACUTE                      0x0154
#define UC_LATIN_SMALL_LETTER_R_WITH_ACUTE                        0x0155
#define UC_LATIN_CAPITAL_LETTER_R_WITH_CEDILLA                    0x0156
#define UC_LATIN_SMALL_LETTER_R_WITH_CEDILLA                      0x0157
#define UC_LATIN_CAPITAL_LETTER_R_WITH_CARON                      0x0158
#define UC_LATIN_SMALL_LETTER_R_WITH_CARON                        0x0159
#define UC_LATIN_CAPITAL_LETTER_S_WITH_ACUTE                      0x015a
#define UC_LATIN_SMALL_LETTER_S_WITH_ACUTE                        0x015b
#define UC_LATIN_CAPITAL_LETTER_S_WITH_CIRCUMFLEX                 0x015c
#define UC_LATIN_SMALL_LETTER_S_WITH_CIRCUMFLEX                   0x015d
#define UC_LATIN_CAPITAL_LETTER_S_WITH_CEDILLA                    0x015e
#define UC_LATIN_SMALL_LETTER_S_WITH_CEDILLA                      0x015f
#define UC_LATIN_CAPITAL_LETTER_S_WITH_CARON                      0x0160
#define UC_LATIN_SMALL_LETTER_S_WITH_CARON                        0x0161
#define UC_LATIN_CAPITAL_LETTER_T_WITH_CEDILLA                    0x0162
#define UC_LATIN_SMALL_LETTER_T_WITH_CEDILLA                      0x0163
#define UC_LATIN_CAPITAL_LETTER_T_WITH_CARON                      0x0164
#define UC_LATIN_SMALL_LETTER_T_WITH_CARON                        0x0165
#define UC_LATIN_CAPITAL_LETTER_T_WITH_STROKE                     0x0166
#define UC_LATIN_SMALL_LETTER_T_WITH_STROKE                       0x0167
#define UC_LATIN_CAPITAL_LETTER_U_WITH_TILDE                      0x0168
#define UC_LATIN_SMALL_LETTER_U_WITH_TILDE                        0x0169
#define UC_LATIN_CAPITAL_LETTER_U_WITH_MACRON                     0x016a
#define UC_LATIN_SMALL_LETTER_U_WITH_MACRON                       0x016b
#define UC_LATIN_CAPITAL_LETTER_U_WITH_BREVE                      0x016c
#define UC_LATIN_SMALL_LETTER_U_WITH_BREVE                        0x016d
#define UC_LATIN_CAPITAL_LETTER_U_WITH_RING_ABOVE                 0x016e
#define UC_LATIN_SMALL_LETTER_U_WITH_RING_ABOVE                   0x016f
#define UC_LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_ACUTE               0x0170
#define UC_LATIN_SMALL_LETTER_U_WITH_DOUBLE_ACUTE                 0x0171
#define UC_LATIN_CAPITAL_LETTER_U_WITH_OGONEK                     0x0172
#define UC_LATIN_SMALL_LETTER_U_WITH_OGONEK                       0x0173
#define UC_LATIN_CAPITAL_LETTER_W_WITH_CIRCUMFLEX                 0x0174
#define UC_LATIN_SMALL_LETTER_W_WITH_CIRCUMFLEX                   0x0175
#define UC_LATIN_CAPITAL_LETTER_Y_WITH_CIRCUMFLEX                 0x0176
#define UC_LATIN_SMALL_LETTER_Y_WITH_CIRCUMFLEX                   0x0177
#define UC_LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS                  0x0178
#define UC_LATIN_CAPITAL_LETTER_Z_WITH_ACUTE                      0x0179
#define UC_LATIN_SMALL_LETTER_Z_WITH_ACUTE                        0x017a
#define UC_LATIN_CAPITAL_LETTER_Z_WITH_DOT_ABOVE                  0x017b
#define UC_LATIN_SMALL_LETTER_Z_WITH_DOT_ABOVE                    0x017c
#define UC_LATIN_CAPITAL_LETTER_Z_WITH_CARON                      0x017d
#define UC_LATIN_SMALL_LETTER_Z_WITH_CARON                        0x017e
#define UC_CARON                                                  0x02c7
#define UC_BREVE                                                  0x02d8
#define UC_DOT_ABOVE                                              0x02d9
#define UC_OGONEK                                                 0x02db
#define UC_DOUBLE_ACUTE_ACCENT                                    0x02dd
#define UC_COMBINING_GRAVE_ACCENT                                 0x0300
#define UC_COMBINING_ACUTE_ACCENT                                 0x0301
#define UC_COMBINING_CIRCUMFLEX_ACCENT                            0x0302
#define UC_COMBINING_TILDE                                        0x0303
#define UC_COMBINING_MACRON                                       0x0304
#define UC_COMBINING_BREVE                                        0x0306
#define UC_COMBINING_DOT_ABOVE                                    0x0307
#define UC_COMBINING_DIAERESIS                                    0x0308
#define UC_COMBINING_RING_ABOVE                                   0x030a
#define UC_COMBINING_DOUBLE_ACUTE_ACCENT                          0x030b
#define UC_COMBINING_CARON                                        0x030c
#define UC_COMBINING_CEDILLA                                      0x0327
#define UC_COMBINING_OGONEK                                       0x0328
#define UC_GREEK_TONOS                                            0x0384
#define UC_GREEK_DIALYTIKA_TONOS                                  0x0385
#define UC_GREEK_CAPITAL_LETTER_ALPHA_WITH_TONOS                  0x0386
#define UC_GREEK_ANO_TELEIA                                       0x0387
#define UC_GREEK_CAPITAL_LETTER_EPSILON_WITH_TONOS                0x0388
#define UC_GREEK_CAPITAL_LETTER_ETA_WITH_TONOS                    0x0389
#define UC_GREEK_CAPITAL_LETTER_IOTA_WITH_TONOS                   0x038a
#define UC_GREEK_CAPITAL_LETTER_OMICRON_WITH_TONOS                0x038c
#define UC_GREEK_CAPITAL_LETTER_UPSILON_WITH_TONOS                0x038e
#define UC_GREEK_CAPITAL_LETTER_OMEGA_WITH_TONOS                  0x038f
#define UC_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_TONOS       0x0390
#define UC_GREEK_CAPITAL_LETTER_ALPHA                             0x0391
#define UC_GREEK_CAPITAL_LETTER_BETA                              0x0392
#define UC_GREEK_CAPITAL_LETTER_GAMMA                             0x0393
#define UC_GREEK_CAPITAL_LETTER_DELTA                             0x0394
#define UC_GREEK_CAPITAL_LETTER_EPSILON                           0x0395
#define UC_GREEK_CAPITAL_LETTER_ZETA                              0x0396
#define UC_GREEK_CAPITAL_LETTER_ETA                               0x0397
#define UC_GREEK_CAPITAL_LETTER_THETA                             0x0398
#define UC_GREEK_CAPITAL_LETTER_IOTA                              0x0399
#define UC_GREEK_CAPITAL_LETTER_KAPPA                             0x039a
#define UC_GREEK_CAPITAL_LETTER_LAMDA                             0x039b
#define UC_GREEK_CAPITAL_LETTER_MU                                0x039c
#define UC_GREEK_CAPITAL_LETTER_NU                                0x039d
#define UC_GREEK_CAPITAL_LETTER_XI                                0x039e
#define UC_GREEK_CAPITAL_LETTER_OMICRON                           0x039f
#define UC_GREEK_CAPITAL_LETTER_PI                                0x03a0
#define UC_GREEK_CAPITAL_LETTER_RHO                               0x03a1
#define UC_GREEK_CAPITAL_LETTER_SIGMA                             0x03a3
#define UC_GREEK_CAPITAL_LETTER_TAU                               0x03a4
#define UC_GREEK_CAPITAL_LETTER_UPSILON                           0x03a5
#define UC_GREEK_CAPITAL_LETTER_PHI                               0x03a6
#define UC_GREEK_CAPITAL_LETTER_CHI                               0x03a7
#define UC_GREEK_CAPITAL_LETTER_PSI                               0x03a8
#define UC_GREEK_CAPITAL_LETTER_OMEGA                             0x03a9
#define UC_GREEK_CAPITAL_LETTER_IOTA_WITH_DIALYTIKA               0x03aa
#define UC_GREEK_CAPITAL_LETTER_UPSILON_WITH_DIALYTIKA            0x03ab
#define UC_GREEK_SMALL_LETTER_ALPHA_WITH_TONOS                    0x03ac
#define UC_GREEK_SMALL_LETTER_EPSILON_WITH_TONOS                  0x03ad
#define UC_GREEK_SMALL_LETTER_ETA_WITH_TONOS                      0x03ae
#define UC_GREEK_SMALL_LETTER_IOTA_WITH_TONOS                     0x03af
#define UC_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_TONOS    0x03b0
#define UC_GREEK_SMALL_LETTER_ALPHA                               0x03b1
#define UC_GREEK_SMALL_LETTER_BETA                                0x03b2
#define UC_GREEK_SMALL_LETTER_GAMMA                               0x03b3
#define UC_GREEK_SMALL_LETTER_DELTA                               0x03b4
#define UC_GREEK_SMALL_LETTER_EPSILON                             0x03b5
#define UC_GREEK_SMALL_LETTER_ZETA                                0x03b6
#define UC_GREEK_SMALL_LETTER_ETA                                 0x03b7
#define UC_GREEK_SMALL_LETTER_THETA                               0x03b8
#define UC_GREEK_SMALL_LETTER_IOTA                                0x03b9
#define UC_GREEK_SMALL_LETTER_KAPPA                               0x03ba
#define UC_GREEK_SMALL_LETTER_LAMDA                               0x03bb
#define UC_GREEK_SMALL_LETTER_MU                                  0x03bc
#define UC_GREEK_SMALL_LETTER_NU                                  0x03bd
#define UC_GREEK_SMALL_LETTER_XI                                  0x03be
#define UC_GREEK_SMALL_LETTER_OMICRON                             0x03bf
#define UC_GREEK_SMALL_LETTER_PI                                  0x03c0
#define UC_GREEK_SMALL_LETTER_RHO                                 0x03c1
#define UC_GREEK_SMALL_LETTER_FINAL_SIGMA                         0x03c2
#define UC_GREEK_SMALL_LETTER_SIGMA                               0x03c3
#define UC_GREEK_SMALL_LETTER_TAU                                 0x03c4
#define UC_GREEK_SMALL_LETTER_UPSILON                             0x03c5
#define UC_GREEK_SMALL_LETTER_PHI                                 0x03c6
#define UC_GREEK_SMALL_LETTER_CHI                                 0x03c7
#define UC_GREEK_SMALL_LETTER_PSI                                 0x03c8
#define UC_GREEK_SMALL_LETTER_OMEGA                               0x03c9
#define UC_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA                 0x03ca
#define UC_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA              0x03cb
#define UC_GREEK_SMALL_LETTER_OMICRON_WITH_TONOS                  0x03cc
#define UC_GREEK_SMALL_LETTER_UPSILON_WITH_TONOS                  0x03cd
#define UC_GREEK_SMALL_LETTER_OMEGA_WITH_TONOS                    0x03ce
#define UC_CYRILLIC_CAPITAL_LETTER_IO                             0x0401
#define UC_CYRILLIC_CAPITAL_LETTER_DJE                            0x0402
#define UC_CYRILLIC_CAPITAL_LETTER_GJE                            0x0403
#define UC_CYRILLIC_CAPITAL_LETTER_UKRAINIAN_IE                   0x0404
#define UC_CYRILLIC_CAPITAL_LETTER_DZE                            0x0405
#define UC_CYRILLIC_CAPITAL_LETTER_BYELORUSSIAN_UKRAINIAN_I       0x0406
#define UC_CYRILLIC_CAPITAL_LETTER_YI                             0x0407
#define UC_CYRILLIC_CAPITAL_LETTER_JE                             0x0408
#define UC_CYRILLIC_CAPITAL_LETTER_LJE                            0x0409
#define UC_CYRILLIC_CAPITAL_LETTER_NJE                            0x040a
#define UC_CYRILLIC_CAPITAL_LETTER_TSHE                           0x040b
#define UC_CYRILLIC_CAPITAL_LETTER_KJE                            0x040c
#define UC_CYRILLIC_CAPITAL_LETTER_SHORT_U                        0x040e
#define UC_CYRILLIC_CAPITAL_LETTER_DZHE                           0x040f
#define UC_CYRILLIC_CAPITAL_LETTER_A                              0x0410
#define UC_CYRILLIC_CAPITAL_LETTER_BE                             0x0411
#define UC_CYRILLIC_CAPITAL_LETTER_VE                             0x0412
#define UC_CYRILLIC_CAPITAL_LETTER_GHE                            0x0413
#define UC_CYRILLIC_CAPITAL_LETTER_DE                             0x0414
#define UC_CYRILLIC_CAPITAL_LETTER_IE                             0x0415
#define UC_CYRILLIC_CAPITAL_LETTER_ZHE                            0x0416
#define UC_CYRILLIC_CAPITAL_LETTER_ZE                             0x0417
#define UC_CYRILLIC_CAPITAL_LETTER_I                              0x0418
#define UC_CYRILLIC_CAPITAL_LETTER_SHORT_I                        0x0419
#define UC_CYRILLIC_CAPITAL_LETTER_KA                             0x041a
#define UC_CYRILLIC_CAPITAL_LETTER_EL                             0x041b
#define UC_CYRILLIC_CAPITAL_LETTER_EM                             0x041c
#define UC_CYRILLIC_CAPITAL_LETTER_EN                             0x041d
#define UC_CYRILLIC_CAPITAL_LETTER_O                              0x041e
#define UC_CYRILLIC_CAPITAL_LETTER_PE                             0x041f
#define UC_CYRILLIC_CAPITAL_LETTER_ER                             0x0420
#define UC_CYRILLIC_CAPITAL_LETTER_ES                             0x0421
#define UC_CYRILLIC_CAPITAL_LETTER_TE                             0x0422
#define UC_CYRILLIC_CAPITAL_LETTER_U                              0x0423
#define UC_CYRILLIC_CAPITAL_LETTER_EF                             0x0424
#define UC_CYRILLIC_CAPITAL_LETTER_HA                             0x0425
#define UC_CYRILLIC_CAPITAL_LETTER_TSE                            0x0426
#define UC_CYRILLIC_CAPITAL_LETTER_CHE                            0x0427
#define UC_CYRILLIC_CAPITAL_LETTER_SHA                            0x0428
#define UC_CYRILLIC_CAPITAL_LETTER_SHCHA                          0x0429
#define UC_CYRILLIC_CAPITAL_LETTER_HARD_SIGN                      0x042a
#define UC_CYRILLIC_CAPITAL_LETTER_YERU                           0x042b
#define UC_CYRILLIC_CAPITAL_LETTER_SOFT_SIGN                      0x042c
#define UC_CYRILLIC_CAPITAL_LETTER_E                              0x042d
#define UC_CYRILLIC_CAPITAL_LETTER_YU                             0x042e
#define UC_CYRILLIC_CAPITAL_LETTER_YA                             0x042f
#define UC_CYRILLIC_SMALL_LETTER_A                                0x0430
#define UC_CYRILLIC_SMALL_LETTER_BE                               0x0431
#define UC_CYRILLIC_SMALL_LETTER_VE                               0x0432
#define UC_CYRILLIC_SMALL_LETTER_GHE                              0x0433
#define UC_CYRILLIC_SMALL_LETTER_DE                               0x0434
#define UC_CYRILLIC_SMALL_LETTER_IE                               0x0435
#define UC_CYRILLIC_SMALL_LETTER_ZHE                              0x0436
#define UC_CYRILLIC_SMALL_LETTER_ZE                               0x0437
#define UC_CYRILLIC_SMALL_LETTER_I                                0x0438
#define UC_CYRILLIC_SMALL_LETTER_SHORT_I                          0x0439
#define UC_CYRILLIC_SMALL_LETTER_KA                               0x043a
#define UC_CYRILLIC_SMALL_LETTER_EL                               0x043b
#define UC_CYRILLIC_SMALL_LETTER_EM                               0x043c
#define UC_CYRILLIC_SMALL_LETTER_EN                               0x043d
#define UC_CYRILLIC_SMALL_LETTER_O                                0x043e
#define UC_CYRILLIC_SMALL_LETTER_PE                               0x043f
#define UC_CYRILLIC_SMALL_LETTER_ER                               0x0440
#define UC_CYRILLIC_SMALL_LETTER_ES                               0x0441
#define UC_CYRILLIC_SMALL_LETTER_TE                               0x0442
#define UC_CYRILLIC_SMALL_LETTER_U                                0x0443
#define UC_CYRILLIC_SMALL_LETTER_EF                               0x0444
#define UC_CYRILLIC_SMALL_LETTER_HA                               0x0445
#define UC_CYRILLIC_SMALL_LETTER_TSE                              0x0446
#define UC_CYRILLIC_SMALL_LETTER_CHE                              0x0447
#define UC_CYRILLIC_SMALL_LETTER_SHA                              0x0448
#define UC_CYRILLIC_SMALL_LETTER_SHCHA                            0x0449
#define UC_CYRILLIC_SMALL_LETTER_HARD_SIGN                        0x044a
#define UC_CYRILLIC_SMALL_LETTER_YERU                             0x044b
#define UC_CYRILLIC_SMALL_LETTER_SOFT_SIGN                        0x044c
#define UC_CYRILLIC_SMALL_LETTER_E                                0x044d
#define UC_CYRILLIC_SMALL_LETTER_YU                               0x044e
#define UC_CYRILLIC_SMALL_LETTER_YA                               0x044f
#define UC_CYRILLIC_SMALL_LETTER_IO                               0x0451
#define UC_CYRILLIC_SMALL_LETTER_DJE                              0x0452
#define UC_CYRILLIC_SMALL_LETTER_GJE                              0x0453
#define UC_CYRILLIC_SMALL_LETTER_UKRAINIAN_IE                     0x0454
#define UC_CYRILLIC_SMALL_LETTER_DZE                              0x0455
#define UC_CYRILLIC_SMALL_LETTER_BYELORUSSIAN_UKRAINIAN_I         0x0456
#define UC_CYRILLIC_SMALL_LETTER_YI                               0x0457
#define UC_CYRILLIC_SMALL_LETTER_JE                               0x0458
#define UC_CYRILLIC_SMALL_LETTER_LJE                              0x0459
#define UC_CYRILLIC_SMALL_LETTER_NJE                              0x045a
#define UC_CYRILLIC_SMALL_LETTER_TSHE                             0x045b
#define UC_CYRILLIC_SMALL_LETTER_KJE                              0x045c
#define UC_CYRILLIC_SMALL_LETTER_SHORT_U                          0x045e
#define UC_CYRILLIC_SMALL_LETTER_DZHE                             0x045f
#define UC_HEBREW_LETTER_ALEF                                     0x05d0
#define UC_HEBREW_LETTER_BET                                      0x05d1
#define UC_HEBREW_LETTER_GIMEL                                    0x05d2
#define UC_HEBREW_LETTER_DALET                                    0x05d3
#define UC_HEBREW_LETTER_HE                                       0x05d4
#define UC_HEBREW_LETTER_VAV                                      0x05d5
#define UC_HEBREW_LETTER_ZAYIN                                    0x05d6
#define UC_HEBREW_LETTER_HET                                      0x05d7
#define UC_HEBREW_LETTER_TET                                      0x05d8
#define UC_HEBREW_LETTER_YOD                                      0x05d9
#define UC_HEBREW_LETTER_FINAL_KAF                                0x05da
#define UC_HEBREW_LETTER_KAF                                      0x05db
#define UC_HEBREW_LETTER_LAMED                                    0x05dc
#define UC_HEBREW_LETTER_FINAL_MEM                                0x05dd
#define UC_HEBREW_LETTER_MEM                                      0x05de
#define UC_HEBREW_LETTER_FINAL_NUN                                0x05df
#define UC_HEBREW_LETTER_NUN                                      0x05e0
#define UC_HEBREW_LETTER_SAMEKH                                   0x05e1
#define UC_HEBREW_LETTER_AYIN                                     0x05e2
#define UC_HEBREW_LETTER_FINAL_PE                                 0x05e3
#define UC_HEBREW_LETTER_PE                                       0x05e4
#define UC_HEBREW_LETTER_FINAL_TSADI                              0x05e5
#define UC_HEBREW_LETTER_TSADI                                    0x05e6
#define UC_HEBREW_LETTER_QOF                                      0x05e7
#define UC_HEBREW_LETTER_RESH                                     0x05e8
#define UC_HEBREW_LETTER_SHIN                                     0x05e9
#define UC_HEBREW_LETTER_TAV                                      0x05ea
#define UC_ARABIC_COMMA                                           0x060c
#define UC_ARABIC_SEMICOLON                                       0x061b
#define UC_ARABIC_QUESTION_MARK                                   0x061f
#define UC_ARABIC_LETTER_HAMZA                                    0x0621
#define UC_ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE                    0x0622
#define UC_ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE                    0x0623
#define UC_ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE                     0x0624
#define UC_ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW                    0x0625
#define UC_ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE                     0x0626
#define UC_ARABIC_LETTER_ALEF                                     0x0627
#define UC_ARABIC_LETTER_BEH                                      0x0628
#define UC_ARABIC_LETTER_TEH_MARBUTA                              0x0629
#define UC_ARABIC_LETTER_TEH                                      0x062a
#define UC_ARABIC_LETTER_THEH                                     0x062b
#define UC_ARABIC_LETTER_JEEM                                     0x062c
#define UC_ARABIC_LETTER_HAH                                      0x062d
#define UC_ARABIC_LETTER_KHAH                                     0x062e
#define UC_ARABIC_LETTER_DAL                                      0x062f
#define UC_ARABIC_LETTER_THAL                                     0x0630
#define UC_ARABIC_LETTER_REH                                      0x0631
#define UC_ARABIC_LETTER_ZAIN                                     0x0632
#define UC_ARABIC_LETTER_SEEN                                     0x0633
#define UC_ARABIC_LETTER_SHEEN                                    0x0634
#define UC_ARABIC_LETTER_SAD                                      0x0635
#define UC_ARABIC_LETTER_DAD                                      0x0636
#define UC_ARABIC_LETTER_TAH                                      0x0637
#define UC_ARABIC_LETTER_ZAH                                      0x0638
#define UC_ARABIC_LETTER_AIN                                      0x0639
#define UC_ARABIC_LETTER_GHAIN                                    0x063a
#define UC_ARABIC_TATWEEL                                         0x0640
#define UC_ARABIC_LETTER_FEH                                      0x0641
#define UC_ARABIC_LETTER_QAF                                      0x0642
#define UC_ARABIC_LETTER_KAF                                      0x0643
#define UC_ARABIC_LETTER_LAM                                      0x0644
#define UC_ARABIC_LETTER_MEEM                                     0x0645
#define UC_ARABIC_LETTER_NOON                                     0x0646
#define UC_ARABIC_LETTER_HEH                                      0x0647
#define UC_ARABIC_LETTER_WAW                                      0x0648
#define UC_ARABIC_LETTER_ALEF_MAKSURA                             0x0649
#define UC_ARABIC_LETTER_YEH                                      0x064a
#define UC_ARABIC_FATHATAN                                        0x064b
#define UC_ARABIC_DAMMATAN                                        0x064c
#define UC_ARABIC_KASRATAN                                        0x064d
#define UC_ARABIC_FATHA                                           0x064e
#define UC_ARABIC_DAMMA                                           0x064f
#define UC_ARABIC_KASRA                                           0x0650
#define UC_ARABIC_SHADDA                                          0x0651
#define UC_ARABIC_SUKUN                                           0x0652
#define UC_ARABIC_DECIMAL_SEPARATOR                               0x066B
#define UC_LATIN_CAPITAL_LETTER_A_WITH_RING_BELOW                 0x1E00
#define UC_LATIN_SMALL_LETTER_A_WITH_RING_BELOW                   0x1E01
#define UC_LATIN_CAPITAL_LETTER_B_WITH_DOT_ABOVE                  0x1E02
#define UC_LATIN_SMALL_LETTER_B_WITH_DOT_ABOVE                    0x1E03
#define UC_LATIN_CAPITAL_LETTER_B_WITH_DOT_BELOW                  0x1E04
#define UC_LATIN_SMALL_LETTER_B_WITH_DOT_BELOW                    0x1E05
#define UC_LATIN_CAPITAL_LETTER_B_WITH_LINE_BELOW                 0x1E06
#define UC_LATIN_SMALL_LETTER_B_WITH_LINE_BELOW                   0x1E07
#define UC_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA_AND_ACUTE          0x1E08
#define UC_LATIN_SMALL_LETTER_C_WITH_CEDILLA_AND_ACUTE            0x1E09
#define UC_LATIN_CAPITAL_LETTER_D_WITH_DOT_ABOVE                  0x1E0A
#define UC_LATIN_SMALL_LETTER_D_WITH_DOT_ABOVE                    0x1E0B
#define UC_LATIN_CAPITAL_LETTER_D_WITH_DOT_BELOW                  0x1E0C
#define UC_LATIN_SMALL_LETTER_D_WITH_DOT_BELOW                    0x1E0D
#define UC_LATIN_CAPITAL_LETTER_D_WITH_LINE_BELOW                 0x1E0E
#define UC_LATIN_SMALL_LETTER_D_WITH_LINE_BELOW                   0x1E0F
#define UC_LATIN_CAPITAL_LETTER_D_WITH_CEDILLA                    0x1E10
#define UC_LATIN_SMALL_LETTER_D_WITH_CEDILLA                      0x1E11
#define UC_LATIN_CAPITAL_LETTER_D_WITH_CIRCUMFLEX_BELOW           0x1E12
#define UC_LATIN_SMALL_LETTER_D_WITH_CIRCUMFLEX_BELOW             0x1E13
#define UC_LATIN_CAPITAL_LETTER_E_WITH_MACRON_AND_GRAVE           0x1E14
#define UC_LATIN_SMALL_LETTER_E_WITH_MACRON_AND_GRAVE             0x1E15
#define UC_LATIN_CAPITAL_LETTER_E_WITH_MACRON_AND_ACUTE           0x1E16
#define UC_LATIN_SMALL_LETTER_E_WITH_MACRON_AND_ACUTE             0x1E17
#define UC_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_BELOW           0x1E18
#define UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_BELOW             0x1E19
#define UC_LATIN_CAPITAL_LETTER_E_WITH_TILDE_BELOW                0x1E1A
#define UC_LATIN_SMALL_LETTER_E_WITH_TILDE_BELOW                  0x1E1B
#define UC_LATIN_CAPITAL_LETTER_E_WITH_CEDILLA_AND_BREVE          0x1E1C
#define UC_LATIN_SMALL_LETTER_E_WITH_CEDILLA_AND_BREVE            0x1E1D
#define UC_LATIN_CAPITAL_LETTER_F_WITH_DOT_ABOVE                  0x1E1E
#define UC_LATIN_SMALL_LETTER_F_WITH_DOT_ABOVE                    0x1E1F
#define UC_LATIN_CAPITAL_LETTER_G_WITH_MACRON                     0x1E20
#define UC_LATIN_SMALL_LETTER_G_WITH_MACRON                       0x1E21
#define UC_LATIN_CAPITAL_LETTER_H_WITH_DOT_ABOVE                  0x1E22
#define UC_LATIN_SMALL_LETTER_H_WITH_DOT_ABOVE                    0x1E23
#define UC_LATIN_CAPITAL_LETTER_H_WITH_DOT_BELOW                  0x1E24
#define UC_LATIN_SMALL_LETTER_H_WITH_DOT_BELOW                    0x1E25
#define UC_LATIN_CAPITAL_LETTER_H_WITH_DIAERESIS                  0x1E26
#define UC_LATIN_SMALL_LETTER_H_WITH_DIAERESIS                    0x1E27
#define UC_LATIN_CAPITAL_LETTER_H_WITH_CEDILLA                    0x1E28
#define UC_LATIN_SMALL_LETTER_H_WITH_CEDILLA                      0x1E29
#define UC_LATIN_CAPITAL_LETTER_H_WITH_BREVE_BELOW                0x1E2A
#define UC_LATIN_SMALL_LETTER_H_WITH_BREVE_BELOW                  0x1E2B
#define UC_LATIN_CAPITAL_LETTER_I_WITH_TILDE_BELOW                0x1E2C
#define UC_LATIN_SMALL_LETTER_I_WITH_TILDE_BELOW                  0x1E2D
#define UC_LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS_AND_ACUTE        0x1E2E
#define UC_LATIN_SMALL_LETTER_I_WITH_DIAERESIS_AND_ACUTE          0x1E2F
#define UC_LATIN_CAPITAL_LETTER_K_WITH_ACUTE                      0x1E30
#define UC_LATIN_SMALL_LETTER_K_WITH_ACUTE                        0x1E31
#define UC_LATIN_CAPITAL_LETTER_K_WITH_DOT_BELOW                  0x1E32
#define UC_LATIN_SMALL_LETTER_K_WITH_DOT_BELOW                    0x1E33
#define UC_LATIN_CAPITAL_LETTER_K_WITH_LINE_BELOW                 0x1E34
#define UC_LATIN_SMALL_LETTER_K_WITH_LINE_BELOW                   0x1E35
#define UC_LATIN_CAPITAL_LETTER_L_WITH_DOT_BELOW                  0x1E36
#define UC_LATIN_SMALL_LETTER_L_WITH_DOT_BELOW                    0x1E37
#define UC_LATIN_CAPITAL_LETTER_L_WITH_DOT_BELOW_AND_MACRON       0x1E38
#define UC_LATIN_SMALL_LETTER_L_WITH_DOT_BELOW_AND_MACRON         0x1E39
#define UC_LATIN_CAPITAL_LETTER_L_WITH_LINE_BELOW                 0x1E3A
#define UC_LATIN_SMALL_LETTER_L_WITH_LINE_BELOW                   0x1E3B
#define UC_LATIN_CAPITAL_LETTER_L_WITH_CIRCUMFLEX_BELOW           0x1E3C
#define UC_LATIN_SMALL_LETTER_L_WITH_CIRCUMFLEX_BELOW             0x1E3D
#define UC_LATIN_CAPITAL_LETTER_M_WITH_ACUTE                      0x1E3E
#define UC_LATIN_SMALL_LETTER_M_WITH_ACUTE                        0x1E3F
#define UC_LATIN_CAPITAL_LETTER_M_WITH_DOT_ABOVE                  0x1E40
#define UC_LATIN_SMALL_LETTER_M_WITH_DOT_ABOVE                    0x1E41
#define UC_LATIN_CAPITAL_LETTER_M_WITH_DOT_BELOW                  0x1E42
#define UC_LATIN_SMALL_LETTER_M_WITH_DOT_BELOW                    0x1E43
#define UC_LATIN_CAPITAL_LETTER_N_WITH_DOT_ABOVE                  0x1E44
#define UC_LATIN_SMALL_LETTER_N_WITH_DOT_ABOVE                    0x1E45
#define UC_LATIN_CAPITAL_LETTER_N_WITH_DOT_BELOW                  0x1E46
#define UC_LATIN_SMALL_LETTER_N_WITH_DOT_BELOW                    0x1E47
#define UC_LATIN_CAPITAL_LETTER_N_WITH_LINE_BELOW                 0x1E48
#define UC_LATIN_SMALL_LETTER_N_WITH_LINE_BELOW                   0x1E49
#define UC_LATIN_CAPITAL_LETTER_N_WITH_CIRCUMFLEX_BELOW           0x1E4A
#define UC_LATIN_SMALL_LETTER_N_WITH_CIRCUMFLEX_BELOW             0x1E4B
#define UC_LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_ACUTE            0x1E4C
#define UC_LATIN_SMALL_LETTER_O_WITH_TILDE_AND_ACUTE              0x1E4D
#define UC_LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_DIAERESIS        0x1E4E
#define UC_LATIN_SMALL_LETTER_O_WITH_TILDE_AND_DIAERESIS          0x1E4F
#define UC_LATIN_CAPITAL_LETTER_O_WITH_MACRON_AND_GRAVE           0x1E50
#define UC_LATIN_SMALL_LETTER_O_WITH_MACRON_AND_GRAVE             0x1E51
#define UC_LATIN_CAPITAL_LETTER_O_WITH_MACRON_AND_ACUTE           0x1E52
#define UC_LATIN_SMALL_LETTER_O_WITH_MACRON_AND_ACUTE             0x1E53
#define UC_LATIN_CAPITAL_LETTER_P_WITH_ACUTE                      0x1E54
#define UC_LATIN_SMALL_LETTER_P_WITH_ACUTE                        0x1E55
#define UC_LATIN_CAPITAL_LETTER_P_WITH_DOT_ABOVE                  0x1E56
#define UC_LATIN_SMALL_LETTER_P_WITH_DOT_ABOVE                    0x1E57
#define UC_LATIN_CAPITAL_LETTER_R_WITH_DOT_ABOVE                  0x1E58
#define UC_LATIN_SMALL_LETTER_R_WITH_DOT_ABOVE                    0x1E59
#define UC_LATIN_CAPITAL_LETTER_R_WITH_DOT_BELOW                  0x1E5A
#define UC_LATIN_SMALL_LETTER_R_WITH_DOT_BELOW                    0x1E5B
#define UC_LATIN_CAPITAL_LETTER_R_WITH_DOT_BELOW_AND_MACRON       0x1E5C
#define UC_LATIN_SMALL_LETTER_R_WITH_DOT_BELOW_AND_MACRON         0x1E5D
#define UC_LATIN_CAPITAL_LETTER_R_WITH_LINE_BELOW                 0x1E5E
#define UC_LATIN_SMALL_LETTER_R_WITH_LINE_BELOW                   0x1E5F
#define UC_LATIN_CAPITAL_LETTER_S_WITH_DOT_ABOVE                  0x1E60
#define UC_LATIN_SMALL_LETTER_S_WITH_DOT_ABOVE                    0x1E61
#define UC_LATIN_CAPITAL_LETTER_S_WITH_DOT_BELOW                  0x1E62
#define UC_LATIN_SMALL_LETTER_S_WITH_DOT_BELOW                    0x1E63
#define UC_LATIN_CAPITAL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE        0x1E64
#define UC_LATIN_SMALL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE          0x1E65
#define UC_LATIN_CAPITAL_LETTER_S_WITH_CARON_AND_DOT_ABOVE        0x1E66
#define UC_LATIN_SMALL_LETTER_S_WITH_CARON_AND_DOT_ABOVE          0x1E67
#define UC_LATIN_CAPITAL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE    0x1E68
#define UC_LATIN_SMALL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE      0x1E69
#define UC_LATIN_CAPITAL_LETTER_T_WITH_DOT_ABOVE                  0x1E6A
#define UC_LATIN_SMALL_LETTER_T_WITH_DOT_ABOVE                    0x1E6B
#define UC_LATIN_CAPITAL_LETTER_T_WITH_DOT_BELOW                  0x1E6C
#define UC_LATIN_SMALL_LETTER_T_WITH_DOT_BELOW                    0x1E6D
#define UC_LATIN_CAPITAL_LETTER_T_WITH_LINE_BELOW                 0x1E6E
#define UC_LATIN_SMALL_LETTER_T_WITH_LINE_BELOW                   0x1E6F
#define UC_LATIN_CAPITAL_LETTER_T_WITH_CIRCUMFLEX_BELOW           0x1E70
#define UC_LATIN_SMALL_LETTER_T_WITH_CIRCUMFLEX_BELOW             0x1E71
#define UC_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_BELOW            0x1E72
#define UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS_BELOW              0x1E73
#define UC_LATIN_CAPITAL_LETTER_U_WITH_TILDE_BELOW                0x1E74
#define UC_LATIN_SMALL_LETTER_U_WITH_TILDE_BELOW                  0x1E75
#define UC_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX_BELOW           0x1E76
#define UC_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX_BELOW             0x1E77
#define UC_LATIN_CAPITAL_LETTER_U_WITH_TILDE_AND_ACUTE            0x1E78
#define UC_LATIN_SMALL_LETTER_U_WITH_TILDE_AND_ACUTE              0x1E79
#define UC_LATIN_CAPITAL_LETTER_U_WITH_MACRON_AND_DIAERESIS       0x1E7A
#define UC_LATIN_SMALL_LETTER_U_WITH_MACRON_AND_DIAERESIS         0x1E7B
#define UC_LATIN_CAPITAL_LETTER_V_WITH_TILDE                      0x1E7C
#define UC_LATIN_SMALL_LETTER_V_WITH_TILDE                        0x1E7D
#define UC_LATIN_CAPITAL_LETTER_V_WITH_DOT_BELOW                  0x1E7E
#define UC_LATIN_SMALL_LETTER_V_WITH_DOT_BELOW                    0x1E7F
#define UC_LATIN_CAPITAL_LETTER_W_WITH_GRAVE                      0x1E80
#define UC_LATIN_SMALL_LETTER_W_WITH_GRAVE                        0x1E81
#define UC_LATIN_CAPITAL_LETTER_W_WITH_ACUTE                      0x1E82
#define UC_LATIN_SMALL_LETTER_W_WITH_ACUTE                        0x1E83
#define UC_LATIN_CAPITAL_LETTER_W_WITH_DIAERESIS                  0x1E84
#define UC_LATIN_SMALL_LETTER_W_WITH_DIAERESIS                    0x1E85
#define UC_LATIN_CAPITAL_LETTER_W_WITH_DOT_ABOVE                  0x1E86
#define UC_LATIN_SMALL_LETTER_W_WITH_DOT_ABOVE                    0x1E87
#define UC_LATIN_CAPITAL_LETTER_W_WITH_DOT_BELOW                  0x1E88
#define UC_LATIN_SMALL_LETTER_W_WITH_DOT_BELOW                    0x1E89
#define UC_LATIN_CAPITAL_LETTER_X_WITH_DOT_ABOVE                  0x1E8A
#define UC_LATIN_SMALL_LETTER_X_WITH_DOT_ABOVE                    0x1E8B
#define UC_LATIN_CAPITAL_LETTER_X_WITH_DIAERESIS                  0x1E8C
#define UC_LATIN_SMALL_LETTER_X_WITH_DIAERESIS                    0x1E8D
#define UC_LATIN_CAPITAL_LETTER_Y_WITH_DOT_ABOVE                  0x1E8E
#define UC_LATIN_SMALL_LETTER_Y_WITH_DOT_ABOVE                    0x1E8F
#define UC_LATIN_CAPITAL_LETTER_Z_WITH_CIRCUMFLEX                 0x1E90
#define UC_LATIN_SMALL_LETTER_Z_WITH_CIRCUMFLEX                   0x1E91
#define UC_LATIN_CAPITAL_LETTER_Z_WITH_DOT_BELOW                  0x1E92
#define UC_LATIN_SMALL_LETTER_Z_WITH_DOT_BELOW                    0x1E93
#define UC_LATIN_CAPITAL_LETTER_Z_WITH_LINE_BELOW                 0x1E94
#define UC_LATIN_SMALL_LETTER_Z_WITH_LINE_BELOW                   0x1E95
#define UC_LATIN_SMALL_LETTER_H_WITH_LINE_BELOW                   0x1E96
#define UC_LATIN_SMALL_LETTER_T_WITH_DIAERESIS                    0x1E97
#define UC_LATIN_SMALL_LETTER_W_WITH_RING_ABOVE                   0x1E98
#define UC_LATIN_SMALL_LETTER_Y_WITH_RING_ABOVE                   0x1E99
#define UC_LATIN_SMALL_LETTER_A_WITH_RIGHT_HALF_RING              0x1E9A
#define UC_LATIN_SMALL_LETTER_LONG_S_WITH_DOT_ABOVE               0x1E9B
#define UC_LATIN_SMALL_LETTER_LONG_S_WITH_DIAGONAL_STROKE         0x1E9C
#define UC_LATIN_SMALL_LETTER_LONG_S_WITH_HIGH_STROKE             0x1E9D
#define UC_LATIN_CAPITAL_LETTER_SHARP_S                           0x1E9E
#define UC_LATIN_SMALL_LETTER_DELTA                               0x1E9F
#define UC_LATIN_CAPITAL_LETTER_A_WITH_DOT_BELOW                  0x1EA0
#define UC_LATIN_SMALL_LETTER_A_WITH_DOT_BELOW                    0x1EA1
#define UC_LATIN_CAPITAL_LETTER_A_WITH_HOOK_ABOVE                 0x1EA2
#define UC_LATIN_SMALL_LETTER_A_WITH_HOOK_ABOVE                   0x1EA3
#define UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE       0x1EA4
#define UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE         0x1EA5
#define UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE       0x1EA6
#define UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE         0x1EA7
#define UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE  0x1EA8
#define UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE    0x1EA9
#define UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE       0x1EAA
#define UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE         0x1EAB
#define UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW   0x1EAC
#define UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW     0x1EAD
#define UC_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_ACUTE            0x1EAE
#define UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_ACUTE              0x1EAF
#define UC_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_GRAVE            0x1EB0
#define UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_GRAVE              0x1EB1
#define UC_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE       0x1EB2
#define UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE         0x1EB3
#define UC_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_TILDE            0x1EB4
#define UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_TILDE              0x1EB5
#define UC_LATIN_CAPITAL_LETTER_A_WITH_BREVE_AND_DOT_BELOW        0x1EB6
#define UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_DOT_BELOW          0x1EB7
#define UC_LATIN_CAPITAL_LETTER_E_WITH_DOT_BELOW                  0x1EB8
#define UC_LATIN_SMALL_LETTER_E_WITH_DOT_BELOW                    0x1EB9
#define UC_LATIN_CAPITAL_LETTER_E_WITH_HOOK_ABOVE                 0x1EBA
#define UC_LATIN_SMALL_LETTER_E_WITH_HOOK_ABOVE                   0x1EBB
#define UC_LATIN_CAPITAL_LETTER_E_WITH_TILDE                      0x1EBC
#define UC_LATIN_SMALL_LETTER_E_WITH_TILDE                        0x1EBD
#define UC_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE       0x1EBE
#define UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE         0x1EBF
#define UC_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE       0x1EC0
#define UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE         0x1EC1
#define UC_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE  0x1EC2
#define UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE    0x1EC3
#define UC_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE       0x1EC4
#define UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE         0x1EC5
#define UC_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW   0x1EC6
#define UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW     0x1EC7
#define UC_LATIN_CAPITAL_LETTER_I_WITH_HOOK_ABOVE                 0x1EC8
#define UC_LATIN_SMALL_LETTER_I_WITH_HOOK_ABOVE                   0x1EC9
#define UC_LATIN_CAPITAL_LETTER_I_WITH_DOT_BELOW                  0x1ECA
#define UC_LATIN_SMALL_LETTER_I_WITH_DOT_BELOW                    0x1ECB
#define UC_LATIN_CAPITAL_LETTER_O_WITH_DOT_BELOW                  0x1ECC
#define UC_LATIN_SMALL_LETTER_O_WITH_DOT_BELOW                    0x1ECD
#define UC_LATIN_CAPITAL_LETTER_O_WITH_HOOK_ABOVE                 0x1ECE
#define UC_LATIN_SMALL_LETTER_O_WITH_HOOK_ABOVE                   0x1ECF
#define UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE       0x1ED0
#define UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE         0x1ED1
#define UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE       0x1ED2
#define UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE         0x1ED3
#define UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE  0x1ED4
#define UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE    0x1ED5
#define UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE       0x1ED6
#define UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE         0x1ED7
#define UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW   0x1ED8
#define UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW     0x1ED9
#define UC_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_ACUTE             0x1EDA
#define UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_ACUTE               0x1EDB
#define UC_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_GRAVE             0x1EDC
#define UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_GRAVE               0x1EDD
#define UC_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE        0x1EDE
#define UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE          0x1EDF
#define UC_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_TILDE             0x1EE0
#define UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_TILDE               0x1EE1
#define UC_LATIN_CAPITAL_LETTER_O_WITH_HORN_AND_DOT_BELOW         0x1EE2
#define UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_DOT_BELOW           0x1EE3
#define UC_LATIN_CAPITAL_LETTER_U_WITH_DOT_BELOW                  0x1EE4
#define UC_LATIN_SMALL_LETTER_U_WITH_DOT_BELOW                    0x1EE5
#define UC_LATIN_CAPITAL_LETTER_U_WITH_HOOK_ABOVE                 0x1EE6
#define UC_LATIN_SMALL_LETTER_U_WITH_HOOK_ABOVE                   0x1EE7
#define UC_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_ACUTE             0x1EE8
#define UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_ACUTE               0x1EE9
#define UC_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_GRAVE             0x1EEA
#define UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_GRAVE               0x1EEB
#define UC_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE        0x1EEC
#define UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE          0x1EED
#define UC_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_TILDE             0x1EEE
#define UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_TILDE               0x1EEF
#define UC_LATIN_CAPITAL_LETTER_U_WITH_HORN_AND_DOT_BELOW         0x1EF0
#define UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_DOT_BELOW           0x1EF1
#define UC_LATIN_CAPITAL_LETTER_Y_WITH_GRAVE                      0x1EF2
#define UC_LATIN_SMALL_LETTER_Y_WITH_GRAVE                        0x1EF3
#define UC_LATIN_CAPITAL_LETTER_Y_WITH_DOT_BELOW                  0x1EF4
#define UC_LATIN_SMALL_LETTER_Y_WITH_DOT_BELOW                    0x1EF5
#define UC_LATIN_CAPITAL_LETTER_Y_WITH_HOOK_ABOVE                 0x1EF6
#define UC_LATIN_SMALL_LETTER_Y_WITH_HOOK_ABOVE                   0x1EF7
#define UC_LATIN_CAPITAL_LETTER_Y_WITH_TILDE                      0x1EF8
#define UC_LATIN_SMALL_LETTER_Y_WITH_TILDE                        0x1EF9
#define UC_LATIN_CAPITAL_LETTER_MIDDLE_WELSH_LL                   0x1EFA
#define UC_LATIN_SMALL_LETTER_MIDDLE_WELSH_LL                     0x1EFB
#define UC_LATIN_CAPITAL_LETTER_MIDDLE_WELSH_V                    0x1EFC
#define UC_LATIN_SMALL_LETTER_MIDDLE_WELSH_V                      0x1EFD
#define UC_LATIN_CAPITAL_LETTER_Y_WITH_LOOP                       0x1EFE
#define UC_LATIN_SMALL_LETTER_Y_WITH_LOOP                         0x1EFF
#define UC_EM_DASH                                                0x2014
#define UC_HORIZONTAL_BAR                                         0x2015
#define UC_DOUBLE_LOW_LINE                                        0x2017
#define UC_LEFT_SINGLE_QUOTATION_MARK                             0x2018
#define UC_RIGHT_SINGLE_QUOTATION_MARK                            0x2019
#define UC_LEFT_DOUBLE_QUOTATION_MARK                             0x201c
#define UC_RIGHT_DOUBLE_QUOTATION_MARK                            0x201d
#define UC_DOUBLE_LOW_9_QUOTATION_MARK                            0x201e
#define UC_EURO_SIGN                                              0x20ac
#define UC_NUMERO_SIGN                                            0x2116
#define UC_TRADEMARK_SIGN                                         0x2122
#define UC_OHM_SIGN                                               0x2126
#define UC_VULGAR_FRACTION_ONE_EIGHTH                             0x215b
#define UC_VULGAR_FRACTION_THREE_EIGHTHS                          0x215c
#define UC_VULGAR_FRACTION_FIVE_EIGHTHS                           0x215d
#define UC_VULGAR_FRACTION_SEVEN_EIGHTHS                          0x215e
#define UC_LEFTWARDS_ARROW                                        0x2190
#define UC_UPWARDS_ARROW                                          0x2191
#define UC_RIGHTWARDS_ARROW                                       0x2192
#define UC_DOWNWARDS_ARROW                                        0x2193
#define UC_EIGHTH_NOTE                                            0x266a






//---typedefs-structs-enumerations------------------------------------------------------------------

static const U16BIT char_map[MAX_CHAR_MAP_TABLES][96] =
{
   {
      // table 0 = DVB default table from ISO/IEC 6937
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      UC_INVERTED_EXCLAMATION_MARK,
      UC_CENT_SIGN,
      UC_POUND_SIGN,
      UC_EURO_SIGN,
      UC_YEN_SIGN,
      NULL_CHAR,
      UC_SECTION_SIGN,
      UC_CURRENCY_SIGN,
      UC_LEFT_SINGLE_QUOTATION_MARK,
      UC_LEFT_DOUBLE_QUOTATION_MARK,
      UC_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_LEFTWARDS_ARROW,
      UC_UPWARDS_ARROW,
      UC_RIGHTWARDS_ARROW,
      UC_DOWNWARDS_ARROW,
      // ascii 0xB0 ----------------------------------
      UC_DEGREE_SIGN,
      UC_PLUS_MINUS_SIGN,
      UC_SUPERSCRIPT_TWO,
      UC_SUPERSCRIPT_THREE,
      UC_MULTIPLICATION_SIGN,
      UC_MICRO_SIGN,
      UC_PILCROW_SIGN,
      UC_MIDDLE_DOT,
      UC_DIVISION_SIGN,
      UC_RIGHT_SINGLE_QUOTATION_MARK,
      UC_RIGHT_DOUBLE_QUOTATION_MARK,
      UC_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_VULGAR_FRACTION_ONE_QUARTER,
      UC_VULGAR_FRACTION_ONE_HALF,
      UC_VULGAR_FRACTION_THREE_QUARTERS,
      UC_INVERTED_QUESTION_MARK,
      // ascii 0xC0 ----------------------------------
      NULL_CHAR,
      UC_COMBINING_GRAVE_ACCENT,
      UC_COMBINING_ACUTE_ACCENT,
      UC_COMBINING_CIRCUMFLEX_ACCENT,
      UC_COMBINING_TILDE,
      UC_COMBINING_MACRON,
      UC_COMBINING_BREVE,
      UC_COMBINING_DOT_ABOVE,
      UC_COMBINING_DIAERESIS,
      NULL_CHAR,
      UC_COMBINING_RING_ABOVE,
      UC_COMBINING_CEDILLA,
      NULL_CHAR,
      UC_COMBINING_DOUBLE_ACUTE_ACCENT,
      UC_COMBINING_OGONEK,
      UC_COMBINING_CARON,
      // ascii 0xD0 ----------------------------------
      UC_HORIZONTAL_BAR,
      UC_SUPERSCRIPT_ONE,
      UC_REGISTERED_SIGN,
      UC_COPYRIGHT_SIGN,
      UC_TRADEMARK_SIGN,
      UC_EIGHTH_NOTE,
      UC_NOT_SIGN,
      UC_BROKEN_BAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      UC_VULGAR_FRACTION_ONE_EIGHTH,
      UC_VULGAR_FRACTION_THREE_EIGHTHS,
      UC_VULGAR_FRACTION_FIVE_EIGHTHS,
      UC_VULGAR_FRACTION_SEVEN_EIGHTHS,
      // ascii 0xE0 ----------------------------------
      UC_OHM_SIGN,
      UC_LATIN_CAPITAL_LIGATURE_AE,
      UC_LATIN_CAPITAL_LETTER_D_WITH_STROKE,
      UC_FEMININE_ORDINAL_INDICATOR,
      UC_LATIN_CAPITAL_LETTER_H_WITH_STROKE,
      NULL_CHAR,
      UC_LATIN_CAPITAL_LIGATURE_IJ,
      UC_LATIN_CAPITAL_LETTER_L_WITH_MIDDLE_DOT,
      UC_LATIN_CAPITAL_LETTER_L_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_STROKE,
      UC_LATIN_CAPITAL_LIGATURE_OE,
      UC_MASCULINE_ORDINAL_INDICATOR,
      UC_LATIN_CAPITAL_LETTER_THORN,
      UC_LATIN_CAPITAL_LETTER_T_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_ENG,
      UC_LATIN_SMALL_LETTER_N_PRECEDED_BY_APOSTROPHE,
      // ascii 0xF0 ----------------------------------
      UC_LATIN_SMALL_LETTER_KRA,
      UC_LATIN_SMALL_LIGATURE_AE,
      UC_LATIN_SMALL_LETTER_D_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_ETH,
      UC_LATIN_SMALL_LETTER_H_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_DOTLESS_I,
      UC_LATIN_SMALL_LIGATURE_IJ,
      UC_LATIN_SMALL_LETTER_L_WITH_MIDDLE_DOT,
      UC_LATIN_SMALL_LETTER_L_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_O_WITH_STROKE,
      UC_LATIN_SMALL_LIGATURE_OE,
      UC_LATIN_SMALL_LETTER_SHARP_S,
      UC_LATIN_SMALL_LETTER_THORN,
      UC_LATIN_SMALL_LETTER_T_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_ENG,
      UC_SOFT_HYPHEN
   },

   {
      // table 1 = iso 8859-1
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      UC_INVERTED_EXCLAMATION_MARK,
      UC_CENT_SIGN,
      UC_POUND_SIGN,
      UC_CURRENCY_SIGN,
      UC_YEN_SIGN,
      UC_BROKEN_BAR,
      UC_SECTION_SIGN,
      UC_DIAERESIS,
      UC_COPYRIGHT_SIGN,
      UC_FEMININE_ORDINAL_INDICATOR,
      UC_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_NOT_SIGN,
      UC_SOFT_HYPHEN,
      UC_REGISTERED_SIGN,
      UC_MACRON,
      // ascii 0xB0 ----------------------------------
      UC_DEGREE_SIGN,
      UC_PLUS_MINUS_SIGN,
      UC_SUPERSCRIPT_TWO,
      UC_SUPERSCRIPT_THREE,
      UC_ACUTE_ACCENT,
      UC_MICRO_SIGN,
      UC_PILCROW_SIGN,
      UC_MIDDLE_DOT,
      UC_CEDILLA,
      UC_SUPERSCRIPT_ONE,
      UC_MASCULINE_ORDINAL_INDICATOR,
      UC_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_VULGAR_FRACTION_ONE_QUARTER,
      UC_VULGAR_FRACTION_ONE_HALF,
      UC_VULGAR_FRACTION_THREE_QUARTERS,
      UC_INVERTED_QUESTION_MARK,
      // ascii 0xC0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_A_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_A_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_CAPITAL_LIGATURE_AE,
      UC_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_E_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_I_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS,
      // ascii 0xD0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_D_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_N_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_O_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS,
      UC_MULTIPLICATION_SIGN,
      UC_LATIN_CAPITAL_LETTER_O_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_Y_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_THORN,
      UC_GREEK_CAPITAL_LETTER_BETA,
      // ascii 0xE0 ----------------------------------
      UC_LATIN_SMALL_LETTER_A_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_A_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_A_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_SMALL_LIGATURE_AE,
      UC_LATIN_SMALL_LETTER_C_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_E_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_E_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_I_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_I_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_I_WITH_DIAERESIS,
      // ascii 0xF0 ----------------------------------
      UC_LATIN_SMALL_LETTER_ETH,
      UC_LATIN_SMALL_LETTER_N_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_O_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_O_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_O_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_O_WITH_DIAERESIS,
      UC_DIVISION_SIGN,
      UC_LATIN_SMALL_LETTER_O_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_U_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_U_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_Y_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_THORN,
      UC_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS
   },

   {
      // table 2 = iso 8859-2: "Latin Alphabet No 2"
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_OGONEK,
      UC_BREVE,
      UC_LATIN_CAPITAL_LETTER_L_WITH_STROKE,
      UC_CURRENCY_SIGN,
      UC_LATIN_CAPITAL_LETTER_L_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_S_WITH_ACUTE,
      UC_SECTION_SIGN,
      UC_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_S_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_S_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_T_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_Z_WITH_ACUTE,
      UC_SOFT_HYPHEN,
      UC_LATIN_CAPITAL_LETTER_Z_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_Z_WITH_DOT_ABOVE,
      // ascii 0xB0 ----------------------------------
      UC_DEGREE_SIGN,
      UC_LATIN_SMALL_LETTER_A_WITH_OGONEK,
      UC_OGONEK,
      UC_LATIN_SMALL_LETTER_L_WITH_STROKE,
      UC_ACUTE_ACCENT,
      UC_LATIN_SMALL_LETTER_L_WITH_CARON,
      UC_LATIN_SMALL_LETTER_S_WITH_ACUTE,
      UC_CARON,
      UC_CEDILLA,
      UC_LATIN_SMALL_LETTER_S_WITH_CARON,
      UC_LATIN_SMALL_LETTER_S_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_T_WITH_CARON,
      UC_LATIN_SMALL_LETTER_Z_WITH_ACUTE,
      UC_DOUBLE_ACUTE_ACCENT,
      UC_LATIN_SMALL_LETTER_Z_WITH_CARON,
      UC_LATIN_SMALL_LETTER_Z_WITH_DOT_ABOVE,
      // ascii 0xC0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_R_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_A_WITH_BRIEVE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_L_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_C_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_C_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_E_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_OGONEK,
      UC_LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_E_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_I_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_D_WITH_CARON,
      // ascii 0xD0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_D_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_N_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_N_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_O_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_ACUTE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS,
      UC_MULTIPLICATION_SIGN,
      UC_LATIN_CAPITAL_LETTER_R_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_U_WITH_RING_ABOVE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_ACUTE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_Y_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_T_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_SHARP_S,
      // ascii 0xE0 ----------------------------------
      UC_LATIN_SMALL_LETTER_R_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_A_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_A_WITH_BRIEVE,
      UC_LATIN_SMALL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_L_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_C_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_C_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_C_WITH_CARON,
      UC_LATIN_SMALL_LETTER_E_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_E_WITH_OGONEK,
      UC_LATIN_SMALL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_E_WITH_CARON,
      UC_LATIN_SMALL_LETTER_I_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_D_WITH_CARON,
      // ascii 0xF0 ----------------------------------
      UC_LATIN_SMALL_LETTER_D_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_N_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_N_WITH_CARON,
      UC_LATIN_SMALL_LETTER_O_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_O_WITH_DOUBLE_ACUTE,
      UC_LATIN_SMALL_LETTER_O_WITH_DIAERESIS,
      UC_DIVISION_SIGN,
      UC_LATIN_SMALL_LETTER_R_WITH_CARON,
      UC_LATIN_SMALL_LETTER_U_WITH_RING_ABOVE,
      UC_LATIN_SMALL_LETTER_U_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_U_WITH_DOUBLE_ACUTE,
      UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_Y_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_T_WITH_CEDILLA,
      UC_DOT_ABOVE
   },

   {
      // table 3 = iso 8859-3: "Latin Alphabet No 3"
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      UC_LATIN_CAPITAL_LETTER_H_WITH_STROKE,
      UC_BREVE,
      UC_POUND_SIGN,
      UC_CURRENCY_SIGN,
      NULL_CHAR,
      UC_LATIN_CAPITAL_LETTER_H_WITH_CIRCUMFLEX,
      UC_SECTION_SIGN,
      UC_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_I_WITH_DOT_ABOVE,
      UC_LATIN_CAPITAL_LETTER_S_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_G_WITH_BREVE,
      UC_LATIN_CAPITAL_LETTER_J_WITH_CIRCUMFLEX,
      UC_SOFT_HYPHEN,
      NULL_CHAR,
      UC_LATIN_CAPITAL_LETTER_Z_WITH_DOT_ABOVE,
      // ascii 0xB0 ----------------------------------
      UC_DEGREE_SIGN,
      UC_LATIN_SMALL_LETTER_H_WITH_STROKE,
      UC_SUPERSCRIPT_TWO,
      UC_SUPERSCRIPT_THREE,
      UC_ACUTE_ACCENT,
      UC_MICRO_SIGN,
      UC_LATIN_SMALL_LETTER_H_WITH_CIRCUMFLEX,
      UC_MIDDLE_DOT,
      UC_CEDILLA,
      UC_LATIN_SMALL_LETTER_DOTLESS_I,
      UC_LATIN_SMALL_LETTER_S_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_G_WITH_BREVE,
      UC_LATIN_SMALL_LETTER_J_WITH_CIRCUMFLEX,
      UC_VULGAR_FRACTION_ONE_HALF,
      NULL_CHAR,
      UC_LATIN_SMALL_LETTER_Z_WITH_DOT_ABOVE,
      // ascii 0xC0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_A_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX,
      NULL_CHAR,
      UC_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_C_WITH_DOT_ABOVE,
      UC_LATIN_CAPITAL_LETTER_C_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_E_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_I_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS,
      // ascii 0xD0 ----------------------------------
      NULL_CHAR,
      UC_LATIN_CAPITAL_LETTER_N_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_G_WITH_DOT_ABOVE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS,
      UC_MULTIPLICATION_SIGN,
      UC_LATIN_CAPITAL_LETTER_G_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_U_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_U_WITH_BREVE,
      UC_LATIN_CAPITAL_LETTER_S_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_SHARP_S,
      // ascii 0xE0 ----------------------------------
      UC_LATIN_SMALL_LETTER_A_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_A_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX,
      NULL_CHAR,
      UC_LATIN_SMALL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_C_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_C_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_C_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_E_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_E_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_I_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_I_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_I_WITH_DIAERESIS,
      // ascii 0xF0 ----------------------------------
      NULL_CHAR,
      UC_LATIN_SMALL_LETTER_N_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_O_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_O_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_G_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_O_WITH_DIAERESIS,
      UC_DIVISION_SIGN,
      UC_LATIN_SMALL_LETTER_G_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_U_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_U_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_U_WITH_BREVE,
      UC_LATIN_SMALL_LETTER_S_WITH_CIRCUMFLEX,
      UC_DOT_ABOVE,
   },

   {
      // table 4 = iso 8859-4: "Latin Alphabet No 4"
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_OGONEK,
      UC_LATIN_SMALL_LETTER_KRA,
      UC_LATIN_CAPITAL_LETTER_R_WITH_CEDILLA,
      UC_CURRENCY_SIGN,
      UC_LATIN_CAPITAL_LETTER_I_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_L_WITH_CEDILLA,
      UC_SECTION_SIGN,
      UC_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_S_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_E_WITH_MACRON,
      UC_LATIN_CAPITAL_LETTER_G_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_T_WITH_STROKE,
      UC_SOFT_HYPHEN,
      UC_LATIN_CAPITAL_LETTER_Z_WITH_CARON,
      UC_MACRON,
      // ascii 0xB0 ----------------------------------
      UC_DEGREE_SIGN,
      UC_LATIN_SMALL_LETTER_A_WITH_OGONEK,
      UC_OGONEK,
      UC_LATIN_SMALL_LETTER_R_WITH_CEDILLA,
      UC_ACUTE_ACCENT,
      UC_LATIN_SMALL_LETTER_I_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_L_WITH_CEDILLA,
      UC_CARON,
      UC_CEDILLA,
      UC_LATIN_SMALL_LETTER_S_WITH_CARON,
      UC_LATIN_SMALL_LETTER_E_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_G_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_T_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_ENG,
      UC_LATIN_SMALL_LETTER_Z_WITH_CARON,
      UC_LATIN_SMALL_LETTER_ENG,
      // ascii 0xC0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_A_WITH_MACRON,
      UC_LATIN_CAPITAL_LETTER_A_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_A_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_CAPITAL_LIGATURE_AE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_OGONEK,
      UC_LATIN_CAPITAL_LETTER_C_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_E_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_OGONEK,
      UC_LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_E_WITH_DOT_ABOVE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_I_WITH_MACRON,
      // ascii 0xD0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_D_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_N_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_O_WITH_MACRON,
      UC_LATIN_CAPITAL_LETTER_K_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_O_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS,
      UC_MULTIPLICATION_SIGN,
      UC_LATIN_CAPITAL_LETTER_O_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_OGONEK,
      UC_LATIN_CAPITAL_LETTER_U_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_U_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_SHARP_S,
      // ascii 0xE0 ----------------------------------
      UC_LATIN_SMALL_LETTER_A_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_A_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_A_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_SMALL_LIGATURE_AE,
      UC_LATIN_SMALL_LETTER_I_WITH_OGONEK,
      UC_LATIN_SMALL_LETTER_C_WITH_CARON,
      UC_LATIN_SMALL_LETTER_E_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_E_WITH_OGONEK,
      UC_LATIN_SMALL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_E_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_I_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_I_WITH_MACRON,
      // ascii 0xF0 ----------------------------------
      UC_LATIN_SMALL_LETTER_D_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_N_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_O_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_K_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_O_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_O_WITH_DIAERESIS,
      UC_DIVISION_SIGN,
      UC_LATIN_SMALL_LETTER_O_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_U_WITH_OGONEK,
      UC_LATIN_SMALL_LETTER_U_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_U_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_U_WITH_MACRON,
      UC_DOT_ABOVE
   },

   {
      // table 5 = iso 8859-5: "Latin/Cyrillic Alphabet"
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      UC_CYRILLIC_CAPITAL_LETTER_IO,
      UC_CYRILLIC_CAPITAL_LETTER_DJE,
      UC_CYRILLIC_CAPITAL_LETTER_GJE,
      UC_CYRILLIC_CAPITAL_LETTER_UKRAINIAN_IE,
      UC_CYRILLIC_CAPITAL_LETTER_DZE,
      UC_CYRILLIC_CAPITAL_LETTER_BYELORUSSIAN_UKRAINIAN_I,
      UC_CYRILLIC_CAPITAL_LETTER_YI,
      UC_CYRILLIC_CAPITAL_LETTER_JE,
      UC_CYRILLIC_CAPITAL_LETTER_LJE,
      UC_CYRILLIC_CAPITAL_LETTER_NJE,
      UC_CYRILLIC_CAPITAL_LETTER_TSHE,
      UC_CYRILLIC_CAPITAL_LETTER_KJE,
      UC_SOFT_HYPHEN,
      UC_CYRILLIC_CAPITAL_LETTER_SHORT_U,
      UC_CYRILLIC_CAPITAL_LETTER_DZHE,
      // ascii 0xB0 ----------------------------------
      UC_CYRILLIC_CAPITAL_LETTER_A,
      UC_CYRILLIC_CAPITAL_LETTER_BE,
      UC_CYRILLIC_CAPITAL_LETTER_VE,
      UC_CYRILLIC_CAPITAL_LETTER_GHE,
      UC_CYRILLIC_CAPITAL_LETTER_DE,
      UC_CYRILLIC_CAPITAL_LETTER_IE,
      UC_CYRILLIC_CAPITAL_LETTER_ZHE,
      UC_CYRILLIC_CAPITAL_LETTER_ZE,
      UC_CYRILLIC_CAPITAL_LETTER_I,
      UC_CYRILLIC_CAPITAL_LETTER_SHORT_I,
      UC_CYRILLIC_CAPITAL_LETTER_KA,
      UC_CYRILLIC_CAPITAL_LETTER_EL,
      UC_CYRILLIC_CAPITAL_LETTER_EM,
      UC_CYRILLIC_CAPITAL_LETTER_EN,
      UC_CYRILLIC_CAPITAL_LETTER_O,
      UC_CYRILLIC_CAPITAL_LETTER_PE,
      // ascii 0xC0 ----------------------------------
      UC_CYRILLIC_CAPITAL_LETTER_ER,
      UC_CYRILLIC_CAPITAL_LETTER_ES,
      UC_CYRILLIC_CAPITAL_LETTER_TE,
      UC_CYRILLIC_CAPITAL_LETTER_U,
      UC_CYRILLIC_CAPITAL_LETTER_EF,
      UC_CYRILLIC_CAPITAL_LETTER_HA,
      UC_CYRILLIC_CAPITAL_LETTER_TSE,
      UC_CYRILLIC_CAPITAL_LETTER_CHE,
      UC_CYRILLIC_CAPITAL_LETTER_SHA,
      UC_CYRILLIC_CAPITAL_LETTER_SHCHA,
      UC_CYRILLIC_CAPITAL_LETTER_HARD_SIGN,
      UC_CYRILLIC_CAPITAL_LETTER_YERU,
      UC_CYRILLIC_CAPITAL_LETTER_SOFT_SIGN,
      UC_CYRILLIC_CAPITAL_LETTER_E,
      UC_CYRILLIC_CAPITAL_LETTER_YU,
      UC_CYRILLIC_CAPITAL_LETTER_YA,
      // ascii 0xD0 ----------------------------------
      UC_CYRILLIC_SMALL_LETTER_A,
      UC_CYRILLIC_SMALL_LETTER_BE,
      UC_CYRILLIC_SMALL_LETTER_VE,
      UC_CYRILLIC_SMALL_LETTER_GHE,
      UC_CYRILLIC_SMALL_LETTER_DE,
      UC_CYRILLIC_SMALL_LETTER_IE,
      UC_CYRILLIC_SMALL_LETTER_ZHE,
      UC_CYRILLIC_SMALL_LETTER_ZE,
      UC_CYRILLIC_SMALL_LETTER_I,
      UC_CYRILLIC_SMALL_LETTER_SHORT_I,
      UC_CYRILLIC_SMALL_LETTER_KA,
      UC_CYRILLIC_SMALL_LETTER_EL,
      UC_CYRILLIC_SMALL_LETTER_EM,
      UC_CYRILLIC_SMALL_LETTER_EN,
      UC_CYRILLIC_SMALL_LETTER_O,
      UC_CYRILLIC_SMALL_LETTER_PE,
      // ascii 0xE0 ----------------------------------
      UC_CYRILLIC_SMALL_LETTER_ER,
      UC_CYRILLIC_SMALL_LETTER_ES,
      UC_CYRILLIC_SMALL_LETTER_TE,
      UC_CYRILLIC_SMALL_LETTER_U,
      UC_CYRILLIC_SMALL_LETTER_EF,
      UC_CYRILLIC_SMALL_LETTER_HA,
      UC_CYRILLIC_SMALL_LETTER_TSE,
      UC_CYRILLIC_SMALL_LETTER_CHE,
      UC_CYRILLIC_SMALL_LETTER_SHA,
      UC_CYRILLIC_SMALL_LETTER_SHCHA,
      UC_CYRILLIC_SMALL_LETTER_HARD_SIGN,
      UC_CYRILLIC_SMALL_LETTER_YERU,
      UC_CYRILLIC_SMALL_LETTER_SOFT_SIGN,
      UC_CYRILLIC_SMALL_LETTER_E,
      UC_CYRILLIC_SMALL_LETTER_YU,
      UC_CYRILLIC_SMALL_LETTER_YA,
      // ascii 0xF0 ----------------------------------
      UC_NUMERO_SIGN,
      UC_CYRILLIC_SMALL_LETTER_IO,
      UC_CYRILLIC_SMALL_LETTER_DJE,
      UC_CYRILLIC_SMALL_LETTER_GJE,
      UC_CYRILLIC_SMALL_LETTER_UKRAINIAN_IE,
      UC_CYRILLIC_SMALL_LETTER_DZE,
      UC_CYRILLIC_SMALL_LETTER_BYELORUSSIAN_UKRAINIAN_I,
      UC_CYRILLIC_SMALL_LETTER_YI,
      UC_CYRILLIC_SMALL_LETTER_JE,
      UC_CYRILLIC_SMALL_LETTER_LJE,
      UC_CYRILLIC_SMALL_LETTER_NJE,
      UC_CYRILLIC_SMALL_LETTER_TSHE,
      UC_CYRILLIC_SMALL_LETTER_KJE,
      UC_SECTION_SIGN,
      UC_CYRILLIC_SMALL_LETTER_SHORT_U,
      UC_CYRILLIC_SMALL_LETTER_DZHE
   },

   {
      // table 6 = iso 8859-6: "Latin/Arabic Alphabet"
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      UC_CURRENCY_SIGN,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      UC_ARABIC_COMMA,
      UC_SOFT_HYPHEN,
      NULL_CHAR,
      NULL_CHAR,
      // ascii 0xB0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      UC_ARABIC_SEMICOLON,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      UC_ARABIC_QUESTION_MARK,
      // ascii 0xC0 ----------------------------------
      NULL_CHAR,
      UC_ARABIC_LETTER_HAMZA,
      UC_ARABIC_LETTER_ALEF_WITH_MADDA_ABOVE,
      UC_ARABIC_LETTER_ALEF_WITH_HAMZA_ABOVE,
      UC_ARABIC_LETTER_WAW_WITH_HAMZA_ABOVE,
      UC_ARABIC_LETTER_ALEF_WITH_HAMZA_BELOW,
      UC_ARABIC_LETTER_YEH_WITH_HAMZA_ABOVE,
      UC_ARABIC_LETTER_ALEF,
      UC_ARABIC_LETTER_BEH,
      UC_ARABIC_LETTER_TEH_MARBUTA,
      UC_ARABIC_LETTER_TEH,
      UC_ARABIC_LETTER_THEH,
      UC_ARABIC_LETTER_JEEM,
      UC_ARABIC_LETTER_HAH,
      UC_ARABIC_LETTER_KHAH,
      UC_ARABIC_LETTER_DAL,
      // ascii 0xD0 ----------------------------------
      UC_ARABIC_LETTER_THAL,
      UC_ARABIC_LETTER_REH,
      UC_ARABIC_LETTER_ZAIN,
      UC_ARABIC_LETTER_SEEN,
      UC_ARABIC_LETTER_SHEEN,
      UC_ARABIC_LETTER_SAD,
      UC_ARABIC_LETTER_DAD,
      UC_ARABIC_LETTER_TAH,
      UC_ARABIC_LETTER_ZAH,
      UC_ARABIC_LETTER_AIN,
      UC_ARABIC_LETTER_GHAIN,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      // ascii 0xE0 ----------------------------------
      UC_ARABIC_TATWEEL,
      UC_ARABIC_LETTER_FEH,
      UC_ARABIC_LETTER_QAF,
      UC_ARABIC_LETTER_KAF,
      UC_ARABIC_LETTER_LAM,
      UC_ARABIC_LETTER_MEEM,
      UC_ARABIC_LETTER_NOON,
      UC_ARABIC_LETTER_HEH,
      UC_ARABIC_LETTER_WAW,
      UC_ARABIC_LETTER_ALEF_MAKSURA,
      UC_ARABIC_LETTER_YEH,
      UC_ARABIC_FATHATAN,
      UC_ARABIC_DAMMATAN,
      UC_ARABIC_KASRATAN,
      UC_ARABIC_FATHA,
      UC_ARABIC_DAMMA,
      // ascii 0xF0 ----------------------------------
      UC_ARABIC_KASRA,
      UC_ARABIC_SHADDA,
      UC_ARABIC_SUKUN,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR
   },

   {
      // table 7 = iso 8859-7: "Latin/Greek Alphabet"
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      UC_LEFT_SINGLE_QUOTATION_MARK,
      UC_RIGHT_SINGLE_QUOTATION_MARK,
      UC_POUND_SIGN,
      NULL_CHAR,
      NULL_CHAR,
      UC_BROKEN_BAR,
      UC_SECTION_SIGN,
      UC_DIAERESIS,
      UC_COPYRIGHT_SIGN,
      NULL_CHAR,
      UC_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_NOT_SIGN,
      UC_SOFT_HYPHEN,
      NULL_CHAR,
      UC_HORIZONTAL_BAR,
      // ascii 0xB0 ----------------------------------
      UC_DEGREE_SIGN,
      UC_PLUS_MINUS_SIGN,
      UC_SUPERSCRIPT_TWO,
      UC_SUPERSCRIPT_THREE,
      UC_GREEK_TONOS,
      UC_GREEK_DIALYTIKA_TONOS,
      UC_GREEK_CAPITAL_LETTER_ALPHA_WITH_TONOS,
      UC_GREEK_ANO_TELEIA,
      UC_GREEK_CAPITAL_LETTER_EPSILON_WITH_TONOS,
      UC_GREEK_CAPITAL_LETTER_ETA_WITH_TONOS,
      UC_GREEK_CAPITAL_LETTER_IOTA_WITH_TONOS,
      UC_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_GREEK_CAPITAL_LETTER_OMICRON_WITH_TONOS,
      UC_VULGAR_FRACTION_ONE_HALF,
      UC_GREEK_CAPITAL_LETTER_UPSILON_WITH_TONOS,
      UC_GREEK_CAPITAL_LETTER_OMEGA_WITH_TONOS,
      // ascii 0xC0 ----------------------------------
      UC_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_TONOS,
      UC_GREEK_CAPITAL_LETTER_ALPHA,
      UC_GREEK_CAPITAL_LETTER_BETA,
      UC_GREEK_CAPITAL_LETTER_GAMMA,
      UC_GREEK_CAPITAL_LETTER_DELTA,
      UC_GREEK_CAPITAL_LETTER_EPSILON,
      UC_GREEK_CAPITAL_LETTER_ZETA,
      UC_GREEK_CAPITAL_LETTER_ETA,
      UC_GREEK_CAPITAL_LETTER_THETA,
      UC_GREEK_CAPITAL_LETTER_IOTA,
      UC_GREEK_CAPITAL_LETTER_KAPPA,
      UC_GREEK_CAPITAL_LETTER_LAMDA,
      UC_GREEK_CAPITAL_LETTER_MU,
      UC_GREEK_CAPITAL_LETTER_NU,
      UC_GREEK_CAPITAL_LETTER_XI,
      UC_GREEK_CAPITAL_LETTER_OMICRON,
      // ascii 0xD0 ----------------------------------
      UC_GREEK_CAPITAL_LETTER_PI,
      UC_GREEK_CAPITAL_LETTER_RHO,
      NULL_CHAR,
      UC_GREEK_CAPITAL_LETTER_SIGMA,
      UC_GREEK_CAPITAL_LETTER_TAU,
      UC_GREEK_CAPITAL_LETTER_UPSILON,
      UC_GREEK_CAPITAL_LETTER_PHI,
      UC_GREEK_CAPITAL_LETTER_CHI,
      UC_GREEK_CAPITAL_LETTER_PSI,
      UC_GREEK_CAPITAL_LETTER_OMEGA,
      UC_GREEK_CAPITAL_LETTER_IOTA_WITH_DIALYTIKA,
      UC_GREEK_CAPITAL_LETTER_UPSILON_WITH_DIALYTIKA,
      UC_GREEK_SMALL_LETTER_ALPHA_WITH_TONOS,
      UC_GREEK_SMALL_LETTER_EPSILON_WITH_TONOS,
      UC_GREEK_SMALL_LETTER_ETA_WITH_TONOS,
      UC_GREEK_SMALL_LETTER_IOTA_WITH_TONOS,
      // ascii 0xE0 ----------------------------------
      UC_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_TONOS,
      UC_GREEK_SMALL_LETTER_ALPHA,
      UC_GREEK_SMALL_LETTER_BETA,
      UC_GREEK_SMALL_LETTER_GAMMA,
      UC_GREEK_SMALL_LETTER_DELTA,
      UC_GREEK_SMALL_LETTER_EPSILON,
      UC_GREEK_SMALL_LETTER_ZETA,
      UC_GREEK_SMALL_LETTER_ETA,
      UC_GREEK_SMALL_LETTER_THETA,
      UC_GREEK_SMALL_LETTER_IOTA,
      UC_GREEK_SMALL_LETTER_KAPPA,
      UC_GREEK_SMALL_LETTER_LAMDA,
      UC_GREEK_SMALL_LETTER_MU,
      UC_GREEK_SMALL_LETTER_NU,
      UC_GREEK_SMALL_LETTER_XI,
      UC_GREEK_SMALL_LETTER_OMICRON,
      // ascii 0xF0 ----------------------------------
      UC_GREEK_SMALL_LETTER_PI,
      UC_GREEK_SMALL_LETTER_RHO,
      UC_GREEK_SMALL_LETTER_FINAL_SIGMA,
      UC_GREEK_SMALL_LETTER_SIGMA,
      UC_GREEK_SMALL_LETTER_TAU,
      UC_GREEK_SMALL_LETTER_UPSILON,
      UC_GREEK_SMALL_LETTER_PHI,
      UC_GREEK_SMALL_LETTER_CHI,
      UC_GREEK_SMALL_LETTER_PSI,
      UC_GREEK_SMALL_LETTER_OMEGA,
      UC_GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA,
      UC_GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA,
      UC_GREEK_SMALL_LETTER_OMICRON_WITH_TONOS,
      UC_GREEK_SMALL_LETTER_UPSILON_WITH_TONOS,
      UC_GREEK_SMALL_LETTER_OMEGA_WITH_TONOS,
      NULL_CHAR
   },

   {
      // table 8 = iso 8859-8: "Latin/Hebrew Alphabet"
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      NULL_CHAR,
      UC_CENT_SIGN,
      UC_POUND_SIGN,
      UC_CURRENCY_SIGN,
      UC_YEN_SIGN,
      UC_BROKEN_BAR,
      UC_SECTION_SIGN,
      UC_DIAERESIS,
      UC_COPYRIGHT_SIGN,
      UC_MULTIPLICATION_SIGN,
      UC_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_NOT_SIGN,
      UC_SOFT_HYPHEN,
      UC_REGISTERED_SIGN,
      UC_MACRON,
      // ascii 0xB0 ----------------------------------
      UC_DEGREE_SIGN,
      UC_PLUS_MINUS_SIGN,
      UC_SUPERSCRIPT_TWO,
      UC_SUPERSCRIPT_THREE,
      UC_ACUTE_ACCENT,
      UC_MICRO_SIGN,
      UC_PILCROW_SIGN,
      UC_MIDDLE_DOT,
      UC_CEDILLA,
      UC_SUPERSCRIPT_ONE,
      UC_DIVISION_SIGN,
      UC_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_VULGAR_FRACTION_ONE_QUARTER,
      UC_VULGAR_FRACTION_ONE_HALF,
      UC_VULGAR_FRACTION_THREE_QUARTERS,
      NULL_CHAR,
      // ascii 0xC0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      // ascii 0xD0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      UC_DOUBLE_LOW_LINE,
      // ascii 0xE0 ----------------------------------
      UC_HEBREW_LETTER_ALEF,
      UC_HEBREW_LETTER_BET,
      UC_HEBREW_LETTER_GIMEL,
      UC_HEBREW_LETTER_DALET,
      UC_HEBREW_LETTER_HE,
      UC_HEBREW_LETTER_VAV,
      UC_HEBREW_LETTER_ZAYIN,
      UC_HEBREW_LETTER_HET,
      UC_HEBREW_LETTER_TET,
      UC_HEBREW_LETTER_YOD,
      UC_HEBREW_LETTER_FINAL_KAF,
      UC_HEBREW_LETTER_KAF,
      UC_HEBREW_LETTER_LAMED,
      UC_HEBREW_LETTER_FINAL_MEM,
      UC_HEBREW_LETTER_MEM,
      UC_HEBREW_LETTER_FINAL_NUN,
      // ascii 0xF0 ----------------------------------
      UC_HEBREW_LETTER_NUN,
      UC_HEBREW_LETTER_SAMEKH,
      UC_HEBREW_LETTER_AYIN,
      UC_HEBREW_LETTER_FINAL_PE,
      UC_HEBREW_LETTER_PE,
      UC_HEBREW_LETTER_FINAL_TSADI,
      UC_HEBREW_LETTER_TSADI,
      UC_HEBREW_LETTER_QOF,
      UC_HEBREW_LETTER_RESH,
      UC_HEBREW_LETTER_SHIN,
      UC_HEBREW_LETTER_TAV,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR
   },

   {
      // table 9 = iso 8859-9: "Latin Alphabet No 5"
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      UC_INVERTED_EXCLAMATION_MARK,
      UC_CENT_SIGN,
      UC_POUND_SIGN,
      UC_CURRENCY_SIGN,
      UC_YEN_SIGN,
      UC_BROKEN_BAR,
      UC_SECTION_SIGN,
      UC_DIAERESIS,
      UC_COPYRIGHT_SIGN,
      UC_FEMININE_ORDINAL_INDICATOR,
      UC_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_NOT_SIGN,
      UC_SOFT_HYPHEN,
      UC_REGISTERED_SIGN,
      UC_MACRON,
      // ascii 0xB0 ----------------------------------
      UC_DEGREE_SIGN,
      UC_PLUS_MINUS_SIGN,
      UC_SUPERSCRIPT_TWO,
      UC_SUPERSCRIPT_THREE,
      UC_ACUTE_ACCENT,
      UC_MICRO_SIGN,
      UC_PILCROW_SIGN,
      UC_MIDDLE_DOT,
      UC_CEDILLA,
      UC_SUPERSCRIPT_ONE,
      UC_MASCULINE_ORDINAL_INDICATOR,
      UC_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_VULGAR_FRACTION_ONE_QUARTER,
      UC_VULGAR_FRACTION_ONE_HALF,
      UC_VULGAR_FRACTION_THREE_QUARTERS,
      UC_INVERTED_QUESTION_MARK,
      // ascii 0xC0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_A_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_A_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_CAPITAL_LIGATURE_AE,
      UC_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_E_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_I_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS,
      // ascii 0xD0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_G_WITH_BREVE,
      UC_LATIN_CAPITAL_LETTER_N_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_O_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS,
      UC_MULTIPLICATION_SIGN,
      UC_LATIN_CAPITAL_LETTER_O_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_I_WITH_DOT_ABOVE,
      UC_LATIN_CAPITAL_LETTER_S_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_SHARP_S,
      // ascii 0xE0 ----------------------------------
      UC_LATIN_SMALL_LETTER_A_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_A_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_A_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_SMALL_LIGATURE_AE,
      UC_LATIN_SMALL_LETTER_C_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_E_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_E_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_I_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_I_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_I_WITH_DIAERESIS,
      // ascii 0xF0 ----------------------------------
      UC_LATIN_SMALL_LETTER_G_WITH_BREVE,
      UC_LATIN_SMALL_LETTER_N_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_O_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_O_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_O_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_O_WITH_DIAERESIS,
      UC_DIVISION_SIGN,
      UC_LATIN_SMALL_LETTER_O_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_U_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_U_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_DOTLESS_I,
      UC_LATIN_SMALL_LETTER_S_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS
   },

   {
      // table 10 = iso 8859-10: "Latin Alphabet No 6"
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_OGONEK,
      UC_LATIN_CAPITAL_LETTER_E_WITH_MACRON,
      UC_LATIN_CAPITAL_LETTER_G_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_I_WITH_MACRON,
      UC_LATIN_CAPITAL_LETTER_I_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_K_WITH_CEDILLA,
      UC_SECTION_SIGN,
      UC_LATIN_CAPITAL_LETTER_L_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_D_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_S_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_T_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_Z_WITH_CARON,
      UC_SOFT_HYPHEN,
      UC_LATIN_CAPITAL_LETTER_U_WITH_MACRON,
      UC_LATIN_CAPITAL_LETTER_ENG,
      // ascii 0xB0 ----------------------------------
      UC_DEGREE_SIGN,
      UC_LATIN_SMALL_LETTER_A_WITH_OGONEK,
      UC_LATIN_SMALL_LETTER_E_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_G_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_I_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_I_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_K_WITH_CEDILLA,
      UC_MIDDLE_DOT,
      UC_LATIN_SMALL_LETTER_L_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_D_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_S_WITH_CARON,
      UC_LATIN_SMALL_LETTER_T_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_Z_WITH_CARON,
      UC_HORIZONTAL_BAR,
      UC_LATIN_SMALL_LETTER_U_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_ENG,
      // ascii 0xC0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_A_WITH_MACRON,
      UC_LATIN_CAPITAL_LETTER_A_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_A_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_CAPITAL_LIGATURE_AE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_OGONEK,
      UC_LATIN_CAPITAL_LETTER_C_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_E_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_OGONEK,
      UC_LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_E_WITH_DOT_ABOVE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS,
      // ascii 0xD0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_ETH,
      UC_LATIN_CAPITAL_LETTER_N_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_O_WITH_MACRON,
      UC_LATIN_CAPITAL_LETTER_O_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_O_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_U_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_OGONEK,
      UC_LATIN_CAPITAL_LETTER_U_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_Y_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_THORN,
      UC_LATIN_SMALL_LETTER_SHARP_S,
      // ascii 0xE0 ----------------------------------
      UC_LATIN_SMALL_LETTER_A_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_A_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_A_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_SMALL_LIGATURE_AE,
      UC_LATIN_SMALL_LETTER_I_WITH_OGONEK,
      UC_LATIN_SMALL_LETTER_C_WITH_CARON,
      UC_LATIN_SMALL_LETTER_E_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_E_WITH_OGONEK,
      UC_LATIN_SMALL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_E_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_I_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_I_WITH_DIAERESIS,
      // ascii 0xF0 ----------------------------------
      UC_LATIN_SMALL_LETTER_ETH,
      UC_LATIN_SMALL_LETTER_N_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_O_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_O_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_O_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_O_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_U_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_O_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_U_WITH_OGONEK,
      UC_LATIN_SMALL_LETTER_U_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_Y_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_THORN,
      UC_LATIN_SMALL_LETTER_KRA
   },

   {
      // table 11 = iso 8859-11
      // ascii 0xA0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      // ascii 0xB0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      // ascii 0xC0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      // ascii 0xD0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      // ascii 0xE0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      // ascii 0xF0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR
   },

   {
      // table 12 = iso 8859-12
      // ascii 0xA0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      // ascii 0xB0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      // ascii 0xC0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      // ascii 0xD0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      // ascii 0xE0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      // ascii 0xF0 ----------------------------------
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR,
      NULL_CHAR
   },

   {
      // table 13 = iso 8859-13 Latin/Baltic Rim
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      UC_RIGHT_DOUBLE_QUOTATION_MARK,
      UC_CENT_SIGN,
      UC_POUND_SIGN,
      UC_CURRENCY_SIGN,
      UC_DOUBLE_LOW_9_QUOTATION_MARK,
      UC_BROKEN_BAR,
      UC_SECTION_SIGN,
      UC_LATIN_CAPITAL_LETTER_O_WITH_STROKE,
      UC_COPYRIGHT_SIGN,
      UC_LATIN_CAPITAL_LETTER_R_WITH_CEDILLA,
      UC_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_NOT_SIGN,
      UC_SOFT_HYPHEN,
      UC_REGISTERED_SIGN,
      UC_LATIN_CAPITAL_LIGATURE_AE,
      // ascii 0xB0 ----------------------------------
      UC_DEGREE_SIGN,
      UC_PLUS_MINUS_SIGN,
      UC_SUPERSCRIPT_TWO,
      UC_SUPERSCRIPT_THREE,
      UC_LEFT_DOUBLE_QUOTATION_MARK,
      UC_MICRO_SIGN,
      UC_PILCROW_SIGN,
      UC_MIDDLE_DOT,
      UC_LATIN_SMALL_LETTER_O_WITH_STROKE,
      UC_SUPERSCRIPT_ONE,
      UC_LATIN_SMALL_LETTER_R_WITH_CEDILLA,
      UC_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_VULGAR_FRACTION_ONE_QUARTER,
      UC_VULGAR_FRACTION_ONE_HALF,
      UC_VULGAR_FRACTION_THREE_QUARTERS,
      UC_LATIN_SMALL_LIGATURE_AE,
      // ascii 0xC0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_A_WITH_OGONEK,
      UC_LATIN_CAPITAL_LETTER_I_WITH_OGONEK,
      UC_LATIN_CAPITAL_LETTER_A_WITH_MACRON,
      UC_LATIN_CAPITAL_LETTER_C_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_OGONEK,
      UC_LATIN_CAPITAL_LETTER_E_WITH_MACRON,
      UC_LATIN_CAPITAL_LETTER_C_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_E_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_Z_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_DOT_ABOVE,
      UC_LATIN_CAPITAL_LETTER_G_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_K_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_I_WITH_MACRON,
      UC_LATIN_CAPITAL_LETTER_L_WITH_CEDILLA,
      // ascii 0xD0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_S_WITH_CARON,
      UC_LATIN_CAPITAL_LETTER_N_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_N_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_O_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_MACRON,
      UC_LATIN_CAPITAL_LETTER_O_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS,
      UC_MULTIPLICATION_SIGN,
      UC_LATIN_CAPITAL_LETTER_U_WITH_OGONEK,
      UC_LATIN_CAPITAL_LETTER_L_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_S_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_MACRON,
      UC_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_Z_WITH_DOT_ABOVE,
      UC_LATIN_CAPITAL_LETTER_Z_WITH_CARON,
      UC_LATIN_SMALL_LETTER_SHARP_S,
      // ascii 0xE0 ----------------------------------
      UC_LATIN_SMALL_LETTER_A_WITH_OGONEK,
      UC_LATIN_SMALL_LETTER_I_WITH_OGONEK,
      UC_LATIN_SMALL_LETTER_A_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_C_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_SMALL_LETTER_E_WITH_OGONEK,
      UC_LATIN_SMALL_LETTER_E_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_C_WITH_CARON,
      UC_LATIN_SMALL_LETTER_E_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_Z_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_E_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_G_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_K_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_I_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_L_WITH_CEDILLA,
      // ascii 0xF0 ----------------------------------
      UC_LATIN_SMALL_LETTER_S_WITH_CARON,
      UC_LATIN_SMALL_LETTER_N_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_N_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_O_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_O_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_O_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_O_WITH_DIAERESIS,
      UC_DIVISION_SIGN,
      UC_LATIN_SMALL_LETTER_U_WITH_OGONEK,
      UC_LATIN_SMALL_LETTER_L_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_S_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_U_WITH_MACRON,
      UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_Z_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_Z_WITH_CARON,
      UC_RIGHT_SINGLE_QUOTATION_MARK
   },

   {
      // table 14 = iso 8859-14
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      UC_LATIN_CAPITAL_LETTER_B_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_B_WITH_DOT_ABOVE,
      UC_POUND_SIGN,
      UC_LATIN_CAPITAL_LETTER_C_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_C_WITH_DOT_ABOVE,
      UC_LATIN_CAPITAL_LETTER_D_WITH_DOT_ABOVE,
      UC_SECTION_SIGN,
      UC_LATIN_CAPITAL_LETTER_W_WITH_GRAVE,
      UC_COPYRIGHT_SIGN,
      UC_LATIN_CAPITAL_LETTER_W_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_D_WITH_DOT_ABOVE,
      UC_LATIN_CAPITAL_LETTER_Y_WITH_GRAVE,
      UC_SOFT_HYPHEN,
      UC_REGISTERED_SIGN,
      UC_LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS,
      // ascii 0xB0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_F_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_F_WITH_DOT_ABOVE,
      UC_LATIN_CAPITAL_LETTER_G_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_G_WITH_DOT_ABOVE,
      UC_LATIN_CAPITAL_LETTER_M_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_M_WITH_DOT_ABOVE,
      UC_PILCROW_SIGN,
      UC_LATIN_CAPITAL_LETTER_P_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_W_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_P_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_W_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_S_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_Y_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_W_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_W_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_S_WITH_DOT_ABOVE,
      // ascii 0xC0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_A_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_A_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_CAPITAL_LIGATURE_AE,
      UC_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_E_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_I_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS,
      // ascii 0xD0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_W_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_N_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_O_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_T_WITH_DOT_ABOVE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_Y_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_Y_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_SHARP_S,
      // ascii 0xE0 ----------------------------------
      UC_LATIN_SMALL_LETTER_A_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_A_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_A_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_SMALL_LIGATURE_AE,
      UC_LATIN_SMALL_LETTER_C_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_E_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_E_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_I_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_I_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_I_WITH_DIAERESIS,
      // ascii 0xF0 ----------------------------------
      UC_LATIN_SMALL_LETTER_W_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_N_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_O_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_O_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_O_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_O_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_T_WITH_DOT_ABOVE,
      UC_LATIN_SMALL_LETTER_O_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_U_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_U_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_Y_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_Y_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS
   },

   {
      // table 15 = iso 8859-15
      // ascii 0xA0 ----------------------------------
      UC_NO_BREAK_SPACE,
      UC_INVERTED_EXCLAMATION_MARK,
      UC_CENT_SIGN,
      UC_POUND_SIGN,
      UC_CURRENCY_SIGN,
      UC_YEN_SIGN,
      UC_LATIN_CAPITAL_LETTER_S_WITH_CARON,
      UC_SECTION_SIGN,
      UC_LATIN_SMALL_LETTER_S_WITH_CARON,
      UC_COPYRIGHT_SIGN,
      UC_FEMININE_ORDINAL_INDICATOR,
      UC_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_NOT_SIGN,
      UC_SOFT_HYPHEN,
      UC_REGISTERED_SIGN,
      UC_MACRON,
      // ascii 0xB0 ----------------------------------
      UC_DEGREE_SIGN,
      UC_EURO_SIGN,
      UC_SUPERSCRIPT_TWO,
      UC_SUPERSCRIPT_THREE,
      UC_LATIN_CAPITAL_LETTER_Z_WITH_CARON,
      UC_MICRO_SIGN,
      UC_PILCROW_SIGN,
      UC_MIDDLE_DOT,
      UC_LATIN_SMALL_LETTER_Z_WITH_CARON,
      UC_SUPERSCRIPT_ONE,
      UC_MASCULINE_ORDINAL_INDICATOR,
      UC_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
      UC_LATIN_CAPITAL_LIGATURE_OE,
      UC_LATIN_SMALL_LIGATURE_OE,
      UC_LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS,
      UC_INVERTED_QUESTION_MARK,
      // ascii 0xC0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_A_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_A_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_CAPITAL_LIGATURE_AE,
      UC_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA,
      UC_LATIN_CAPITAL_LETTER_E_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_I_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS,
      // ascii 0xD0 ----------------------------------
      UC_LATIN_CAPITAL_LETTER_ETH,
      UC_LATIN_CAPITAL_LETTER_N_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_O_WITH_TILDE,
      UC_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS,
      UC_MULTIPLICATION_SIGN,
      UC_LATIN_CAPITAL_LETTER_O_WITH_STROKE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_GRAVE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_CAPITAL_LETTER_Y_WITH_ACUTE,
      UC_LATIN_CAPITAL_LETTER_THORN,
      UC_GREEK_CAPITAL_LETTER_BETA,
      // ascii 0xE0 ----------------------------------
      UC_LATIN_SMALL_LETTER_A_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_A_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_A_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_A_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE,
      UC_LATIN_SMALL_LIGATURE_AE,
      UC_LATIN_SMALL_LETTER_C_WITH_CEDILLA,
      UC_LATIN_SMALL_LETTER_E_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_E_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_E_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_I_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_I_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_I_WITH_DIAERESIS,
      // ascii 0xF0 ----------------------------------
      UC_LATIN_SMALL_LETTER_ETH,
      UC_LATIN_SMALL_LETTER_N_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_O_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_O_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_O_WITH_TILDE,
      UC_LATIN_SMALL_LETTER_O_WITH_DIAERESIS,
      UC_DIVISION_SIGN,
      UC_LATIN_SMALL_LETTER_O_WITH_STROKE,
      UC_LATIN_SMALL_LETTER_U_WITH_GRAVE,
      UC_LATIN_SMALL_LETTER_U_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX,
      UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS,
      UC_LATIN_SMALL_LETTER_Y_WITH_ACUTE,
      UC_LATIN_SMALL_LETTER_THORN,
      UC_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS
   }
};


/* Table to map UTF-8 char codes to UTF-16 as used in the font file */
static const U16BIT utf8_char_map[96] =
{
   // ascii 0xA0 ----------------------------------
   UC_NO_BREAK_SPACE,
   UC_INVERTED_EXCLAMATION_MARK,
   UC_CENT_SIGN,
   UC_POUND_SIGN,
   UC_EURO_SIGN,
   UC_YEN_SIGN,
   NULL_CHAR,
   UC_SECTION_SIGN,
   UC_CURRENCY_SIGN,
   UC_COPYRIGHT_SIGN,
   UC_LEFT_DOUBLE_QUOTATION_MARK,
   UC_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
   UC_LEFTWARDS_ARROW,
   UC_UPWARDS_ARROW,
   UC_REGISTERED_SIGN,
   UC_DOWNWARDS_ARROW,
   // ascii 0xB0 ----------------------------------
   UC_DEGREE_SIGN,
   UC_PLUS_MINUS_SIGN,
   UC_SUPERSCRIPT_TWO,
   UC_SUPERSCRIPT_THREE,
   UC_MULTIPLICATION_SIGN,
   UC_MICRO_SIGN,
   UC_PILCROW_SIGN,
   UC_MIDDLE_DOT,
   UC_DIVISION_SIGN,
   UC_RIGHT_SINGLE_QUOTATION_MARK,
   UC_RIGHT_DOUBLE_QUOTATION_MARK,
   UC_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK,
   UC_VULGAR_FRACTION_ONE_QUARTER,
   UC_VULGAR_FRACTION_ONE_HALF,
   UC_VULGAR_FRACTION_THREE_QUARTERS,
   UC_INVERTED_QUESTION_MARK,
   // ascii 0xC0 ----------------------------------
   UC_LATIN_CAPITAL_LETTER_A_WITH_GRAVE,
   UC_LATIN_CAPITAL_LETTER_A_WITH_ACUTE,
   UC_LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX,
   UC_LATIN_CAPITAL_LETTER_A_WITH_TILDE,
   UC_LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS,
   UC_LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE,
   UC_LATIN_CAPITAL_LIGATURE_AE,
   UC_LATIN_CAPITAL_LETTER_C_WITH_CEDILLA,
   UC_LATIN_CAPITAL_LETTER_E_WITH_GRAVE,
   UC_LATIN_CAPITAL_LETTER_E_WITH_ACUTE,
   UC_LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX,
   UC_LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS,
   UC_LATIN_CAPITAL_LETTER_I_WITH_GRAVE,
   UC_LATIN_CAPITAL_LETTER_I_WITH_ACUTE,
   UC_LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX,
   UC_LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS,
   // ascii 0xD0 ----------------------------------
   UC_LATIN_CAPITAL_LETTER_ETH,
   UC_LATIN_CAPITAL_LETTER_N_WITH_TILDE,
   UC_LATIN_CAPITAL_LETTER_O_WITH_GRAVE,
   UC_LATIN_CAPITAL_LETTER_O_WITH_ACUTE,
   UC_LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX,
   UC_LATIN_CAPITAL_LETTER_O_WITH_TILDE,
   UC_LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS,
   UC_MULTIPLICATION_SIGN,
   UC_LATIN_CAPITAL_LETTER_O_WITH_STROKE,
   UC_LATIN_CAPITAL_LETTER_U_WITH_GRAVE,
   UC_LATIN_CAPITAL_LETTER_U_WITH_ACUTE,
   UC_LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX,
   UC_LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS,
   UC_LATIN_CAPITAL_LETTER_Y_WITH_ACUTE,
   UC_LATIN_CAPITAL_LETTER_THORN,
   UC_LATIN_SMALL_LETTER_SHARP_S,
   // ascii 0xE0 ----------------------------------
   UC_LATIN_SMALL_LETTER_A_WITH_GRAVE,
   UC_LATIN_SMALL_LETTER_A_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_A_WITH_TILDE,
   UC_LATIN_SMALL_LETTER_A_WITH_DIAERESIS,
   UC_LATIN_SMALL_LETTER_A_WITH_RING_ABOVE,
   UC_LATIN_SMALL_LIGATURE_AE,
   UC_LATIN_SMALL_LETTER_C_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_E_WITH_GRAVE,
   UC_LATIN_SMALL_LETTER_E_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_E_WITH_DIAERESIS,
   UC_LATIN_SMALL_LETTER_I_WITH_GRAVE,
   UC_LATIN_SMALL_LETTER_I_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_I_WITH_DIAERESIS,
   // ascii 0xF0 ----------------------------------
   UC_LATIN_SMALL_LETTER_ETH,
   UC_LATIN_SMALL_LETTER_N_WITH_TILDE,
   UC_LATIN_SMALL_LETTER_O_WITH_GRAVE,
   UC_LATIN_SMALL_LETTER_O_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_O_WITH_TILDE,
   UC_LATIN_SMALL_LETTER_O_WITH_DIAERESIS,
   UC_DIVISION_SIGN,
   UC_LATIN_SMALL_LETTER_O_WITH_STROKE,
   UC_LATIN_SMALL_LETTER_U_WITH_GRAVE,
   UC_LATIN_SMALL_LETTER_U_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS,
   UC_LATIN_SMALL_LETTER_Y_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_THORN,
   UC_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS
};

static const U16BIT lowercase_chars_0x0100[] =
{
   UC_LATIN_SMALL_LETTER_A_WITH_MACRON,
   UC_LATIN_SMALL_LETTER_A_WITH_MACRON,
   UC_LATIN_SMALL_LETTER_A_WITH_BRIEVE,
   UC_LATIN_SMALL_LETTER_A_WITH_BRIEVE,
   UC_LATIN_SMALL_LETTER_A_WITH_OGONEK,
   UC_LATIN_SMALL_LETTER_A_WITH_OGONEK,
   UC_LATIN_SMALL_LETTER_C_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_C_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_C_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_C_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_C_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_C_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_C_WITH_CARON,
   UC_LATIN_SMALL_LETTER_C_WITH_CARON,
   UC_LATIN_SMALL_LETTER_D_WITH_CARON,
   UC_LATIN_SMALL_LETTER_D_WITH_CARON,
   UC_LATIN_SMALL_LETTER_D_WITH_STROKE,
   UC_LATIN_SMALL_LETTER_D_WITH_STROKE,
   UC_LATIN_SMALL_LETTER_E_WITH_MACRON,
   UC_LATIN_SMALL_LETTER_E_WITH_MACRON,
   UC_LATIN_SMALL_LETTER_E_WITH_BREVE,
   UC_LATIN_SMALL_LETTER_E_WITH_BREVE,
   UC_LATIN_SMALL_LETTER_E_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_E_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_E_WITH_OGONEK,
   UC_LATIN_SMALL_LETTER_E_WITH_OGONEK,
   UC_LATIN_SMALL_LETTER_E_WITH_CARON,
   UC_LATIN_SMALL_LETTER_E_WITH_CARON,
   UC_LATIN_SMALL_LETTER_G_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_G_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_G_WITH_BREVE,
   UC_LATIN_SMALL_LETTER_G_WITH_BREVE,
   UC_LATIN_SMALL_LETTER_G_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_G_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_G_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_G_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_H_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_H_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_H_WITH_STROKE,
   UC_LATIN_SMALL_LETTER_H_WITH_STROKE,
   UC_LATIN_SMALL_LETTER_I_WITH_TILDE,
   UC_LATIN_SMALL_LETTER_I_WITH_TILDE,
   UC_LATIN_SMALL_LETTER_I_WITH_MACRON,
   UC_LATIN_SMALL_LETTER_I_WITH_MACRON,
   UC_LATIN_SMALL_LETTER_I_WITH_BREVE,
   UC_LATIN_SMALL_LETTER_I_WITH_BREVE,
   UC_LATIN_SMALL_LETTER_I_WITH_OGONEK,
   UC_LATIN_SMALL_LETTER_I_WITH_OGONEK,
   UC_LATIN_CAPITAL_LETTER_I_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_DOTLESS_I,
   UC_LATIN_SMALL_LIGATURE_IJ,
   UC_LATIN_SMALL_LIGATURE_IJ,
   UC_LATIN_SMALL_LETTER_J_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_J_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_K_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_K_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_KRA,
   UC_LATIN_SMALL_LETTER_L_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_L_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_L_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_L_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_L_WITH_CARON,
   UC_LATIN_SMALL_LETTER_L_WITH_CARON,
   UC_LATIN_SMALL_LETTER_L_WITH_MIDDLE_DOT,
   UC_LATIN_SMALL_LETTER_L_WITH_MIDDLE_DOT,
   UC_LATIN_SMALL_LETTER_L_WITH_STROKE,
   UC_LATIN_SMALL_LETTER_L_WITH_STROKE,
   UC_LATIN_SMALL_LETTER_N_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_N_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_N_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_N_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_N_WITH_CARON,
   UC_LATIN_SMALL_LETTER_N_WITH_CARON,
   UC_LATIN_SMALL_LETTER_N_PRECEDED_BY_APOSTROPHE,
   UC_LATIN_CAPITAL_ENG,
   UC_LATIN_SMALL_LETTER_ENG,
   UC_LATIN_SMALL_LETTER_ENG,
   UC_LATIN_SMALL_LETTER_O_WITH_MACRON,
   UC_LATIN_SMALL_LETTER_O_WITH_MACRON,
   UC_LATIN_SMALL_LETTER_O_WITH_BREVE,
   UC_LATIN_SMALL_LETTER_O_WITH_BREVE,
   UC_LATIN_SMALL_LETTER_O_WITH_DOUBLE_ACUTE,
   UC_LATIN_SMALL_LETTER_O_WITH_DOUBLE_ACUTE,
   UC_LATIN_SMALL_LIGATURE_OE,
   UC_LATIN_SMALL_LIGATURE_OE,
   UC_LATIN_SMALL_LETTER_R_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_R_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_R_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_R_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_R_WITH_CARON,
   UC_LATIN_SMALL_LETTER_R_WITH_CARON,
   UC_LATIN_SMALL_LETTER_S_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_S_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_S_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_S_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_S_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_S_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_S_WITH_CARON,
   UC_LATIN_SMALL_LETTER_S_WITH_CARON,
   UC_LATIN_SMALL_LETTER_T_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_T_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_T_WITH_CARON,
   UC_LATIN_SMALL_LETTER_T_WITH_CARON,
   UC_LATIN_SMALL_LETTER_T_WITH_STROKE,
   UC_LATIN_SMALL_LETTER_T_WITH_STROKE,
   UC_LATIN_SMALL_LETTER_U_WITH_TILDE,
   UC_LATIN_SMALL_LETTER_U_WITH_TILDE,
   UC_LATIN_SMALL_LETTER_U_WITH_MACRON,
   UC_LATIN_SMALL_LETTER_U_WITH_MACRON,
   UC_LATIN_SMALL_LETTER_U_WITH_BREVE,
   UC_LATIN_SMALL_LETTER_U_WITH_BREVE,
   UC_LATIN_SMALL_LETTER_U_WITH_RING_ABOVE,
   UC_LATIN_SMALL_LETTER_U_WITH_RING_ABOVE,
   UC_LATIN_SMALL_LETTER_U_WITH_DOUBLE_ACUTE,
   UC_LATIN_SMALL_LETTER_U_WITH_DOUBLE_ACUTE,
   UC_LATIN_SMALL_LETTER_U_WITH_OGONEK,
   UC_LATIN_SMALL_LETTER_U_WITH_OGONEK,
   UC_LATIN_SMALL_LETTER_W_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_W_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_Y_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_Y_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS,
   UC_LATIN_SMALL_LETTER_Y_WITH_DIAERESIS,
   UC_LATIN_SMALL_LETTER_Z_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_Z_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_Z_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_Z_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_Z_WITH_CARON
};

static const U16BIT lowercase_chars_0x1E00[] =
{
   UC_LATIN_SMALL_LETTER_A_WITH_RING_BELOW,
   UC_LATIN_SMALL_LETTER_A_WITH_RING_BELOW,
   UC_LATIN_SMALL_LETTER_B_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_B_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_B_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_B_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_B_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_B_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_C_WITH_CEDILLA_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_C_WITH_CEDILLA_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_D_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_D_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_D_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_D_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_D_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_D_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_D_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_D_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_D_WITH_CIRCUMFLEX_BELOW,
   UC_LATIN_SMALL_LETTER_D_WITH_CIRCUMFLEX_BELOW,
   UC_LATIN_SMALL_LETTER_E_WITH_MACRON_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_E_WITH_MACRON_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_E_WITH_MACRON_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_E_WITH_MACRON_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_BELOW,
   UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_BELOW,
   UC_LATIN_SMALL_LETTER_E_WITH_TILDE_BELOW,
   UC_LATIN_SMALL_LETTER_E_WITH_TILDE_BELOW,
   UC_LATIN_SMALL_LETTER_E_WITH_CEDILLA_AND_BREVE,
   UC_LATIN_SMALL_LETTER_E_WITH_CEDILLA_AND_BREVE,
   UC_LATIN_SMALL_LETTER_F_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_F_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_G_WITH_MACRON,
   UC_LATIN_SMALL_LETTER_G_WITH_MACRON,
   UC_LATIN_SMALL_LETTER_H_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_H_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_H_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_H_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_H_WITH_DIAERESIS,
   UC_LATIN_SMALL_LETTER_H_WITH_DIAERESIS,
   UC_LATIN_SMALL_LETTER_H_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_H_WITH_CEDILLA,
   UC_LATIN_SMALL_LETTER_H_WITH_BREVE_BELOW,
   UC_LATIN_SMALL_LETTER_H_WITH_BREVE_BELOW,
   UC_LATIN_SMALL_LETTER_I_WITH_TILDE_BELOW,
   UC_LATIN_SMALL_LETTER_I_WITH_TILDE_BELOW,
   UC_LATIN_SMALL_LETTER_I_WITH_DIAERESIS_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_I_WITH_DIAERESIS_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_K_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_K_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_K_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_K_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_K_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_K_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_L_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_L_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_L_WITH_DOT_BELOW_AND_MACRON,
   UC_LATIN_SMALL_LETTER_L_WITH_DOT_BELOW_AND_MACRON,
   UC_LATIN_SMALL_LETTER_L_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_L_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_L_WITH_CIRCUMFLEX_BELOW,
   UC_LATIN_SMALL_LETTER_L_WITH_CIRCUMFLEX_BELOW,
   UC_LATIN_SMALL_LETTER_M_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_M_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_M_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_M_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_M_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_M_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_N_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_N_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_N_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_N_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_N_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_N_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_N_WITH_CIRCUMFLEX_BELOW,
   UC_LATIN_SMALL_LETTER_N_WITH_CIRCUMFLEX_BELOW,
   UC_LATIN_SMALL_LETTER_O_WITH_TILDE_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_O_WITH_TILDE_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_O_WITH_TILDE_AND_DIAERESIS,
   UC_LATIN_SMALL_LETTER_O_WITH_TILDE_AND_DIAERESIS,
   UC_LATIN_SMALL_LETTER_O_WITH_MACRON_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_O_WITH_MACRON_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_O_WITH_MACRON_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_O_WITH_MACRON_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_P_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_P_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_P_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_P_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_R_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_R_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_R_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_R_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_R_WITH_DOT_BELOW_AND_MACRON,
   UC_LATIN_SMALL_LETTER_R_WITH_DOT_BELOW_AND_MACRON,
   UC_LATIN_SMALL_LETTER_R_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_R_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_S_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_S_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_S_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_S_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_S_WITH_ACUTE_AND_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_S_WITH_CARON_AND_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_S_WITH_CARON_AND_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_S_WITH_DOT_BELOW_AND_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_T_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_T_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_T_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_T_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_T_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_T_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_T_WITH_CIRCUMFLEX_BELOW,
   UC_LATIN_SMALL_LETTER_T_WITH_CIRCUMFLEX_BELOW,
   UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS_BELOW,
   UC_LATIN_SMALL_LETTER_U_WITH_DIAERESIS_BELOW,
   UC_LATIN_SMALL_LETTER_U_WITH_TILDE_BELOW,
   UC_LATIN_SMALL_LETTER_U_WITH_TILDE_BELOW,
   UC_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX_BELOW,
   UC_LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX_BELOW,
   UC_LATIN_SMALL_LETTER_U_WITH_TILDE_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_U_WITH_TILDE_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_U_WITH_MACRON_AND_DIAERESIS,
   UC_LATIN_SMALL_LETTER_U_WITH_MACRON_AND_DIAERESIS,
   UC_LATIN_SMALL_LETTER_V_WITH_TILDE,
   UC_LATIN_SMALL_LETTER_V_WITH_TILDE,
   UC_LATIN_SMALL_LETTER_V_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_V_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_W_WITH_GRAVE,
   UC_LATIN_SMALL_LETTER_W_WITH_GRAVE,
   UC_LATIN_SMALL_LETTER_W_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_W_WITH_ACUTE,
   UC_LATIN_SMALL_LETTER_W_WITH_DIAERESIS,
   UC_LATIN_SMALL_LETTER_W_WITH_DIAERESIS,
   UC_LATIN_SMALL_LETTER_W_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_W_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_W_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_W_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_X_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_X_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_X_WITH_DIAERESIS,
   UC_LATIN_SMALL_LETTER_X_WITH_DIAERESIS,
   UC_LATIN_SMALL_LETTER_Y_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_Y_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_Z_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_Z_WITH_CIRCUMFLEX,
   UC_LATIN_SMALL_LETTER_Z_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_Z_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_Z_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_Z_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_H_WITH_LINE_BELOW,
   UC_LATIN_SMALL_LETTER_T_WITH_DIAERESIS,
   UC_LATIN_SMALL_LETTER_W_WITH_RING_ABOVE,
   UC_LATIN_SMALL_LETTER_Y_WITH_RING_ABOVE,
   UC_LATIN_SMALL_LETTER_A_WITH_RIGHT_HALF_RING,
   UC_LATIN_SMALL_LETTER_LONG_S_WITH_DOT_ABOVE,
   UC_LATIN_SMALL_LETTER_LONG_S_WITH_DIAGONAL_STROKE,
   UC_LATIN_SMALL_LETTER_LONG_S_WITH_HIGH_STROKE,
   UC_LATIN_SMALL_LETTER_SHARP_S,
   UC_LATIN_SMALL_LETTER_DELTA,
   UC_LATIN_SMALL_LETTER_A_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_A_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_A_WITH_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_A_WITH_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE,
   UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_TILDE,
   UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX_AND_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_TILDE,
   UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_TILDE,
   UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_A_WITH_BREVE_AND_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_E_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_E_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_E_WITH_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_E_WITH_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_E_WITH_TILDE,
   UC_LATIN_SMALL_LETTER_E_WITH_TILDE,
   UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE,
   UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_TILDE,
   UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX_AND_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_I_WITH_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_I_WITH_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_I_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_I_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_O_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_O_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_O_WITH_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_O_WITH_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE,
   UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_TILDE,
   UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX_AND_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_TILDE,
   UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_TILDE,
   UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_O_WITH_HORN_AND_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_U_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_U_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_U_WITH_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_U_WITH_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_ACUTE,
   UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_GRAVE,
   UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_TILDE,
   UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_TILDE,
   UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_U_WITH_HORN_AND_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_Y_WITH_GRAVE,
   UC_LATIN_SMALL_LETTER_Y_WITH_GRAVE,
   UC_LATIN_SMALL_LETTER_Y_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_Y_WITH_DOT_BELOW,
   UC_LATIN_SMALL_LETTER_Y_WITH_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_Y_WITH_HOOK_ABOVE,
   UC_LATIN_SMALL_LETTER_Y_WITH_TILDE,
   UC_LATIN_SMALL_LETTER_Y_WITH_TILDE,
   UC_LATIN_SMALL_LETTER_MIDDLE_WELSH_LL,
   UC_LATIN_SMALL_LETTER_MIDDLE_WELSH_LL,
   UC_LATIN_SMALL_LETTER_MIDDLE_WELSH_V,
   UC_LATIN_SMALL_LETTER_MIDDLE_WELSH_V,
   UC_LATIN_SMALL_LETTER_Y_WITH_LOOP
};

//---function prototypes----------------------------------------------------------------------------



#endif //  _ASCIIMAP_H

//**************************************************************************************************
// End of File
//**************************************************************************************************
