/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   EBU Teletext driver font declaration
 *
 * @file    fn12x10.c
 * @date    04/06/2004
 * @author  Ocean Blue
 */

//---includes for this file----------------------------------------------------
// compiler library header files

#include <stdio.h>
#include <stdlib.h>

// third party header files

// Ocean Blue Software header files

#include <techtype.h>

#define _FN12X10_C

#include "stbebutt.h"

//---constant definitions for this file----------------------------------------

//---local typedef structs for this file---------------------------------------

//---local (static) variable declarations for this file------------------------
//   (internal variables declared static to make them local)

// Font table - Latin G0 Set (16 rows,6 columns,12x10 characters)
static const U8BIT font_table_latin_g0_set[96][120] =
{
   {  // character 0x20
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x21
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x22
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x23
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x24
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x25
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      1, 1, 2, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x26
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x27
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x28
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x29
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x30
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x31
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x32
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x33
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x34
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x35
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x36
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x37
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x38
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x39
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x40
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x41
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x42
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x43
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x44
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x45
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x46
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x47
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x48
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x49
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x50
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x51
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2
   },
   {  // character 0x52
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x53
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x54
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x55
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x56
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x57
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x58
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x59
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5B
      4, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5D
      4, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5E
      4, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2
   },
   {  // character 0x60
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x61
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x62
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x63
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x64
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x65
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x66
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x67
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x68
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x69
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 1, 2, 0,
      0, 3, 1, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x70
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x71
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2
   },
   {  // character 0x72
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x73
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x74
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x75
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x76
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x77
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x78
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x79
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7B
      4, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7D
      4, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7E
      4, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 3, 1,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   }
};

// Font table - Latin G2 Supplimentary Set (16 rows,6 columns,12x10 characters)
static const U8BIT font_table_latin_g2_supplimentary_set[96][120] =
{
   {  // character 0x20
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x21
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x22
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0
   },
   {  // character 0x23
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x24
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x25
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x26
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x27
      4, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x28
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x29
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0
   },
   {  // character 0x2E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2F
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x30
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x31
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x32
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x33
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x34
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x35
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 2, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x36
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x37
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x38
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x39
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 2, 0, 3, 1, 1,
      0, 0, 3, 1, 2, 3, 2, 0, 3, 2, 3, 1,
      0, 0, 0, 0, 3, 2, 0, 3, 2, 0, 3, 1,
      0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 3, 2, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 3, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 3, 1, 1,
      0, 3, 1, 1, 1, 1, 2, 0, 3, 2, 3, 1,
      0, 0, 0, 0, 3, 2, 0, 3, 2, 0, 3, 1,
      0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x40
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x41
      0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x42
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x43
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x44
      0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0,
      0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x45
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x46
      0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x47
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x48
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x49
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x4A
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4B
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4C
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0
   },
   {  // character 0x4D
      0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4E
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0
   },
   {  // character 0x4F
      0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x50
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x51
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x52
      4, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 3, 2, 0, 3, 1, 1, 1, 2, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 3, 1, 2, 0, 3,
      0, 3, 2, 0, 3, 1, 1, 1, 2, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 3, 2, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 3, 1, 2, 0, 3,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x53
      4, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 3, 2, 0, 0, 3, 1, 1, 2, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 0, 3, 2, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 0, 0, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 0, 3, 2, 0, 3,
      0, 3, 2, 0, 0, 3, 1, 1, 2, 0, 0, 3,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x54
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0, 3,
      0, 0, 0, 3, 2, 0, 0, 3, 1, 2, 3, 1,
      0, 0, 0, 3, 2, 0, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 3, 2, 3,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 0, 3,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 0, 3,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x55
      4, 0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 2, 0, 3, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x56
      4, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x57
      4, 3, 1, 1, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 2, 0, 3, 2, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 1, 1,
      0, 3, 1, 1, 2, 0, 3, 2, 3, 2, 0, 3,
      1, 1, 2, 3, 1, 1, 1, 2, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x58
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x59
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 3, 2, 3, 2, 0, 3, 2,
      0, 0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 3, 2,
      0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 3, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 1, 1, 1,
      0, 3, 1, 1, 1, 2, 3, 2, 3, 2, 0, 3,
      0, 0, 0, 0, 0, 3, 2, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 3,
      0, 0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 2, 0,
      0, 3, 2, 0, 0, 0, 0, 0, 3, 2, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 3, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 2, 3, 2, 3, 2, 0, 3, 2,
      0, 0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 3, 2,
      0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 2, 0, 0, 3, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 3, 2, 3, 2, 0, 3, 2,
      0, 0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 3, 2,
      0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x60
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x61
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x62
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x63
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x64
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x65
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x66
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x67
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x68
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x69
      4, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6C
      4, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2
   },
   {  // character 0x6F
      4, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x70
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x71
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x72
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x73
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x74
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x75
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x76
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x77
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x78
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x79
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2
   },
   {  // character 0x7F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   }
};

// Font table - Cyrillic G0 Set (Option 1 - Serbian-Croatian) (16 rows,6 columns,12x10 characters)
static const U8BIT font_table_cyrillic_g0_set_option_1_serbian_croatian[96][120] =
{
   {  // character 0x20
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x21
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x22
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x23
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x24
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x25
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      1, 1, 2, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x26
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x27
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x28
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x29
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x30
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x31
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x32
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x33
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x34
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x35
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x36
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x37
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x38
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x39
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x40
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x41
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x42
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x43
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x44
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x45
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x46
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x47
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x48
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x49
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x50
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x51
      4, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x52
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x53
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x54
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x55
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x56
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x57
      4, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x58
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1,
      0, 3, 1, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x59
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 3, 1,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 3, 1,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x60
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x61
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x62
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x63
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x64
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x65
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x66
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x67
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x68
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x69
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 2, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x70
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x71
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x72
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x73
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x74
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x75
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x76
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x77
      4, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x78
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 3, 1,
      0, 3, 1, 1, 2, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x79
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 3, 1,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   }
};

// Font table - Cyrillic G0 Set (Option 2 - Russian-Bulgarian) (16 rows,6 columns,12x10 characters)
static const U8BIT font_table_cyrillic_g0_set_option_2_russian_bulgarian[96][120] =
{
   {  // character 0x20
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x21
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x22
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x23
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x24
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x25
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      1, 1, 2, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x26
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x27
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x28
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x29
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x30
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x31
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x32
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x33
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x34
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x35
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x36
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x37
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x38
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x39
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x40
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x41
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x42
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x43
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x44
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x45
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x46
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x47
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x48
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x49
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4A
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x50
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x51
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x52
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x53
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x54
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x55
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x56
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x57
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x58
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x59
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x60
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x61
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x62
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x63
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x64
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x65
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x66
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x67
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x68
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x69
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 2, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 2, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x70
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x71
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x72
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x73
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x74
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x75
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x76
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x77
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x78
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x79
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   }
};

// Font table - Cyrillic G0 Set (Option 3 - Ukranian) (16 rows,6 columns,12x10 characters)
static const U8BIT font_table_cyrillic_g0_set_option_3_ukranian[96][120] =
{
   {  // character 0x20
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x21
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x22
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x23
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x24
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x25
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      1, 1, 2, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x26
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x27
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x28
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x29
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x30
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x31
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x32
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x33
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x34
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x35
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x36
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x37
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x38
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x39
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x40
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x41
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x42
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x43
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x44
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x45
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x46
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x47
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x48
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x49
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4A
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x50
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x51
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x52
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x53
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x54
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x55
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x56
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x57
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x58
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x59
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5F
      4, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x60
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x61
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x62
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x63
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x64
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x65
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x66
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x67
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x68
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x69
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 2, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 2, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x70
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x71
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x72
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x73
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x74
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x75
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x76
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x77
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x78
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x79
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   }
};

// Font table - Cyrillic G2 Supplimentary Set (16 rows,6 columns,12x10 characters)
static const U8BIT font_table_cyrillic_g2_supplimentary_set[96][120] =
{
   {  // character 0x20
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x21
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x22
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0
   },
   {  // character 0x23
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x24
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x25
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x26
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x27
      4, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x28
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x29
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0
   },
   {  // character 0x2E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2F
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x30
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x31
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x32
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x33
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x34
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x35
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 2, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x36
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x37
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x38
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x39
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 2, 0, 3, 1, 1,
      0, 0, 3, 1, 2, 3, 2, 0, 3, 2, 3, 1,
      0, 0, 0, 0, 3, 2, 0, 3, 2, 0, 3, 1,
      0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 3, 2, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 3, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 3, 1, 1,
      0, 3, 1, 1, 1, 1, 2, 0, 3, 2, 3, 1,
      0, 0, 0, 0, 3, 2, 0, 3, 2, 0, 3, 1,
      0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x40
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x41
      4, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x42
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x43
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x44
      4, 0, 3, 1, 1, 1, 2, 0, 3, 2, 0, 0,
      0, 0, 3, 2, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x45
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x46
      4, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x47
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x48
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x49
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0
   },
   {  // character 0x4A
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 2, 0, 3, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0
   },
   {  // character 0x4C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2
   },
   {  // character 0x4D
      4, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0
   },
   {  // character 0x4F
      4, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x50
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x51
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x52
      4, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 3, 2, 0, 3, 1, 1, 1, 2, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 3, 1, 2, 0, 3,
      0, 3, 2, 0, 3, 1, 1, 1, 2, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 3, 2, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 3, 1, 2, 0, 3,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x53
      4, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 3, 2, 0, 0, 3, 1, 1, 2, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 0, 3, 2, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 0, 0, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 0, 3, 2, 0, 3,
      0, 3, 2, 0, 0, 3, 1, 1, 2, 0, 0, 3,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x54
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0, 3,
      0, 0, 0, 3, 2, 0, 0, 3, 1, 2, 3, 1,
      0, 0, 0, 3, 2, 0, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 3, 2, 3,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 0, 3,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 0, 3,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x55
      4, 0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 2, 0, 3, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x56
      4, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x57
      4, 3, 1, 1, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 2, 0, 3, 2, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 1, 1,
      0, 3, 1, 1, 2, 0, 3, 2, 3, 2, 0, 3,
      1, 1, 2, 3, 1, 1, 1, 2, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x58
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x59
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 3, 2, 3, 2, 0, 3, 2,
      0, 0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 3, 2,
      0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 3, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 1, 1, 1,
      0, 3, 1, 1, 1, 2, 3, 2, 3, 2, 0, 3,
      0, 0, 0, 0, 0, 3, 2, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 3,
      0, 0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 2, 0,
      0, 3, 2, 0, 0, 0, 0, 0, 3, 2, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 3, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 2, 3, 2, 3, 2, 0, 3, 2,
      0, 0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 3, 2,
      0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 2, 0, 0, 3, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 3, 2, 3, 2, 0, 3, 2,
      0, 0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 3, 2,
      0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x60
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x61
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x62
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x63
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x64
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x65
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x66
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x67
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x68
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 1, 2,

      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x69
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2
   },
   {  // character 0x6A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x70
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x71
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x72
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x73
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x74
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x75
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x76
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x77
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x78
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x79
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2
   },
   {  // character 0x7A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   }
};

// Font table - Greek G0 Set (16 rows,6 columns,12x10 characters)
static const U8BIT font_table_greek_g0_set[96][120] =
{
   {  // character 0x20
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x21
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x22
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x23
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x24
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x25
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      1, 1, 2, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x26
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x27
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x28
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x29
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x30
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x31
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x32
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x33
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x34
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x35
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x36
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x37
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x38
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x39
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x40
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x41
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x42
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x43
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x44
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x45
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 2, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x46
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 2, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 2, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x47
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x48
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x49
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 2, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 2, 0, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 2, 0, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x50
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x51
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x52
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x53
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x54
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 2, 0, 0, 3, 1, 2, 0, 0, 3, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x55
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x56
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x57
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x58
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x59
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5A
      4, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5B
      4, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 2, 0, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x60
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x61
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x62
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x63
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 2, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x64
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x65
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x66
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x67
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x68
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x69
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x70
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x71
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x72
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x73
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x74
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x75
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x76
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x77
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x78
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x79
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   }
};

// Font table - Greek G2 Supplimentary Set (16 rows,6 columns,12x10 characters)
static const U8BIT font_table_greek_g2_supplimentary_set[96][120] =
{
   {  // character 0x20
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x21
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x22
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x23
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x24
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x25
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x26
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x27
      4, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x28
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x29
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0
   },
   {  // character 0x2E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2F
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x30
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x31
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x32
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x33
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x34
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x35
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 1, 2, 0,
      0, 3, 1, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x36
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x37
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x38
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x39
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 2, 0, 3, 1, 1,
      0, 0, 3, 1, 2, 3, 2, 0, 3, 2, 3, 1,
      0, 0, 0, 0, 3, 2, 0, 3, 2, 0, 3, 1,
      0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 3, 2, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 3, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 3, 1, 1,
      0, 3, 1, 1, 1, 1, 2, 0, 3, 2, 3, 1,
      0, 0, 0, 0, 3, 2, 0, 3, 2, 0, 3, 1,
      0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x40
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x41
      0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x42
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x43
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x44
      0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0,
      0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x45
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x46
      0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x47
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x48
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x49
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x4A
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4B
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4C
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0
   },
   {  // character 0x4D
      0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4E
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0
   },
   {  // character 0x4F
      0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x50
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x51
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x52
      4, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 3, 2, 0, 3, 1, 1, 1, 2, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 3, 1, 2, 0, 3,
      0, 3, 2, 0, 3, 1, 1, 1, 2, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 3, 2, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 3, 1, 2, 0, 3,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x53
      4, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 3, 2, 0, 0, 3, 1, 1, 2, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 0, 3, 2, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 0, 0, 0, 0, 3,
      0, 3, 2, 0, 3, 2, 0, 0, 3, 2, 0, 3,
      0, 3, 2, 0, 0, 3, 1, 1, 2, 0, 0, 3,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x54
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0, 3,
      0, 0, 0, 3, 2, 0, 0, 3, 1, 2, 3, 1,
      0, 0, 0, 3, 2, 0, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 3, 2, 3,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 0, 3,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 0, 3,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x55
      4, 0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 2, 0, 3, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x56
      4, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x57
      4, 3, 1, 1, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 2, 0, 3, 2, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 1, 1,
      0, 3, 1, 1, 2, 0, 3, 2, 3, 2, 0, 3,
      1, 1, 2, 3, 1, 1, 1, 2, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x58
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x59
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      1, 1, 2, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 2, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      1, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 2, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      1, 1, 2, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 3, 2, 3, 2, 0, 3, 2,
      0, 0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 3, 2,
      0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 3, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 1, 1, 1,
      0, 3, 1, 1, 1, 2, 3, 2, 3, 2, 0, 3,
      0, 0, 0, 0, 0, 3, 2, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 3,
      0, 0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 2, 0,
      0, 3, 2, 0, 0, 0, 0, 0, 3, 2, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 3, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 2, 3, 2, 3, 2, 0, 3, 2,
      0, 0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 3, 2,
      0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 2, 0, 0, 3, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 3, 2, 3, 2, 0, 3, 2,
      0, 0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 0, 3, 2,
      0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x60
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x61
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x62
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x63
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x64
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x65
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x66
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2
   },
   {  // character 0x67
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x68
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x69
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 2, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      1, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 2, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      1, 1, 2, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x70
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x71
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x72
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x73
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x74
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x75
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x76
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2
   },
   {  // character 0x77
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x78
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x79
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 2, 3, 1, 2, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   }
};

// Font table - Arabic G0 Set (16 rows,6 columns,12x10 characters)
static const U8BIT font_table_arabic_g0_set[96][120] =
{
   {  // character 0x20
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x21
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x22
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x23
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x24
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x25
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      1, 1, 2, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x26
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
      0, 0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 3, 1,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2
   },
   {  // character 0x27
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2,
      1, 1, 2, 0, 0, 0, 3, 1, 2, 0, 3, 1,
      1, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0, 3,
      0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0
   },
   {  // character 0x28
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x29
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x30
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x31
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x32
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x33
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x34
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x35
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x36
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x37
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x38
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x39
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x40
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x41
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x42
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 2, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x43
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x44
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 2, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x45
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x46
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x47
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x48
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x49
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x50
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x51
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0
   },
   {  // character 0x52
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0
   },
   {  // character 0x53
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 2, 0, 0, 3, 1, 1, 2, 0, 3, 1,
      0, 3, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x54
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 2, 0, 0, 3, 1, 1, 2, 0, 3, 1,
      0, 3, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x55
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1,
      1, 1, 2, 0, 3, 1, 2, 0, 0, 0, 3, 1,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x56
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1,
      1, 1, 2, 0, 3, 1, 2, 0, 0, 0, 3, 1,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x57
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 3, 1,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x58
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 3, 1,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x59
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 2, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      1, 1, 1, 1, 1, 1, 2, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      1, 1, 1, 1, 1, 1, 2, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      1, 1, 1, 1, 1, 1, 2, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x60
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x61
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x62
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x63
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x64
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x65
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x66
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x67
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2,
      1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x68
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0
   },
   {  // character 0x69
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 3, 2, 0, 0, 0, 3, 1, 2, 0, 3, 1,
      1, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      1, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0, 0
   },
   {  // character 0x6A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 3,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2
   },
   {  // character 0x6D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 3,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2
   },
   {  // character 0x6E
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 3,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2
   },
   {  // character 0x6F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 2, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x70
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 3, 2, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      1, 1, 2, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      1, 1, 2, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x71
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x72
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x73
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 2, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x74
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1,
      1, 1, 2, 0, 0, 0, 0, 3, 1, 1, 1, 1,
      1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x75
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 2, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x76
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1,
      0, 3, 2, 0, 0, 0, 0, 3, 1, 1, 1, 1,
      1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x77
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 3, 1,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 3, 1,
      1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x78
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x79
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      1, 1, 1, 2, 3, 1, 1, 1, 2, 3, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0
   },
   {  // character 0x7C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 2, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   }
};

// Font table - Arabic G2 Supplimentary Set (16 rows,6 columns,12x10 characters)
static const U8BIT font_table_arabic_g2_supplimentary_set[96][120] =
{
   {  // character 0x20
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x21
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2
   },
   {  // character 0x22
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x23
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x24
      4, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0
   },
   {  // character 0x25
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0
   },
   {  // character 0x26
      4, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x27
      4, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2,
      1, 1, 2, 0, 0, 0, 3, 1, 2, 0, 3, 1,
      1, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0, 3,
      0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x28
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0
   },
   {  // character 0x29
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0
   },
   {  // character 0x2A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 3,
      0, 3, 1, 2, 0, 0, 0, 3, 2, 3, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 2, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2
   },
   {  // character 0x2B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0
   },
   {  // character 0x2C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      1, 1, 1, 1, 1, 2, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0
   },
   {  // character 0x2D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0
   },
   {  // character 0x2E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0
   },
   {  // character 0x2F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 3, 1, 1, 1,
      1, 1, 1, 2, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x30
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x31
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x32
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x33
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x34
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x35
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x36
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x37
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x38
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x39
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 3, 1, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2
   },
   {  // character 0x3B
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2
   },
   {  // character 0x3C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0
   },
   {  // character 0x3E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x40
      4, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x41
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x42
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x43
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x44
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x45
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x46
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x47
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x48
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x49
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x50
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x51
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2
   },
   {  // character 0x52
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x53
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x54
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x55
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x56
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x57
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x58
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x59
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5C
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5D
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5E
      4, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 3, 1, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2
   },
   {  // character 0x60
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x61
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x62
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x63
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x64
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x65
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x66
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x67
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x68
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x69
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 3, 1, 2, 3, 1, 1, 2, 0,
      0, 3, 1, 1, 2, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x70
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x71
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2
   },
   {  // character 0x72
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x73
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x74
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x75
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x76
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x77
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x78
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x79
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7B
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7C
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7D
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 0x7F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   }
};

// Font table - Hebrew G0 Set (16 rows,6 columns,12x10 characters)
static const U8BIT font_table_hebrew_g0_set[96][120] =
{
   {  // character 0x20
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x21
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x22
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x23
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x24
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x25
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      1, 1, 2, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x26
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x27
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x28
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x29
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,

      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x30
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x31
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x32
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x33
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x34
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x35
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x36
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x37
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x38
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x39
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x40
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x41
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x42
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x43
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x44
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x45
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x46
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x47
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x48
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x49
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x50
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x51
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2
   },
   {  // character 0x52
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x53
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x54
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x55
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x56
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x57
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x58
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x59
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2
   },
   {  // character 0x5D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0
   },
   {  // character 0x5F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x60
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x61
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x62
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x63
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x64
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x65
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x66
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x67
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x68
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x69
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0
   },
   {  // character 0x6B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6C
      4, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0,

      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0
   },
   {  // character 0x70
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x71
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x72
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x73
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0
   },
   {  // character 0x74
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x75
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x76
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x77
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x78
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x79
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7B
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 2, 0,
      0, 0, 0, 3, 2, 0, 0, 3, 2, 3, 2, 0,
      0, 0, 0, 3, 2, 3, 2, 3, 2, 3, 2, 0,
      0, 0, 0, 3, 2, 3, 2, 3, 2, 3, 2, 0,
      0, 0, 0, 3, 2, 3, 2, 0, 0, 3, 2, 0,
      0, 0, 0, 3, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2
   },
   {  // character 0x7E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   }
};

// Font table - G1 Block Mosaics Set (16 rows,6 columns,12x10 characters)
static const U8BIT font_table_g1_block_mosaics_set[96][120] =
{
   {  // character 0x20
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x21
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x22
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x23
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x24
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x25
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x26
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x27
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x28
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x29
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2A
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2B
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2C
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2D
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2E
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2F
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x30
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x31
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x32
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x33
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x34
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x35
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x36
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x37
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x38
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x39
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3A
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3B
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3C
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3D
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3E
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x3F
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x40
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x41
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x42
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x43
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x44
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x45
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x46
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x47
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x48
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x49
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 2, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 1, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x50
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x51
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x52
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x53
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x54
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x55
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x56
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x57
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x58
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x59
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5A
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5B
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5C
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 2, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5D
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5E
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5F
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x60
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x61
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x62
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x63
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x64
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x65
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x66
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x67
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x68
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x69
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x6A
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x6B
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x6C
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x6D
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x6E
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x6F
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x70
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x71
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x72
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x73
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x74
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x75
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x76
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x77
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x78
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x79
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x7A
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x7B
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x7C
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x7D
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x7E
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x7F
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   }
};

// Font table - G3 Smooth Mosaics - Line Drawing Set (16 rows,6 columns,12x10 characters)
static const U8BIT font_table_g3_smooth_mosaics_line_drawing_set[96][120] =
{
   {  // character 0x20
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x21
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0
   },
   {  // character 0x22
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x23
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0
   },
   {  // character 0x24
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x25
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0
   },
   {  // character 0x26
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x27
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x28
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x29
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x2A
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x2B
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x2C
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x2D
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x2E
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x2F
      1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0,
      0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1,
      1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0,
      0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1,
      1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0,
      0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1,
      1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0,
      0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1,
      1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0,
      0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1
   },
   {  // character 0x30
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1
   },
   {  // character 0x31
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x32
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x33
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x34
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x35
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x36
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x37
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x38
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x39
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x3A
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x3B
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x3C
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0
   },
   {  // character 0x3D
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1
   },
   {  // character 0x3E
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0
   },
   {  // character 0x3F
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x40
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x41
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x42
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x43
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x44
      0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x45
      0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0
   },
   {  // character 0x46
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0,
      0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0
   },
   {  // character 0x47
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0,
      0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x48
      0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x49
      0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4A
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x4B
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0
   },
   {  // character 0x4C
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x4D
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4E
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x4F
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x50
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x51
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x52
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x53
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x54
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x55
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x56
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x57
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x58
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x59
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5A
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x5B
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5C
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5D
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x5E
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x5F
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x60
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x61
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1
   },
   {  // character 0x62
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x63
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1
   },
   {  // character 0x64
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1
   },
   {  // character 0x65
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1
   },
   {  // character 0x66
      1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x67
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x68
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x69
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6A
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6B
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6C
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6D
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6E
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x6F
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x70
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0
   },
   {  // character 0x71
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x72
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x73
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x74
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x75
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x76
      0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x77
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x78
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x79
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7A
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7B
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7C
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1
   },
   {  // character 0x7D
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
      0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0,
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0
   },
   {  // character 0x7E
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 0x7F
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   }
};

// Font table - Latin National Option Subset (13 rows,13 columns,12x10 characters)
static const U8BIT font_table_latin_national_option_subset[169][120] =
{
   {  // character 2/3  Czech/Slovak
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/3  English
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/3  Estonian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/3  French
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/3  German
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/3  Italian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/3  Lettish/Lithuanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/3  Polish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/3  Portuguese/Spanish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 2/3  Rumanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/3  Serb/Croat/Slovenian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/3  Swedish/Finnish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/3  Turkish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/4  Czech/Slovak
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/4  English
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/4  Estonian
      4, 0, 0, 3, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/4  French
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/4  German
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/4  Italian
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/4  Lettish/Lithuanian
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/4  Polish
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/4  Portuguese/Spanish
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/4  Rumanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/4  Serb/Croat/Slovenian
      4, 0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/4  Swedish/Finnish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 2/4  Turkish
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 4/0  Czech/Slovak
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 4/0  English
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 3, 1, 2, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 4/0  Estonian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 4/0  French
      4, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 4/0  German
      4, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 4/0  Italian
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 4/0  Lettish/Lithuanian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 4/0  Polish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0
   },
   {  // character 4/0  Portuguese/Spanish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 4/0  Rumanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 4/0  Serb/Croat/Slovenian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 4/0  Swedish/Finnish
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 4/0  Turkish
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/B  Czech/Slovak
      4, 0, 0, 0, 0, 0, 0, 3, 1, 2, 3, 1,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 1, 1, 2,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/B  English
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/B  Estonian
      4, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/B  French
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/B  German
      4, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/B  Italian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/B  Lettish/Lithuanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/B  Polish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/B  Portuguese/Spanish
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/B  Rumanian
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/B  Serb/Croat/Slovenian
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/B  Swedish/Finnish
      4, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/B  Turkish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 5/C  Czech/Slovak
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/C  English
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 3, 2, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 3, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 2, 0, 0, 0, 3, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/C  Estonian
      4, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/C  French
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/C  German
      4, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/C  Italian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 5/C  Lettish/Lithuanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 5/C  Polish
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/C  Portuguese/Spanish
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/C  Rumanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 5/C  Serb/Croat/Slovenian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/C  Swedish/Finnish
      4, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/C  Turkish
      4, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/D  Czech/Slovak
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/D  English
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/D  Estonian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/D  French
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/D  German
      4, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/D  Italian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/D  Lettish/Lithuanian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/D  Polish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/D  Portuguese/Spanish
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/D  Rumanian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/D  Serb/Croat/Slovenian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 3, 1, 1, 1, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/D  Swedish/Finnish
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 2, 3, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/D  Turkish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 5/E  Czech/Slovak
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/E  English
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0
   },
   {  // character 5/E  Estonian
      4, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/E  French
      4, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/E  German
      4, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/E  Italian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0
   },
   {  // character 5/E  Lettish/Lithuanian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/E  Polish
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/E  Portuguese/Spanish
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/E  Rumanian
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/E  Serb/Croat/Slovenian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/E  Swedish/Finnish
      4, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/E  Turkish
      4, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/F  Czech/Slovak
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/F  English
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/F  Estonian
      4, 0, 0, 3, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/F  French
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/F  German
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2
   },
   {  // character 5/F  Italian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/F  Lettish/Lithuanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/F  Polish
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/F  Portuguese/Spanish
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/F  Rumanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/F  Serb/Croat/Slovenian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 5/F  Swedish/Finnish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2
   },
   {  // character 5/F  Turkish
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 6/0  Czech/Slovak
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 6/0  English
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 6/0  Estonian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 6/0  French
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 6/0  German
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 6/0  Italian
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 6/0  Lettish/Lithuanian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 6/0  Polish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0
   },
   {  // character 6/0  Portuguese/Spanish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 6/0  Rumanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 6/0  Serb/Croat/Slovenian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 6/0  Swedish/Finnish
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 6/0  Turkish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/B  Czech/Slovak
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/B  English
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 2, 0, 0, 0, 0, 3, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 3, 2, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 3, 2, 0, 3, 1, 1,
      0, 0, 3, 1, 2, 3, 2, 0, 3, 2, 3, 1,
      0, 0, 0, 0, 3, 2, 0, 3, 2, 0, 3, 1,
      0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/B  Estonian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/B  French
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/B  German
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/B  Italian
      4, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/B  Lettish/Lithuanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0
   },
   {  // character 7/B  Polish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/B  Portuguese/Spanish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/B  Rumanian
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/B  Serb/Croat/Slovenian
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/B  Swedish/Finnish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/B  Turkish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 7/C  Czech/Slovak
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/C  English
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/C  Estonian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/C  French
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/C  German
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/C  Italian
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/C  Lettish/Lithuanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0
   },
   {  // character 7/C  Polish
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/C  Portuguese/Spanish
      4, 0, 0, 3, 1, 1, 1, 2, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 3, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 1, 2, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/C  Rumanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 7/C  Serb/Croat/Slovenian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/C  Swedish/Finnish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/C  Turkish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/D  Czech/Slovak
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/D  English
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 3, 1, 1, 1, 2, 0, 0, 0, 3, 2, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 3, 2, 0, 0,
      0, 0, 3, 1, 1, 2, 0, 3, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 3, 1, 1,
      0, 3, 1, 1, 1, 1, 2, 0, 3, 2, 3, 1,
      0, 0, 0, 0, 3, 2, 0, 3, 2, 0, 3, 1,
      0, 0, 0, 3, 2, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 3, 2, 0, 0, 0, 0, 0, 0, 3, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/D  Estonian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/D  French
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/D  German
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/D  Italian
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/D  Lettish/Lithuanian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/D  Polish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/D  Portuguese/Spanish
      4, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/D  Rumanian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/D  Serb/Croat/Slovenian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/D  Swedish/Finnish
      4, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/D  Turkish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 7/E  Czech/Slovak
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/E  English
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/E  Estonian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/E  French
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 7/E  German
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 2, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 3, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/E  Italian
      4, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/E  Lettish/Lithuanian
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0
   },
   {  // character 7/E  Polish
      4, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/E  Portuguese/Spanish
      4, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2, 0,
      0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/E  Rumanian
      4, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 2, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/E  Serb/Croat/Slovenian
      4, 0, 0, 0, 3, 1, 2, 3, 1, 2, 0, 0,
      0, 0, 0, 0, 0, 3, 1, 1, 2, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/E  Swedish/Finnish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   },
   {  // character 7/E  Turkish
      4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 3, 1, 2, 0, 0, 3, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 0, 3, 1, 2,
      0, 0, 3, 1, 2, 0, 0, 0, 3, 1, 1, 2,
      0, 0, 0, 3, 1, 1, 1, 1, 2, 3, 1, 2,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
   }
};

static const S_EBUTT_FONT ebutt_font_12x10 =
{
   12,
   10,

   0x00000089L,
   0x00000041L,


   {
      (U8BIT *)font_table_latin_g0_set,
      (U8BIT *)font_table_latin_g2_supplimentary_set,
      (U8BIT *)font_table_cyrillic_g0_set_option_1_serbian_croatian,
      (U8BIT *)font_table_cyrillic_g0_set_option_2_russian_bulgarian,
      (U8BIT *)font_table_cyrillic_g0_set_option_3_ukranian,
      (U8BIT *)font_table_cyrillic_g2_supplimentary_set,
      (U8BIT *)font_table_greek_g0_set,
      (U8BIT *)font_table_greek_g2_supplimentary_set,
      (U8BIT *)font_table_arabic_g0_set,
      (U8BIT *)font_table_arabic_g2_supplimentary_set,
      (U8BIT *)font_table_hebrew_g0_set,
      (U8BIT *)font_table_g1_block_mosaics_set,
      (U8BIT *)font_table_g3_smooth_mosaics_line_drawing_set
   },

   (U8BIT *)font_table_latin_national_option_subset
};

const S_EBUTT_FONT *const ebutt_font_ptr = &ebutt_font_12x10;

