/*******************************************************************************
 * Copyright  2016 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2012 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief    CI Content Control support - internal header
 * @file     stbci_int.h
 * @date     08 December 2016
 * @author   Adam Sturtridge
 */

#ifndef _STBCI_INT_H
#define _STBCI_INT_H

#include "techtype.h"

/*---Constant and macro definitions for public use-----------------------------*/

/*---Enumerations for public use-----------------------------------------------*/

/*---Global type defs for public use-------------------------------------------*/

/*---Global Function prototypes for public use---------------------------------*/

/**
 * @brief    CI descrambler keys support initialise
 */
void STB_CiKeysInitialise(void);

/**
 * @brief   Disable CC keys for slot, as CAM is being removed
 * @param   slot_id zero-based CI slot identifier (0, 1, ...)
 */
void STB_CiKeysDisable(U8BIT slot_id);

/**
 * @brief   Process CAM removal from slot for CI Keys support
 * @param   slot_id zero-based CI slot identifier (0, 1, ...)
 */
void STB_CiKeysRemove(U8BIT slot_id);

/**
 * @brief    CI conditional access support initialise
 */
void STB_CiCaInitialise(void);

/**
 * @brief   Disable CA for slot, as CAM is being removed
 * @param   slot_id zero-based CI slot identifier (0, 1, ...)
 */
void STB_CiCaDisable(U8BIT slot_id);

/**
 * @brief   Process CAM removal from slot for CA support
 * @param   slot_id zero-based CI slot identifier (0, 1, ...)
 */
void STB_CiCaRemove(U8BIT slot_id);

#endif /* _STBCI_INT_H */
